/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.annotations.JsonData;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonData
public abstract class UF_Visibility {
    private static List<UF_Visibility> ALL = new ArrayList<UF_Visibility>();
    private String key;
    public static final UF_Visibility COMPLETELY_HIDDEN = new UF_Visibility("completelyHidden"){

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("visibility.completelyHidden", new Object[0]);
        }
    };
    public static final UF_Visibility VISIBLE_FOR_ALL = new UF_Visibility("visibleForAll"){

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("visibility.visibleForAll", new Object[0]);
        }
    };
    public static final UF_Visibility VISIBLE_ONLY_FOR_USER_MANAGER = new UF_Visibility("visibleForUserManager"){

        @Override
        public boolean isVisible() {
            return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("visibility.onlyForUserManager", new Object[0]);
        }
    };
    public static final UF_Visibility VISIBLE_ONLY_FOR_USER_MANAGER_ADMIN = new UF_Visibility("visibleForUserManagerAdmin"){

        @Override
        public boolean isVisible() {
            return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("visibility.onlyForUserManagerAdmin", new Object[0]);
        }
    };

    public UF_Visibility(String key) {
        this.key = key;
        if (ALL.stream().anyMatch(i2 -> i2.key.equals(key))) {
            throw new IllegalArgumentException("Key already exists: " + key);
        }
        ALL.add(this);
    }

    public abstract boolean isVisible();

    public abstract String getLabel();

    @Nonnull
    public String toString() {
        return this.key;
    }

    public static UF_Visibility valueOf(String str) {
        Optional<UF_Visibility> optional = ALL.stream().filter(i2 -> i2.key.equals(str)).findFirst();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("No such key: " + str);
        }
        return optional.get();
    }

    public static List<UF_Visibility> values() {
        return new ArrayList<UF_Visibility>(ALL);
    }
}

