/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.permissions.Permission;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserGroupInfo
implements DisplayableKey<String> {
    private static Map<UserGroupKey, PredefinedUserGroup> a;
    private final GUID b;
    private final GUID c;
    @Nonnull
    private final String d;
    private final GroupType e;
    private final long f;
    private final boolean g;
    private final UserGroupMembership h;
    private final MutableUserGroupData i;
    @Nonnull
    private final Set<Permission> j;
    private Set<Permission> k;

    public static UserGroupInfo create(@Nullable GUID parentID, @Nonnull GUID groupID, @Nonnull String groupName, @Nonnull GroupType groupType, long lastModified, @Nonnull UserGroupMembership membership, @Nonnull MutableUserGroupData groupData, @Nonnull Set<Permission> permissions, boolean active) {
        return new UserGroupInfo(parentID, groupID, groupName, groupType, lastModified, membership, groupData, permissions, active);
    }

    protected UserGroupInfo(GUID parentID, @Nonnull GUID groupID, @Nonnull String groupName, @Nonnull GroupType groupType, long lastModified, @Nonnull UserGroupMembership membership, @Nonnull MutableUserGroupData groupData, @Nonnull Set<Permission> permissions, boolean active) {
        this.c = parentID;
        this.b = groupID;
        this.d = groupName;
        this.e = groupType;
        this.f = lastModified;
        this.h = membership;
        this.i = groupData.copy();
        this.j = Collections.unmodifiableSet(new HashSet<Permission>(permissions));
        this.g = active;
    }

    public GUID getID() {
        return this.b;
    }

    public boolean hasParent() {
        return this.getParentID() != null;
    }

    public GUID getParentID() {
        return this.c;
    }

    public UserGroupKey getGroupKey() {
        return UserGroupKey.of(this.d, this.e);
    }

    @Nonnull
    public String getName() {
        return this.d;
    }

    public GroupType getType() {
        return this.e;
    }

    public boolean isAuthenticationGroup() {
        return UsersAndGroups.GROUPTYPE_AUTH.equals(this.e);
    }

    public long getLastModified() {
        return this.f;
    }

    public boolean isActive() {
        return this.g;
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        Set<Permission> set = this.k;
        if (set == null) {
            this.k = set = Collections.unmodifiableSet(this.j.stream().filter(permission -> {
                try {
                    Permission.valueOf(permission.getKey());
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }).collect(Collectors.toSet()));
        }
        return set;
    }

    @Nonnull
    public Set<Permission> getPermissionsIncludingInactive() {
        return this.j;
    }

    @Nonnull
    public Set<GUID> getMemberIDs() {
        return this.h.getMemberIDs();
    }

    public Set<GUID> getMemberIDs(MembershipType membershipType) {
        return this.h.getMemberIDs(membershipType);
    }

    public boolean hasMembers() {
        return !this.h.isEmpty();
    }

    public boolean hasMember(GUID userID) {
        return this.h.contains(userID);
    }

    public Set<MembershipType> getAllMembershipTypes() {
        return this.h.getAllMembershipTypes();
    }

    public Set<MembershipType> getMembershipTypes(GUID userID) {
        return this.h.getMembershipTypes(userID);
    }

    public MemberToTypeCardinality getMemberToTypeCardinality() {
        return this.h.getMemberToTypeCardinality();
    }

    public <VALUE> VALUE getValue(UserGroupField<VALUE> field) {
        VALUE VALUE = this.i.get(field);
        return VALUE == null ? null : (VALUE)field.copyValue(VALUE);
    }

    public Set<UserGroupField<Object>> getIncludedFields() {
        return this.i.getIncludedFields();
    }

    public UserGroupInfo copyWith(UserGroupMembership membership) {
        return UserGroupInfo.create(this.c, this.b, this.d, this.e, this.f, membership, this.i, this.j, this.g);
    }

    @Override
    public String getKey() {
        return this.getID().toString();
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        Object object;
        if (a == null) {
            object = new HashMap();
            ServerPluginManager.getInstance().get(PredefinedUserGroup.class).forEach(arg_0 -> UserGroupInfo.a((Map)object, arg_0));
            a = object;
        }
        return (object = a.get(this.getGroupKey())) == null ? this.getName() : ((PredefinedUserGroup)object).getDisplayName();
    }

    private static /* synthetic */ void a(Map map, PredefinedUserGroup predefinedUserGroup) {
        map.put(predefinedUserGroup.getGroupKey(), predefinedUserGroup);
    }
}

