/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.error.ServiceUnavailableException;
import com.inet.id.GUID;
import com.inet.lib.i18n.DisplayableMapCache;
import com.inet.logging.LogManager;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.EventDispatcher;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.UsersAndGroupsEventLog;
import com.inet.usersandgroups.UsersAndGroupsEventLogWrapper;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociationMap;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.groups.persistence.FileSystemUserGroupPersistence;
import com.inet.usersandgroups.api.groups.persistence.UserGroupNodeSynchronizer;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistence;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchDataCache;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchEngine;
import com.inet.usersandgroups.api.user.AuthGroupMembersProvider;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.security.AccessController;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class BaseUserGroupManager
extends UserGroupManager {
    private final ReadWriteLock a = new ReentrantReadWriteLock();
    private final Lock b = this.a.readLock();
    private final Lock c = this.a.writeLock();
    private final UserGroupPersistence d;
    private final UserGroupSearchEngine e;
    private final AuthGroupMembersProvider f;
    private UserGroupSearchDataCache g;
    private Map<String, GroupTypeDef> h;
    private List<UserGroupField<Object>> i;
    private final EventDispatcher<UserGroupEventListener> j = new EventDispatcher();
    private final a<GUID, UserGroupInfo> k = new a();
    private HashMap<GUID, Set<UserGroupInfo>> l;
    private UsersAndGroupsEventLogWrapper m = (usersAndGroupsEventLog, gUID, string, objectArray) -> usersAndGroupsEventLog.log(gUID, string, objectArray);
    private CountDownLatch n = new CountDownLatch(1);
    private List<PredefinedUserGroup> o;

    public BaseUserGroupManager(UserGroupPersistence persistence, UserGroupSearchEngine searchEngine, AuthGroupMembersProvider authGroupMembersProvider) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        if (authGroupMembersProvider == null) {
            throw new IllegalArgumentException("provider of auth group members must not be null");
        }
        this.d = persistence;
        this.e = searchEngine;
        this.f = authGroupMembersProvider;
    }

    public void disableLoggingEvents() {
        this.m = (usersAndGroupsEventLog, gUID, string, objectArray) -> {};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(List<GroupTypeDef> groupTypes, List<UserGroupField<Object>> groupFields, List<PredefinedUserGroup> predefinedGroups) throws IOException {
        Object object;
        this.o = predefinedGroups;
        UsersAndGroups.throwIfNullOrContainsNull(groupTypes, "list \"groupTypes\"");
        if (groupTypes.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one group type");
        }
        UsersAndGroups.throwIfNullOrContainsNull(predefinedGroups, "list \"predefinedGroups\"");
        if (!predefinedGroups.isEmpty()) {
            object = predefinedGroups.stream().map(PredefinedUserGroup::getType).collect(Collectors.toList());
            object.removeAll(groupTypes.stream().map(GroupTypeDef::getGroupType).collect(Collectors.toList()));
            if (!object.isEmpty()) {
                String string3 = object.stream().map(GroupType::getName).reduce((string, string2) -> string + ", " + string2).get();
                throw new IllegalArgumentException("given group types must contain all types of predefined groups, non-included types: " + string3);
            }
            if ((long)predefinedGroups.size() != predefinedGroups.stream().map(PredefinedUserGroup::getGroupKey).distinct().count()) {
                List list = predefinedGroups.stream().map(predefinedUserGroup -> predefinedUserGroup.getGroupKey().toString()).collect(Collectors.toList());
                throw new IllegalArgumentException("given list of predefined groups must not contain duplicates: " + String.valueOf(list));
            }
        }
        try {
            this.c.lock();
            if (this.h != null) {
                throw new IllegalStateException("user group manager is already initialized");
            }
            object = new HashMap();
            groupTypes.forEach(arg_0 -> BaseUserGroupManager.a((Map)object, arg_0));
            this.h = Collections.unmodifiableMap(object);
            this.i = Collections.unmodifiableList(new ArrayList<UserGroupField<Object>>(groupFields));
            this.d.init(new HashSet<GroupTypeDef>(this.h.values()));
            this.g = this.createSearchDataCache(this.k, groupFields);
        }
        finally {
            this.c.unlock();
        }
        new Thread("User Group Search Engine Init"){

            @Override
            public void run() {
                AccessController.doPrivileged(() -> {
                    try {
                        boolean bl = false;
                        while (!bl) {
                            try {
                                BaseUserGroupManager.this.c();
                                BaseUserGroupManager.this.a();
                                BaseUserGroupManager.this.e.init(BaseUserGroupManager.this.g);
                                BaseUserGroupManager.this.b();
                                BaseUserGroupManager.this.g.indexAllPermissionsForGroupAdministrators();
                                bl = true;
                            }
                            catch (Throwable throwable) {
                                LogManager.getApplicationLogger().fatal(throwable);
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                BaseUserGroupManager.this.k.clear();
                            }
                        }
                    }
                    finally {
                        BaseUserGroupManager.this.n.countDown();
                    }
                    UserGroupNodeSynchronizer userGroupNodeSynchronizer = new UserGroupNodeSynchronizer(BaseUserGroupManager.this.d, BaseUserGroupManager.this.k);
                    BaseUserGroupManager.this.j.registerListener(userGroupNodeSynchronizer);
                    Persistence.getInstance().registerListener(userGroupNodeSynchronizer);
                    return null;
                });
            }
        }.start();
    }

    protected UserGroupSearchDataCache createSearchDataCache(@Nonnull Map<GUID, UserGroupInfo> groupInfoCache, @Nonnull List<UserGroupField<Object>> userGroupFields) {
        return new UserGroupSearchDataCache(groupInfoCache, userGroupFields);
    }

    private void a() throws IOException {
        for (PredefinedUserGroup predefinedUserGroup : this.o) {
            UserGroupInfo userGroupInfo = this.a(predefinedUserGroup.getName(), predefinedUserGroup.getType());
            if (userGroupInfo != null) continue;
            MutableUserGroupData mutableUserGroupData = predefinedUserGroup.getInitialData();
            mutableUserGroupData = mutableUserGroupData.copyWithSpecifiedFieldsOnly(FieldAndGroupTypeAssociationMap.getFieldsFor(predefinedUserGroup.getType()), true);
            userGroupInfo = this.d.saveNew(predefinedUserGroup.getGuid(), null, predefinedUserGroup.getName(), predefinedUserGroup.getType(), System.currentTimeMillis(), mutableUserGroupData);
            this.k.put(userGroupInfo.getID(), userGroupInfo);
            this.g.groupCreated(userGroupInfo);
            String string = this.h.get(predefinedUserGroup.getType().getName()).getDisplayName();
            this.m.log(UsersAndGroupsEventLog.GroupCreated, userGroupInfo.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo), predefinedUserGroup.getName(), string);
        }
    }

    private void b() throws IOException {
        for (PredefinedUserGroup predefinedUserGroup : this.o) {
            AndSearchExpression andSearchExpression = new AndSearchExpression();
            andSearchExpression.add(new SearchCondition("groupname", SearchCondition.SearchTermOperator.Equals, predefinedUserGroup.getGuid().toString()));
            andSearchExpression.add(new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, predefinedUserGroup.getType().getName()));
            SearchResult<GUID> searchResult = this.e.getSearchEngine().search(new SearchCommand(andSearchExpression));
            if (!searchResult.getEntries().isEmpty()) continue;
            this.e.getSearchEngine().reIndex();
            break;
        }
    }

    private void c() {
        Iterator<UserGroupInfo> iterator = this.d.getUserGroupInfoIterator();
        while (iterator.hasNext()) {
            UserGroupInfo userGroupInfo = iterator.next();
            this.k.put(userGroupInfo.getID(), userGroupInfo);
        }
    }

    private UserGroupSearchEngine d() {
        this.e();
        return this.e;
    }

    private void e() {
        if (this.n.getCount() > 0L) {
            if (ThreadUtils.isGuiThread()) {
                throw new ServiceUnavailableException();
            }
            while (true) {
                if (ShutdownManager.isShutDownInProgress()) {
                    return;
                }
                try {
                    if (!this.n.await(1L, TimeUnit.SECONDS)) continue;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public GUID createGroup(String groupName, GroupType groupType, MutableUserGroupData groupData) {
        return this.createGroup(null, groupName, groupType, groupData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID createGroup(@Nullable GUID parentID, String groupName, GroupType groupType, MutableUserGroupData groupData) {
        UserGroupInfo userGroupInfo;
        this.a(groupData, "groupData");
        this.a((Object)groupType, "groupType");
        GroupTypeDef groupTypeDef = this.a(groupType);
        if (groupTypeDef.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventCreation)) {
            String string = String.format("group with name \"%s\" and type \"%s\" can not be created due to definition of its type", groupName, groupType.getName());
            throw new IllegalArgumentException(string);
        }
        this.e();
        try {
            this.c.lock();
            this.a(parentID, groupName, groupTypeDef);
            this.a(groupName, groupTypeDef);
            groupData = groupData.copyWithSpecifiedFieldsOnly(FieldAndGroupTypeAssociationMap.getFieldsFor(groupType), true);
            userGroupInfo = this.d.saveNew(GUID.generateNew(), parentID, groupName, groupType, System.currentTimeMillis(), groupData);
            this.k.put(userGroupInfo.getID(), userGroupInfo);
            this.g.groupCreated(userGroupInfo);
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                userGroupEventListener.groupCreated(userGroupInfo);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        this.m.log(UsersAndGroupsEventLog.GroupCreated, userGroupInfo.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo), userGroupInfo.getName(), groupTypeDef.getDisplayName());
        return userGroupInfo.getID();
    }

    private void a(@Nullable GUID gUID, String string, GroupTypeDef groupTypeDef) {
        Function<String, String> function = string2 -> String.format("group with name \"%s\" and type \"%s\" can not be created because %s", string, groupTypeDef.getGroupType().getName(), string2);
        this.a(gUID, groupTypeDef, function, 0);
    }

    private void a(@Nonnull UserGroupInfo userGroupInfo, @Nullable GUID gUID) {
        if (gUID == null) {
            return;
        }
        GroupTypeDef groupTypeDef = this.a(userGroupInfo.getType());
        String string = groupTypeDef.getGroupType().getName();
        Set<UserGroupInfo> set = this.k.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        int n2 = UserGroupTreeUtils.checkTreeLevel(userGroupInfo.getID(), set) - 1;
        Function<String, String> function = string2 -> String.format("group with ID \"%s\" and type \"%s\" can not be associated with specified parent group because %s", userGroupInfo.getID().toString(), string, string2);
        this.a(gUID, groupTypeDef, function, n2);
        if (gUID.equals(userGroupInfo.getID())) {
            throw new IllegalArgumentException(function.apply("it would lead to cycle"));
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.add(userGroupInfo.getID());
        UserGroupInfo userGroupInfo2 = (UserGroupInfo)this.k.get(gUID);
        while (userGroupInfo2.getParentID() != null) {
            GUID gUID2 = userGroupInfo2.getParentID();
            if (hashSet.contains(gUID2)) {
                throw new IllegalArgumentException(function.apply("it would lead to cycle"));
            }
            hashSet.add(gUID2);
            userGroupInfo2 = (UserGroupInfo)this.k.get(gUID2);
        }
    }

    private void a(@Nullable GUID gUID, GroupTypeDef groupTypeDef, Function<String, String> function, int n2) {
        if (gUID == null) {
            return;
        }
        GroupType groupType = groupTypeDef.getGroupType();
        UserGroupInfo userGroupInfo = (UserGroupInfo)this.k.get(gUID);
        if (userGroupInfo == null) {
            throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.parentGroupDoesNotExist", gUID));
        }
        GroupType groupType2 = userGroupInfo.getType();
        if (!groupType2.equals(groupType)) {
            String string = String.format("group with ID \"%s\", which is specified as parent group, has different type: \"%s\"", gUID, groupType2.getName());
            throw new IllegalArgumentException(function.apply(string));
        }
        int n4 = groupTypeDef.getMaxTreeLevel();
        if (n4 == 1) {
            throw new IllegalArgumentException(function.apply("its type definition imposes flat structure"));
        }
        Consumer<Integer> consumer = n3 -> {
            if (n3 > n4) {
                throw new IllegalArgumentException((String)function.apply("its type definition limits levels in tree structure to " + n4));
            }
        };
        int n5 = 2;
        consumer.accept(n5 += n2);
        UserGroupInfo userGroupInfo2 = userGroupInfo;
        while (userGroupInfo2.getParentID() != null) {
            GUID gUID2 = userGroupInfo2.getParentID();
            if ((userGroupInfo2 = (UserGroupInfo)this.k.get(gUID2)) == null) {
                String string = String.format("one of the ancestors (ID \"%s\") of the group specified as parent (ID \"%s\"), does not exist", gUID2, gUID);
                throw new IllegalStateException(string);
            }
            consumer.accept(++n5);
        }
    }

    private void a(String string, GroupTypeDef groupTypeDef) {
        if (groupTypeDef.allowsNonUniqueNames()) {
            return;
        }
        GroupType groupType = groupTypeDef.getGroupType();
        UserGroupInfo userGroupInfo = this.a(string, groupType);
        if (userGroupInfo != null) {
            throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.groupAlreadyExists", userGroupInfo.getName(), groupTypeDef.getDisplayName()));
        }
    }

    private UserGroupInfo a(String string, GroupType groupType) {
        UserGroupKey userGroupKey = UserGroupKey.of(string, groupType);
        for (Map.Entry entry : this.k.entrySet()) {
            UserGroupInfo userGroupInfo = (UserGroupInfo)entry.getValue();
            if (!userGroupKey.equals(userGroupInfo.getGroupKey())) continue;
            return userGroupInfo;
        }
        return null;
    }

    private UserGroupInfo b(String string, GroupType groupType) {
        UserGroupKey userGroupKey = UserGroupKey.of(string, groupType);
        for (GUID gUID : this.k.keySet()) {
            UserGroupInfo userGroupInfo = (UserGroupInfo)this.k.get(gUID);
            if (!userGroupKey.equals(userGroupInfo.getGroupKey())) continue;
            return userGroupInfo;
        }
        return null;
    }

    private void a(Consumer<UserGroupInfo> consumer) {
        for (GUID gUID : this.k.keySet()) {
            consumer.accept((UserGroupInfo)this.k.get(gUID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParentGroup(GUID groupID, GUID parentID) {
        UserGroupInfo userGroupInfo2;
        UserGroupInfo userGroupInfo3;
        this.a(groupID, "groupID");
        this.e();
        try {
            this.c.lock();
            userGroupInfo3 = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b(userGroupInfo3, groupID);
            this.b(groupID);
            if (Objects.equals(userGroupInfo3.getParentID(), parentID)) {
                return;
            }
            this.a(userGroupInfo3, parentID);
            if (parentID != null) {
                this.b(parentID);
            }
            this.k.entrySet().stream().map(Map.Entry::getValue).filter(userGroupInfo -> !userGroupInfo.isActive() && groupID.equals(userGroupInfo.getParentID()) && !groupID.equals(userGroupInfo.getID())).forEach(userGroupInfo -> {
                UserGroupInfo userGroupInfo2 = this.d.setParentGroup(userGroupInfo.getID(), null, System.currentTimeMillis());
                this.k.put(userGroupInfo.getID(), userGroupInfo2);
            });
            userGroupInfo2 = this.d.setParentGroup(groupID, parentID, System.currentTimeMillis());
            this.k.put(groupID, userGroupInfo2);
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                userGroupEventListener.groupParentChanged(userGroupInfo2);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        this.m.log(UsersAndGroupsEventLog.GroupDataChanged, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo3), "parentGroup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(GUID groupID) {
        Object object;
        UserGroupInfo userGroupInfo2;
        ArrayList arrayList;
        block8: {
            this.a(groupID, "groupID");
            arrayList = new ArrayList();
            this.e();
            this.c.lock();
            userGroupInfo2 = (UserGroupInfo)this.k.get(groupID);
            if (userGroupInfo2 != null) break block8;
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeleted((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
            for (UserGroupInfo userGroupInfo3 : arrayList) {
                String string = this.h.get(userGroupInfo3.getType().getName()).getDisplayName();
                this.m.log(UsersAndGroupsEventLog.GroupDeleted, userGroupInfo3.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo3), userGroupInfo3.getName(), string);
            }
            return;
        }
        try {
            Object object2 = this.a(userGroupInfo2.getType());
            if (((GroupTypeDef)object2).isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventRemoval)) {
                throw new IllegalArgumentException(String.format("group with ID \"%s\" can not be deleted due to definition of its type", groupID));
            }
            object = new ArrayList<UserGroupInfo>();
            if (((GroupTypeDef)object2).getMaxTreeLevel() > 1) {
                Set<UserGroupInfo> set = this.k.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
                object = UserGroupTreeUtils.findDescendantGroups(userGroupInfo2, set).getDescendantGroups();
            }
            object.add(userGroupInfo2);
            object.forEach(userGroupInfo -> {
                this.d.delete(userGroupInfo.getID());
                this.k.remove(userGroupInfo.getID());
                this.g.groupDeleted((UserGroupInfo)userGroupInfo);
                arrayList.add(userGroupInfo);
            });
            this.l = null;
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeleted((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
        }
        catch (Throwable throwable) {
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeleted((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
            for (UserGroupInfo userGroupInfo4 : arrayList) {
                String string = this.h.get(userGroupInfo4.getType().getName()).getDisplayName();
                this.m.log(UsersAndGroupsEventLog.GroupDeleted, userGroupInfo4.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo4), userGroupInfo4.getName(), string);
            }
            throw throwable;
        }
        for (Object object2 : arrayList) {
            object = this.h.get(((UserGroupInfo)object2).getType().getName()).getDisplayName();
            this.m.log(UsersAndGroupsEventLog.GroupDeleted, ((UserGroupInfo)object2).getID(), UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)object2), ((UserGroupInfo)object2).getName(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateGroup(GUID groupID, boolean removeMembershipData) {
        Object object;
        Object object22;
        UserGroupInfo userGroupInfo2;
        ArrayList arrayList;
        block8: {
            this.a(groupID, "groupID");
            arrayList = new ArrayList();
            this.e();
            this.c.lock();
            userGroupInfo2 = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b(userGroupInfo2, groupID);
            object22 = this.a(userGroupInfo2.getType());
            if (((GroupTypeDef)object22).isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventDeactivation)) {
                throw new IllegalArgumentException(String.format("group with ID \"%s\" can not be deactivated due to definition of its type", groupID));
            }
            if (userGroupInfo2.isActive()) break block8;
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeactivated((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
            for (UserGroupInfo userGroupInfo3 : arrayList) {
                String string = this.h.get(userGroupInfo3.getType().getName()).getDisplayName();
                this.m.log(UsersAndGroupsEventLog.GroupDeactivated, userGroupInfo3.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo3), userGroupInfo3.getName(), string);
            }
            return;
        }
        try {
            object = new ArrayList<UserGroupInfo>();
            if (((GroupTypeDef)object22).getMaxTreeLevel() > 1) {
                Set<UserGroupInfo> set = this.k.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
                object = UserGroupTreeUtils.findDescendantGroups(userGroupInfo2, set).getDescendantGroups();
            }
            object.add(userGroupInfo2);
            object.forEach(userGroupInfo -> {
                UserGroupInfo userGroupInfo2 = this.d.deactivate(userGroupInfo.getID(), removeMembershipData, System.currentTimeMillis());
                this.k.put(userGroupInfo.getID(), userGroupInfo2);
                this.g.groupDeleted((UserGroupInfo)userGroupInfo);
                arrayList.add(userGroupInfo2);
            });
            this.l = null;
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeactivated((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
        }
        catch (Throwable throwable) {
            this.c.unlock();
            this.j.dispatchEvent(userGroupEventListener -> arrayList.forEach(userGroupInfo -> {
                try {
                    userGroupEventListener.groupDeactivated((UserGroupInfo)userGroupInfo);
                }
                catch (Exception exception) {
                    UsersAndGroups.LOGGER.error(exception);
                }
            }));
            for (UserGroupInfo userGroupInfo4 : arrayList) {
                String string = this.h.get(userGroupInfo4.getType().getName()).getDisplayName();
                this.m.log(UsersAndGroupsEventLog.GroupDeactivated, userGroupInfo4.getID(), UsersAndGroups.getFullGroupDisplayName(userGroupInfo4), userGroupInfo4.getName(), string);
            }
            throw throwable;
        }
        for (Object object22 : arrayList) {
            object = this.h.get(((UserGroupInfo)object22).getType().getName()).getDisplayName();
            this.m.log(UsersAndGroupsEventLog.GroupDeactivated, ((UserGroupInfo)object22).getID(), UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)object22), ((UserGroupInfo)object22).getName(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameGroup(GUID groupID, String newGroupName) {
        UserGroupInfo userGroupInfo;
        UserGroupInfo userGroupInfo2;
        this.a(groupID, "groupID");
        this.e();
        try {
            UserGroupKey userGroupKey;
            this.c.lock();
            userGroupInfo2 = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b(userGroupInfo2, groupID);
            this.b(groupID);
            GroupTypeDef groupTypeDef = this.a(userGroupInfo2.getType());
            if (groupTypeDef.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventRenaming)) {
                throw new IllegalArgumentException(String.format("group with ID \"%s\" can not be renamed due to definition of its type", groupID));
            }
            if (userGroupInfo2.getName().equals(newGroupName)) {
                return;
            }
            UserGroupKey userGroupKey2 = userGroupInfo2.getGroupKey();
            if (!userGroupKey2.equals(userGroupKey = UserGroupKey.of(newGroupName, userGroupInfo2.getType()))) {
                this.a(userGroupKey.getName(), groupTypeDef);
            }
            userGroupInfo = this.d.setGroupName(groupID, newGroupName, System.currentTimeMillis());
            this.k.put(groupID, userGroupInfo);
            this.g.groupUpdated(userGroupInfo2, userGroupInfo);
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                userGroupEventListener.groupRenamed(userGroupInfo2.getName(), userGroupInfo);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        this.m.log(UsersAndGroupsEventLog.GroupDataChanged, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo2), "groupName");
    }

    @Override
    public void addUserToGroup(GUID userAccountID, GUID groupID, MembershipType ... membershipTypes) {
        if (membershipTypes == null) {
            throw new IllegalArgumentException("membership types must not be null");
        }
        HashMap<GUID, Set<MembershipType>> hashMap = new HashMap<GUID, Set<MembershipType>>();
        hashMap.put(userAccountID, new HashSet<MembershipType>(Arrays.asList(membershipTypes)));
        this.updateGroupMembers(groupID, hashMap, Collections.emptyMap());
    }

    @Override
    public void removeUserFromGroup(GUID userAccountID, GUID groupID, MembershipType ... membershipTypes) {
        if (membershipTypes == null) {
            throw new IllegalArgumentException("membership types must not be null");
        }
        HashMap<GUID, Set<MembershipType>> hashMap = new HashMap<GUID, Set<MembershipType>>();
        hashMap.put(userAccountID, new HashSet<MembershipType>(Arrays.asList(membershipTypes)));
        this.updateGroupMembers(groupID, Collections.emptyMap(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroupData(GUID groupID, MutableUserGroupData groupData) {
        UserGroupInfo userGroupInfo;
        UserGroupInfo userGroupInfo2;
        this.a(groupID, "groupID");
        this.a(groupData, "groupData");
        this.e();
        try {
            this.c.lock();
            userGroupInfo2 = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b(userGroupInfo2, groupID);
            this.b(groupID);
            GroupTypeDef groupTypeDef = this.a(userGroupInfo2.getType());
            if (groupTypeDef.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventDataEditing)) {
                throw new IllegalArgumentException(String.format("data of group with ID \"%s\" can not be edited due to definition of its type", groupID));
            }
            if (groupData.isEmpty()) {
                return;
            }
            groupData = groupData.copyWithSpecifiedFieldsOnly(FieldAndGroupTypeAssociationMap.getFieldsFor(userGroupInfo2.getType()), false);
            userGroupInfo = this.d.updateGroupData(groupID, System.currentTimeMillis(), groupData);
            this.k.put(groupID, userGroupInfo);
            this.g.groupUpdated(userGroupInfo2, userGroupInfo);
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                userGroupEventListener.groupDataUpdated(userGroupInfo);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        for (UserGroupField userGroupField : this.i) {
            if (!groupData.containsField(userGroupField)) continue;
            Object VALUE = userGroupInfo2.getValue(userGroupField);
            Object VALUE2 = groupData.get(userGroupField);
            if (!userGroupField.isValueChangeLoggable() || Objects.equals(VALUE, VALUE2)) continue;
            this.m.log(UsersAndGroupsEventLog.GroupDataChanged, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo2), userGroupField.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroupMembers(GUID groupID, Map<GUID, Set<MembershipType>> membersToAdd, Map<GUID, Set<MembershipType>> membersToRemove) {
        UserGroupInfo userGroupInfo;
        this.a(groupID, "groupID");
        this.e();
        try {
            this.c.lock();
            Iterator<GUID> iterator = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b((UserGroupInfo)((Object)iterator), groupID);
            GroupTypeDef object = this.a(((UserGroupInfo)((Object)iterator)).getType());
            if (object.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing)) {
                throw new IllegalArgumentException(String.format("membership data of group with ID \"%s\" can not be edited due to definition of its type", groupID));
            }
            Set<MembershipType> set = object.getMembershipTypes();
            this.a(membersToAdd, "map \"membersToAdd\"", set);
            this.a(membersToRemove, "map \"membersToRemove\"", set);
            if (!membersToAdd.isEmpty()) {
                this.b(groupID);
            }
            userGroupInfo = this.d.updateMembers(groupID, System.currentTimeMillis(), membersToAdd, membersToRemove);
            this.k.put(groupID, userGroupInfo);
            if (((UserGroupInfo)((Object)iterator)).isActive()) {
                this.g.groupUpdated((UserGroupInfo)((Object)iterator), userGroupInfo);
            }
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                Map<GUID, Set<MembershipType>> map3 = Collections.unmodifiableMap(membersToAdd.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableSet((Set)entry.getValue()))));
                Map<GUID, Set<MembershipType>> map4 = Collections.unmodifiableMap(membersToRemove.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableSet((Set)entry.getValue()))));
                userGroupEventListener.groupMembersUpdated(userGroupInfo, map3, map4);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        for (GUID gUID : membersToAdd.keySet()) {
            if (membersToRemove.containsKey(gUID)) continue;
            this.m.log(UsersAndGroupsEventLog.GroupMemberAdded, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo), gUID.toString());
        }
        for (GUID gUID : membersToRemove.keySet()) {
            if (membersToAdd.containsKey(gUID)) continue;
            this.m.log(UsersAndGroupsEventLog.GroupMemberRemoved, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo), gUID.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserGroupMembership(GUID userAccountID, Map<GUID, Set<MembershipType>> groupsToAddUserTo, Map<GUID, Set<MembershipType>> groupsToRemoveUserFrom) {
        this.a(userAccountID, "userAccountID");
        this.a(groupsToAddUserTo, "map \"groupsToAddUserTo\"", null);
        this.a(groupsToRemoveUserFrom, "map \"groupsToRemoveUserFrom\"", null);
        this.e();
        try {
            this.c.lock();
            for (GUID object2 : groupsToAddUserTo.keySet()) {
                this.b(object2);
            }
            HashSet<GUID> hashSet = new HashSet<GUID>(groupsToAddUserTo.keySet());
            hashSet.addAll(groupsToRemoveUserFrom.keySet());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                GUID gUID = (GUID)iterator.next();
                Set<MembershipType> set = groupsToAddUserTo.get(gUID);
                HashMap<GUID, Set<MembershipType>> hashMap = new HashMap<GUID, Set<MembershipType>>();
                if (set != null) {
                    hashMap.put(userAccountID, set);
                }
                Set<MembershipType> set2 = groupsToRemoveUserFrom.get(gUID);
                HashMap<GUID, Set<MembershipType>> hashMap2 = new HashMap<GUID, Set<MembershipType>>();
                if (set2 != null) {
                    hashMap2.put(userAccountID, set2);
                }
                this.updateGroupMembers(gUID, hashMap, hashMap2);
            }
        }
        finally {
            this.c.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroupPermissions(GUID groupID, Set<Permission> permissionsToAdd, Set<Permission> permissionsToRemove) {
        UserGroupInfo userGroupInfo;
        this.a(groupID, "groupID");
        UsersAndGroups.throwIfNullOrContainsNull(permissionsToAdd, "set \"permissionsToAdd\"");
        UsersAndGroups.throwIfNullOrContainsNull(permissionsToRemove, "set \"permissionsToRemove\"");
        Predicate<Permission> predicate = permission -> {
            try {
                Permission.valueOf(permission.getKey());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        };
        permissionsToAdd = permissionsToAdd.stream().filter(predicate).collect(Collectors.toSet());
        this.e();
        try {
            this.c.lock();
            UserGroupInfo userGroupInfo2 = (UserGroupInfo)this.k.get(groupID);
            BaseUserGroupManager.b(userGroupInfo2, groupID);
            this.b(groupID);
            GroupTypeDef groupTypeDef = this.a(userGroupInfo2.getType());
            if (groupTypeDef.isRestrictedBy(GroupTypeDef.GroupTypeRestrictions.PreventPermissionEditing)) {
                throw new IllegalArgumentException(String.format("permissions of group with ID \"%s\" can not be edited due to definition of its type", groupID));
            }
            HashSet<Permission> hashSet = new HashSet<Permission>(userGroupInfo2.getPermissions());
            hashSet.addAll(permissionsToAdd);
            hashSet.removeAll(permissionsToRemove);
            if (hashSet.equals(userGroupInfo2.getPermissions())) {
                return;
            }
            Set<String> set = permissionsToAdd.stream().map(Permission::getKey).collect(Collectors.toSet());
            Set<String> set2 = permissionsToRemove.stream().map(Permission::getKey).collect(Collectors.toSet());
            userGroupInfo = this.d.updatePermissions(groupID, System.currentTimeMillis(), set, set2);
            this.k.put(groupID, userGroupInfo);
            this.g.groupUpdated(userGroupInfo2, userGroupInfo);
            this.l = null;
        }
        finally {
            this.c.unlock();
        }
        this.j.dispatchEvent(userGroupEventListener -> {
            try {
                userGroupEventListener.groupDataUpdated(userGroupInfo);
            }
            catch (Exception exception) {
                UsersAndGroups.LOGGER.error(exception);
            }
        });
        if (permissionsToAdd.size() > 0) {
            this.m.log(UsersAndGroupsEventLog.GroupPermissionsAdded, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo), permissionsToAdd);
        }
        if (permissionsToRemove.size() > 0) {
            this.m.log(UsersAndGroupsEventLog.GroupPermissionsRemoved, groupID, UsersAndGroups.getFullGroupDisplayName(userGroupInfo), permissionsToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserFromAllGroups(GUID userAccountID) {
        this.a(userAccountID, "userAccountID");
        this.e();
        try {
            this.c.lock();
            Set<GUID> set = this.a(userAccountID);
            for (GUID gUID : set) {
                this.removeUserFromGroup(userAccountID, gUID, new MembershipType[0]);
            }
        }
        finally {
            this.c.unlock();
        }
    }

    @Override
    @Nonnull
    public Map<String, String> getAllGroupDisplayNames() {
        try {
            this.b.lock();
            Map<String, String> map = DisplayableMapCache.getMap(() -> {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (UserGroupInfo userGroupInfo : this.k.values()) {
                    String string = UsersAndGroups.getFullGroupDisplayName(userGroupInfo);
                    hashMap.put(userGroupInfo.getKey(), string);
                }
                return hashMap;
            }, (Object)this, this.k.a());
            return map;
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public Set<UserGroupInfo> getAllGroups() {
        return this.a(false);
    }

    @Override
    public Set<UserGroupInfo> getAllGroupsIncludingDeactivated() {
        return this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<UserGroupInfo> a(boolean bl) {
        this.e();
        try {
            this.b.lock();
            HashSet<UserGroupInfo> hashSet = new HashSet<UserGroupInfo>();
            HashSet hashSet2 = new HashSet();
            this.a((UserGroupInfo userGroupInfo) -> {
                if (userGroupInfo.isActive() || bl) {
                    if (userGroupInfo.isAuthenticationGroup()) {
                        hashSet2.add(userGroupInfo);
                    } else {
                        hashSet.add((UserGroupInfo)userGroupInfo);
                    }
                }
            });
            hashSet.addAll(hashSet2.stream().map(userGroupInfo -> this.a((UserGroupInfo)userGroupInfo)).collect(Collectors.toSet()));
            HashSet<UserGroupInfo> hashSet3 = hashSet;
            return hashSet3;
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public Set<UserGroupInfo> getGroups(GroupType groupType) {
        return this.a(groupType, false);
    }

    @Override
    public Set<UserGroupInfo> getGroupsIncludingDeactivated(GroupType groupType) {
        return this.a(groupType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<UserGroupInfo> a(GroupType groupType, boolean bl) {
        this.a((Object)groupType, "groupType");
        this.e();
        try {
            this.b.lock();
            this.a(groupType);
            HashSet<UserGroupInfo> hashSet = new HashSet<UserGroupInfo>();
            this.a((UserGroupInfo userGroupInfo) -> {
                if (userGroupInfo.getType().equals(groupType) && (userGroupInfo.isActive() || bl)) {
                    hashSet.add((UserGroupInfo)userGroupInfo);
                }
            });
            if (UsersAndGroups.GROUPTYPE_AUTH.equals(groupType)) {
                Set<UserGroupInfo> set = hashSet.stream().map(userGroupInfo -> this.a((UserGroupInfo)userGroupInfo)).collect(Collectors.toSet());
                return set;
            }
            HashSet<UserGroupInfo> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.b.unlock();
        }
    }

    private UserGroupInfo a(UserGroupInfo userGroupInfo) {
        return userGroupInfo.copyWith(new UserGroupMembership(this.f.getAuthGroupMemberIDs(userGroupInfo.getName())));
    }

    @Nonnull
    private HashMap<GUID, Set<UserGroupInfo>> f() {
        HashMap<GUID, Set<UserGroupInfo>> hashMap = this.l;
        if (hashMap == null) {
            hashMap = new HashMap();
            for (UserGroupInfo object : this.k.values()) {
                GUID gUID = object.getParentID();
                if (gUID == null || object.hasMembers()) continue;
                Object object2 = hashMap.get(gUID);
                if (object2 == null) {
                    object2 = new HashSet();
                    hashMap.put(gUID, (Set<UserGroupInfo>)object2);
                }
                object2.add((UserGroupInfo)object);
            }
            for (Set set : hashMap.values()) {
                for (Object object2 : new HashSet(set)) {
                    Set<UserGroupInfo> set2 = hashMap.get(((UserGroupInfo)object2).getID());
                    if (set2 == null) continue;
                    set.addAll(set2);
                }
            }
            this.l = hashMap;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UserGroupInfo> getGroupsForUser(GUID userAccountID, boolean includeDeactivated, boolean includeInheritedMembership) {
        this.a(userAccountID, "userAccountID");
        this.e();
        try {
            UserGroupInfo userGroupInfo2;
            this.b.lock();
            Set<GUID> set = this.a(userAccountID);
            Set<String> set2 = this.f.getAuthGroupsForUser(userAccountID);
            Set<GUID> set3 = this.a(set2);
            set.addAll(set3);
            HashMap<GUID, Set<UserGroupInfo>> hashMap = this.f();
            HashSet<UserGroupInfo> hashSet = new HashSet<UserGroupInfo>();
            for (GUID object2 : set) {
                Set<UserGroupInfo> set4;
                UserGroupInfo userGroupInfo3 = (UserGroupInfo)this.k.get(object2);
                if (userGroupInfo3 == null || !userGroupInfo3.isActive() && !includeDeactivated) continue;
                if (userGroupInfo3.isAuthenticationGroup()) {
                    userGroupInfo3 = this.a(userGroupInfo3);
                }
                hashSet.add(userGroupInfo3);
                if (!includeInheritedMembership || (set4 = hashMap.get(object2)) == null) continue;
                hashSet.addAll(set4.stream().filter(userGroupInfo -> userGroupInfo.isActive() || includeDeactivated).collect(Collectors.toSet()));
            }
            UserAccount userAccount = UserManager.getInstance().getUserAccount(userAccountID);
            if (userAccount != null && !userAccount.getAccountType().equals((Object)UserAccountType.Temp) && (userGroupInfo2 = (UserGroupInfo)this.k.get(UsersAndGroups.GROUPID_ALLUSERS)) != null) {
                hashSet.add(userGroupInfo2);
            }
            HashSet<UserGroupInfo> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.b.unlock();
        }
    }

    private Set<GUID> a(GUID gUID) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        this.a((UserGroupInfo userGroupInfo) -> {
            if (userGroupInfo.hasMember(gUID)) {
                hashSet.add(userGroupInfo.getID());
            }
        });
        return hashSet;
    }

    private Set<GUID> a(Set<String> set) {
        Set set2 = set.stream().map(string -> UserGroupKey.of(string, UsersAndGroups.GROUPTYPE_AUTH)).collect(Collectors.toSet());
        HashSet<GUID> hashSet = new HashSet<GUID>();
        this.a((UserGroupInfo userGroupInfo) -> {
            if (set2.contains(userGroupInfo.getGroupKey())) {
                hashSet.add(userGroupInfo.getID());
            }
        });
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserGroupInfo getGroup(GUID groupID) {
        this.a(groupID, "groupID");
        this.e();
        try {
            this.b.lock();
            UserGroupInfo userGroupInfo = (UserGroupInfo)this.k.get(groupID);
            if (userGroupInfo != null && userGroupInfo.isAuthenticationGroup()) {
                UserGroupInfo userGroupInfo2 = this.a(userGroupInfo);
                return userGroupInfo2;
            }
            UserGroupInfo userGroupInfo3 = userGroupInfo;
            return userGroupInfo3;
        }
        finally {
            this.b.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserGroupInfo getGroup(String groupName, GroupType groupType) {
        this.a((Object)groupType, "groupType");
        GroupTypeDef groupTypeDef = this.a(groupType);
        if (groupTypeDef.allowsNonUniqueNames()) {
            throw new UnsupportedOperationException("this method does not work with groups of types that allow nonUnique names");
        }
        this.e();
        try {
            this.b.lock();
            UserGroupInfo userGroupInfo = this.b(groupName, groupType);
            return userGroupInfo;
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public void registerListener(UserGroupEventListener listener) {
        this.j.registerListener(listener);
    }

    @Override
    public void unregisterListener(UserGroupEventListener listener) {
        this.j.unregisterListener(listener);
    }

    @Override
    public List<UserGroupField<?>> getAllFields() {
        return this.i;
    }

    public UserGroupField<Object> getField(String fieldKey) {
        for (UserGroupField<Object> userGroupField : this.i) {
            if (!userGroupField.getKey().equalsIgnoreCase(fieldKey)) continue;
            return userGroupField;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        if (phrase == null) {
            throw new IllegalArgumentException("phrase must not be null");
        }
        if (additionalExpressions == null) {
            throw new IllegalArgumentException("list of additional expressions must not be null");
        }
        if (boostingExpressions == null) {
            throw new IllegalArgumentException("list of boosting expressions must not be null");
        }
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        this.e();
        try {
            this.b.lock();
            SearchResult<GUID> searchResult = this.d().search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
            return searchResult;
        }
        finally {
            this.b.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        if (phrase == null) {
            throw new IllegalArgumentException("phrase must not be null");
        }
        if (additionalExpressions == null) {
            throw new IllegalArgumentException("list of additional expressions must not be null");
        }
        if (boostingExpressions == null) {
            throw new IllegalArgumentException("list of boosting expressions must not be null");
        }
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        this.e();
        try {
            this.b.lock();
            SearchResult<GUID> searchResult = this.d().search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID, searchTags, tokenMatcher);
            return searchResult;
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.d().getSearchEngine();
    }

    private GroupTypeDef a(GroupType groupType) {
        GroupTypeDef groupTypeDef = this.h.get(groupType.getName());
        if (groupTypeDef == null) {
            throw new IllegalArgumentException("unsupported group type: " + groupType.getName());
        }
        return groupTypeDef;
    }

    private void a(Map<GUID, Set<MembershipType>> map, String string, @Nullable Set<MembershipType> set) {
        this.a(map, string);
        for (GUID gUID : map.keySet()) {
            Object object;
            if (gUID == null) {
                throw new IllegalArgumentException(String.format("%s must not contain null elements: key=\"%s\"", string, map.keySet()));
            }
            Set<MembershipType> set2 = map.get(gUID);
            if (set2 == null || set2.contains(null)) {
                object = String.format("%s must not contain null elements: key=\"%s\", value=\"%s\"", string, gUID, set2);
                throw new IllegalArgumentException((String)object);
            }
            if (set == null) continue;
            object = new HashSet<MembershipType>(set2);
            ((AbstractSet)object).removeAll(set);
            if (((HashSet)object).isEmpty()) continue;
            String string2 = String.format("%s must not contain elements with invalid membership types: key=\"%s\", value=\"%s\", invalid=\"%s\"", string, gUID, set2, object);
            throw new IllegalArgumentException(string2);
        }
    }

    private void a(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " must not be null");
        }
    }

    private static void b(@Nullable UserGroupInfo userGroupInfo, @Nonnull GUID gUID) {
        if (userGroupInfo == null) {
            throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.groupDoesNotExist", gUID));
        }
    }

    private void b(@Nonnull GUID gUID) {
        UserGroupInfo userGroupInfo = (UserGroupInfo)this.k.get(gUID);
        if (userGroupInfo != null && !userGroupInfo.isActive()) {
            throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.groupIsDeactivated", gUID));
        }
    }

    @Override
    public void hardReset() throws IOException {
        if (this.d instanceof FileSystemUserGroupPersistence) {
            FileSystemUserGroupPersistence fileSystemUserGroupPersistence = (FileSystemUserGroupPersistence)this.d;
            try {
                this.c.lock();
                this.k.clear();
                this.c();
                this.a();
                UserGroupManager.getRecoveryEnabledInstance().getSearchEngine().reIndexAsync();
            }
            finally {
                this.c.unlock();
            }
        }
    }

    private static /* synthetic */ void a(Map map, GroupTypeDef groupTypeDef) {
        map.put(groupTypeDef.getGroupType().getName(), groupTypeDef);
    }

    private static class a<K, V>
    extends ConcurrentHashMap<K, V> {
        private int a;

        private a() {
        }

        int a() {
            return this.a;
        }

        @Override
        public V put(K key, V value) {
            ++this.a;
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            ++this.a;
            return super.remove(key);
        }
    }
}

