/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.help;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class HelpPage
implements Serializable {
    @Nonnull
    private String key;
    private String url;
    private String title;
    @Nonnull
    private final List<HelpPage> childPages = new ArrayList<HelpPage>();
    private transient HelpPage parentPage;
    private List<String> alternativeKeys = new ArrayList<String>();
    private transient boolean isAlternative;
    private transient boolean showInToc = true;
    private transient boolean needShowInTocCheck = true;
    private transient List<String> tags = new ArrayList<String>();

    protected HelpPage(String key, String url, String title) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.key = key;
        this.url = url;
        this.title = title;
    }

    protected HelpPage() {
    }

    protected HelpPage(String key, String url) {
        this(key, url, null);
        this.showInToc = false;
    }

    protected HelpPage(@Nonnull String key, String url, String title, @Nonnull List<String> alternativeKeys, boolean showInToc, boolean isAlternative) {
        this(key, url, title);
        this.isAlternative = isAlternative;
        this.setAlternativeKeys(alternativeKeys);
        this.setShowInToc(showInToc);
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addPage(HelpPage page) {
        this.addPage(page, this.childPages.size());
    }

    public void addPage(HelpPage page, int index) {
        this.childPages.add(index, page);
        page.parentPage = this;
    }

    @Nonnull
    public <T extends HelpPage> List<T> getChildPages() {
        return this.childPages;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public HelpPage getParentPage() {
        return this.parentPage;
    }

    public String toString() {
        HelpPage helpPage = this.getParentPage();
        return "\"HelpPage\":{\"key\":\"" + this.getKey() + "\",\"title\":\"" + this.getTitle() + "\",\"childPageSize\":" + this.getChildPages().size() + ",\"url\":\"" + this.getUrl() + "\",\"parent\":" + (String)(helpPage == null ? "\"null\"" : "{" + String.valueOf(helpPage) + "}") + "}";
    }

    public List<String> getAlternativeKeys() {
        return this.alternativeKeys;
    }

    public void setAlternativeKeys(@Nonnull List<String> alternativeKeys) {
        this.alternativeKeys = new ArrayList<String>(new HashSet<String>(alternativeKeys));
    }

    public void setAlternative(boolean setPageAsAlternativePage) {
        this.isAlternative = setPageAsAlternativePage;
    }

    public boolean isAlternative() {
        return this.isAlternative;
    }

    public boolean showInToc() {
        return this.showInToc;
    }

    public void setShowInToc(boolean showInToc) {
        this.showInToc = showInToc;
    }

    public boolean isNeedShowInTocCheck() {
        return this.needShowInTocCheck;
    }

    public void setNeedShowInTocCheck(boolean needShowInTocCheck) {
        this.needShowInTocCheck = needShowInTocCheck;
    }

    public List<String> getTags() {
        return this.tags;
    }
}

