/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notification;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.notification.NotificationGenerator;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonData
@InternalApi
public abstract class PermissionNotificationGenerator
extends NotificationGenerator {
    private final Permission[] permissions;

    public PermissionNotificationGenerator() {
        this(Permission.CONFIGURATION);
    }

    public PermissionNotificationGenerator(Permission ... permissions) {
        this.permissions = permissions;
    }

    @Override
    public String getGroupingKey() {
        return "system";
    }

    @Override
    public boolean isForCurrentUser() {
        return SystemPermissionChecker.checkAccess(this.permissions);
    }

    @Override
    public Set<GUID> getTargetUserIds(Set<GUID> preFilteredUserIds) {
        Object object;
        boolean bl;
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        UserGroupInfo userGroupInfo = userGroupManager.getGroup(UsersAndGroups.GROUP_ALLUSERS);
        List<Permission> list = Arrays.asList(this.permissions);
        boolean bl2 = bl = SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get() == false || userGroupInfo.getPermissions().stream().anyMatch(grantedPermission -> list.contains(grantedPermission));
        if (bl) {
            return preFilteredUserIds;
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        Set<GUID> set = userGroupManager.getSearchEngine().simpleSearch(this.createSearchCommand(true));
        for (GUID object22 : set) {
            object = userGroupManager.getGroup(object22);
            if (object == null || !((UserGroupInfo)object).isActive()) continue;
            hashSet.addAll(((UserGroupInfo)object).getMemberIDs());
        }
        hashSet.retainAll(preFilteredUserIds);
        UserManager userManager = UserManager.getInstance();
        SearchCommand searchCommand = this.createSearchCommand(false);
        searchCommand.getSearchExpression().add(0, new PrefilteredSearchExpression(preFilteredUserIds));
        object = userManager.getSearchEngine().simpleSearch(searchCommand);
        hashSet.addAll((Collection<GUID>)object);
        return hashSet;
    }

    private SearchCommand createSearchCommand(boolean isGroup) {
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        if (isGroup) {
            for (Permission permission : this.permissions) {
                orSearchExpression.add(new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, permission.getKey()));
            }
            orSearchExpression.add(new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, UsersAndGroups.GROUPTYPE_ADMIN.getName()));
        } else {
            for (Permission permission : this.permissions) {
                orSearchExpression.add(new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, permission.getKey()));
            }
            orSearchExpression.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, UserAccountType.Administrator.name()));
        }
        return new SearchCommand(orSearchExpression);
    }
}

