/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.logging.LogLevel;
import com.inet.logging.LoggingAppender;
import com.inet.logging.LoggingEvent;
import com.inet.logging.StaticInit;
import com.inet.logging.TraceCounter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

class FormattedLogStream
extends StaticInit
implements LoggingAppender {
    private PrintStream a = System.out;
    private TraceCounter b = new TraceCounter();
    private static DateFormat c = new SimpleDateFormat("M/d H:mm:ss");

    FormattedLogStream() {
    }

    @Override
    public void append(@Nonnull LoggingEvent event) {
        PrintStream printStream = this.a;
        if (printStream != null) {
            String string = event.getPrefix();
            Object object = event.getMessage();
            if (object instanceof Throwable) {
                this.a(printStream, string, (Throwable)object, event);
            } else {
                FormattedLogStream.a(printStream, event.getModule(), event.getLevel(), string + String.valueOf(object), event.getLogID());
            }
        }
    }

    private void a(@Nonnull PrintStream printStream, @Nonnull String string, @Nonnull Throwable throwable, LoggingEvent loggingEvent) {
        if (!this.b.traceLimitExceeded(loggingEvent)) {
            int n2;
            Object object;
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            if (throwable instanceof SQLException) {
                object = (SQLException)throwable;
                while ((object = ((SQLException)object).getNextException()) != null) {
                    stringWriter.write("\n\t" + String.valueOf(object));
                }
            }
            if ((n2 = ((String)(object = stringWriter.toString())).indexOf("\n")) >= 0) {
                FormattedLogStream.a(printStream, loggingEvent.getModule(), loggingEvent.getLevel(), string + ((String)object).substring(0, n2), loggingEvent.getLogID());
                FormattedLogStream.a(printStream, loggingEvent.getModule(), LogLevel.TRACE, ((String)object).substring(n2), loggingEvent.getLogID());
                return;
            }
        }
        FormattedLogStream.a(printStream, loggingEvent.getModule(), loggingEvent.getLevel(), throwable.toString(), loggingEvent.getLogID());
    }

    @SuppressFBWarnings(value={"STCAL_STATIC_SIMPLE_DATE_FORMAT_INSTANCE"}, justification="Call from single thread")
    private static final void a(@Nonnull PrintStream printStream, String string, LogLevel logLevel, String string2, String string3) {
        String string4 = "[" + string + "," + String.valueOf((Object)logLevel) + "," + c.format(new Date()) + "," + string3 + "] ";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            printStream.println(string4 + stringTokenizer.nextToken());
        }
    }

    void a(PrintStream printStream) {
        this.a = printStream;
    }

    PrintStream a() {
        return this.a;
    }

    void b() {
        if (this.a != null) {
            if (this.a != System.out && this.a != System.err) {
                this.a.close();
            }
            this.a = null;
        }
    }

    void a(TraceCounter traceCounter) {
        this.b = traceCounter;
    }

    static {
        ForkJoinPool.commonPool().execute(() -> new ConfigValue<DateFormat>(ConfigKey.LOG_DATEFORMAT){

            @Override
            protected DateFormat convert(@Nonnull String strValue) throws IllegalArgumentException {
                if (strValue.trim().isEmpty()) {
                    strValue = ConfigKey.LOG_DATEFORMAT.getDefault();
                }
                c = new SimpleDateFormat(strValue);
                return c;
            }
        });
    }
}

