/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.model;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigProperty;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class TableConfigProperty
extends ConfigProperty {
    private ConfigProperty[] columns;
    private int[] columnSizes;
    private ConfigAction[] actions;
    private String configActionsLabel;
    private boolean sortable = false;
    private String emptyLabel;

    public TableConfigProperty(int sortid, @Nonnull String key, @Nonnull String type, String label, String tooltip, List<String[]> table, ConfigProperty[] columns, ConfigAction[] actions, String configActionsLabel) {
        this(sortid, key, type, label, tooltip, table, columns, null, actions, configActionsLabel);
    }

    public TableConfigProperty(int sortid, @Nonnull String key, @Nonnull String type, String label, String tooltip, List<String[]> table, ConfigProperty[] columns, int[] columnSizes, ConfigAction[] actions, String configActionsLabel) {
        super(sortid, key, "Table" + type, label, table, tooltip, null);
        this.columnSizes = columnSizes;
        this.columns = columns;
        this.actions = actions;
        this.configActionsLabel = configActionsLabel;
    }

    public ConfigProperty[] getColumns() {
        return this.columns;
    }

    public ConfigAction[] getActions() {
        return this.actions;
    }

    public String getActionsLabel() {
        return this.configActionsLabel;
    }

    public int[] getColumnSizes() {
        return this.columnSizes;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setEmptyLabel(String emptyLabel) {
        this.emptyLabel = emptyLabel;
    }
}

