/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationManagerImplBase;
import com.inet.config.ConfigurationModificationEvent;
import com.inet.lib.json.Json;
import com.inet.logging.LogLevelsDefaults;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ConfigKey
implements Serializable {
    @Nonnull
    private static final HashMap<String, ConfigKey> a = new HashMap();
    public static final int MAX_KEY_LENGTH = 80;
    @Nonnull
    public static final ConfigKey SETUP_PROXY_METADATA = new ConfigKey("setupProxyMetaData", null, String.class);
    @Nonnull
    public static final ConfigKey SETUP_LAST_MIGRATED_PLUGIN_VERSIONS = new ConfigKey("lastMigratedPluginVersion", "{}", Map.class);
    @Nonnull
    public static final ConfigKey LICENSEKEY = new ConfigKey("licensekey", "", String.class);
    @Nonnull
    public static final ConfigKey APPLICATION = new ConfigKey("application", "", String.class);
    @Nonnull
    public static final ConfigKey LICENSETOKEN = new ConfigKey("licensetoken", "{}", Map.class);
    @Deprecated
    public static final ConfigKey REMOTEINTERFACE_ENABLED = new ConfigKey("remoteInterface.enabled", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey STARTPAGE_LOCATION = new ConfigKey("startpage.location", "", String.class);
    @Nonnull
    public static final ConfigKey IMPRINT_LOGO_URL = new ConfigKey("imprint.logo.url", "", String.class);
    @Nonnull
    public static final ConfigKey IMPRINT_LOGO_WITH_TEXT = new ConfigKey("imprint.logo.withtext", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey IMPRINT_CONTENT_URL = new ConfigKey("imprint.content.url", "", String.class);
    @Nonnull
    public static final ConfigKey IMPRINT_CONTENT_LINKTEXT = new ConfigKey("imprint.content.linktext", "", String.class);
    @Nonnull
    public static final ConfigKey PWA_PROMPT_FILTER = new ConfigKey("pwa.prompt.filter", "", String.class);
    @Nonnull
    public static final ConfigKey COOKIEBANNER_ACTIVE = new ConfigKey("cookiebanner.active", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey COOKIEBANNER_MESSAGE = new ConfigKey("cookiebanner.message", "", String.class);
    @Nonnull
    public static final ConfigKey COOKIEBANNER_LINK = new ConfigKey("cookiebanner.link", "", String.class);
    @Nonnull
    public static final ConfigKey LISTENER_CONNECTION_TYPE = new ConfigKey("listener.connectiontype", "plain", String.class);
    @Nonnull
    public static final ConfigKey LISTENER_PORT = new ConfigKey("listener.port", "", Integer.class);
    @Nonnull
    public static final ConfigKey LISTENER_BIND_ADDRESS = new ConfigKey("listener.bindaddress", "", String.class);
    @Nonnull
    public static final ConfigKey LISTENER_SSL_PORT = new ConfigKey("listener.ssl.port", "", Integer.class);
    @Nonnull
    public static final ConfigKey LISTENER_SSL_REDIRECT = new ConfigKey("listener.ssl.redirect", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey LISTENER_SSL_CERTIFICATE = new ConfigKey("listener.ssl.certificate", "", String.class);
    @Nonnull
    public static final ConfigKey LISTENER_SSL_PRIVATEKEY = new ConfigKey("listener.ssl.privatekey", "", String.class);
    @Nonnull
    public static final ConfigKey SERVER_URL = new ConfigKey("serverURL", "", String.class);
    @Nonnull
    public static final ConfigKey COOKIE_SAME_SITE = new ConfigKey("cookie.sameSite", "Lax", String.class);
    @Nonnull
    public static final ConfigKey ALLOW_FRAME_EMBEDDING = new ConfigKey("listener.frameembedding", "None", String.class);
    @Nonnull
    public static final ConfigKey CROSSDOMAIN_XML = new ConfigKey("crossdomain.xml", "", String.class);
    @Nonnull
    public static final ConfigKey ROBOTS_TXT = new ConfigKey("robots.txt", "", String.class);
    @Nonnull
    public static final ConfigKey SECURITY_TXT = new ConfigKey("security.txt", "", String.class);
    @Nonnull
    public static final ConfigKey MAX_CONCURRENT_REQUESTS = new ConfigKey("MaxConcurrentRequests", "500", Integer.class);
    @Nonnull
    public static final ConfigKey MAX_HTTP_REQUESTS = new ConfigKey("MaxHttpRequests", "250", Integer.class);
    @Nonnull
    public static final ConfigKey MAX_CONNECTIONS = new ConfigKey("MaxConnections", "5", Integer.class);
    @Nonnull
    public static final ConfigKey CONNECTION_POOL_TIMEOUT = new ConfigKey("ConnectionPoolTimeout", "10", Double.class);
    @Nonnull
    public static final ConfigKey LOGIN_TIMEOUT = new ConfigKey("LoginTimeout", "30", Integer.class);
    @Nonnull
    public static final ConfigKey QUERY_TIMEOUT = new ConfigKey("QueryTimeout", "300", Integer.class);
    @Nonnull
    public static final ConfigKey METADATACACHE_ENABLED = new ConfigKey("metaDataCache.enabled", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey METADATACACHE_TIMEOUT = new ConfigKey("metaDataCache.timeout", "10", Double.class);
    @Nonnull
    public static final ConfigKey STOP_AFTER_PAGE = new ConfigKey("stopAfterPage", "100000", Integer.class);
    @Nonnull
    public static final ConfigKey ROW_LIMIT = new ConfigKey("rowLimit", "100000", Integer.class);
    @Nonnull
    public static final ConfigKey CROSSTAB_CELL_LIMIT = new ConfigKey("crosstabCellLimit", "10000", Integer.class);
    @Nonnull
    public static final ConfigKey JOB_CONCURRENT_TASKS = new ConfigKey("MaxActiveRequests", "0", Integer.class);
    @Nonnull
    public static final ConfigKey JOB_TIME_UNTIL_NEXT_JOB_PAUSED = new ConfigKey("job_time_until_next_paused", "30000", Integer.class);
    @Nonnull
    public static final ConfigKey JOB_TIMEOUT = new ConfigKey("job_timeout", "3600", Integer.class);
    @Nonnull
    public static final ConfigKey JOB_TIMEOUT_HARDKILL = new ConfigKey("job_timeout_hard", "300", Integer.class);
    @Nonnull
    public static final ConfigKey LIB_DIRECTORY = new ConfigKey("libDirectory", "", String.class);
    @Nonnull
    public static final ConfigKey FORMULA_EXPANDER_CLASS = new ConfigKey("formulaExpanderClass", "", String.class);
    @Nonnull
    public static final ConfigKey PROPERTY_CHECKER = new ConfigKey("PropertyChecker", "", String.class);
    @Deprecated
    public static final ConfigKey REQUEST_HANDLER = new ConfigKey("requesthandler", "", String.class);
    @Nonnull
    public static final ConfigKey SERVLET_FILTER = new ConfigKey("servlet.filter", "", String.class);
    @Nonnull
    public static final ConfigKey LANGUAGE_RESOURCE = new ConfigKey("LanguageResource", "", String.class);
    @Nonnull
    public static final ConfigKey COLLATION_DEFAULTCOLLATION = new ConfigKey("collation.defaultCollation", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey COLLATION_LOCALE = new ConfigKey("collation.locale", "en_US", String.class);
    @Nonnull
    public static final ConfigKey COLLATION_STRENGTH = new ConfigKey("collation.strength", "PRIMARY", String.class);
    @Nonnull
    public static final ConfigKey LOG_DRIVER = new ConfigKey("log.driver", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey LOG_ENGINE = new ConfigKey("log.engine", "true", Boolean.class);
    @Deprecated
    public static final ConfigKey LOG_SERVER = new ConfigKey("log.server", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey LOG_LEVEL = new ConfigKey("log.level", "1", Integer.class);
    @Nonnull
    public static final ConfigKey LOG_LEVELS = new ConfigKey("log.levels", "{\"Reporting\":1}", LogLevelsDefaults.class);
    @Nonnull
    public static final ConfigKey LOG_FILE = new ConfigKey("log.file", "", (Class)String.class){

        @Override
        public <T> T convert(@Nonnull String strValue) throws IllegalArgumentException {
            if (strValue != null && strValue.isEmpty()) {
                return (T)"";
            }
            return super.convert(strValue);
        }
    };
    @Nonnull
    public static final ConfigKey LOG_DATEFORMAT = new ConfigKey("log.dateformat", "M/d H:mm:ss", String.class);
    @Nonnull
    public static final ConfigKey LOG_MAXSIZE = new ConfigKey("log.maxsize", "100", Integer.class);
    @Nonnull
    public static final ConfigKey LOG_MAXNUMBER = new ConfigKey("log.maxnumber", "10", Integer.class);
    @Nonnull
    public static final ConfigKey LOG_DATA = new ConfigKey("logData", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey CORE_FILE = new ConfigKey("coreFile", "", String.class);
    @Nonnull
    public static final ConfigKey CACHE_TYPE = new ConfigKey("cache.type", "2", Integer.class);
    @Nonnull
    public static final ConfigKey ENGINE_CACHE_TIMEOUT = new ConfigKey("EngineCacheTimeout", "15", Double.class);
    @Nonnull
    public static final ConfigKey RELOAD_ON_NEW_REQUEST = new ConfigKey("ReloadOnNewRequest", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey CACHE_CLEAR_ON_REQUEST = new ConfigKey("cache.clearOnRequest", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey CACHE_DB_URL = new ConfigKey("cache.db.url", "", String.class);
    @Nonnull
    public static final ConfigKey CACHE_DB_USERNAME = new ConfigKey("cache.db.username", "", String.class);
    @Nonnull
    public static final ConfigKey CACHE_DB_PASSWORD = new ConfigKey("cache.db.password", "", String.class);
    @Nonnull
    public static final ConfigKey CACHE_DB_DRIVERCLASS = new ConfigKey("cache.db.driverclass", "", String.class);
    @Nonnull
    public static final ConfigKey CACHE_HD_ROOT_DIRECTORY = new ConfigKey("cache.hd.root_directory", "", String.class);
    @Deprecated
    public static final ConfigKey CACHE_HD_SUB_DIRECTORY = new ConfigKey("cache.hd.sub_directory", "0", Integer.class);
    @Nonnull
    public static final ConfigKey ROWSOURCE_CACHE_ENABLED = new ConfigKey("rowSourceCache.enabled", "true", Boolean.class);
    @Deprecated
    public static final ConfigKey ROWSOURCE_CACHE_HEAP_SIZE = new ConfigKey("rowSourceCache.heapsize", "20", Integer.class);
    @Deprecated
    public static final ConfigKey ROWSOURCE_CACHE_DISK_SIZE = new ConfigKey("rowSourceCache.disksize", "200", Integer.class);
    @Nonnull
    public static final ConfigKey ROWSOURCE_CACHE_TIME_TO_LIVE = new ConfigKey("rowSourceCache.timetolive", "1800", Integer.class);
    @Deprecated
    public static final ConfigKey ROWSOURCE_CACHE_TIME_TO_IDLE = new ConfigKey("rowSourceCache.timetoidle", "600", Integer.class);
    @Nonnull
    public static final ConfigKey FONT_PATH = new ConfigKey("FontPath", "", String.class);
    @Nonnull
    public static final ConfigKey USE_NATIVE_FONTS = new ConfigKey("UseNativeFonts", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey FONT_AUTO_SCALING = new ConfigKey("FontAutoScaling", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey COMPRESS_FONT_VIEWER = new ConfigKey("compress.font.viewer", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey DEFAULT_ORIENTATION = new ConfigKey("default_Orientation", "1", Integer.class);
    @Nonnull
    public static final ConfigKey DEFAULT_PAPERSIZE = new ConfigKey("default_PaperSize", ConfigKey.a(), Integer.class);
    @Nonnull
    public static final ConfigKey ONERROR_EXECUTESQL_WITHOUTSF = new ConfigKey("OnError_ExecuteSQL_WithoutSF", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey USE_CLIENT_LOCALE = new ConfigKey("useClientLocale", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey USE_CLIENT_TIMEZONE = new ConfigKey("useClientTimezone", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey HAS_GROUP_TREE = new ConfigKey("hasGroupTree", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey PERMISSION_ALLOW_UNKNOWN_DATASOURCE = new ConfigKey("permission.allowunknowndatasource", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey PROMPT_BEHAVIOR = new ConfigKey("PromptBehavior", "VALUES_MUST_BE_EXPLICITLY_SET", String.class);
    @Nonnull
    public static final ConfigKey COMPATIBILITY_LEVEL = new ConfigKey("compatibilityLevel", "2147483647", Integer.class);
    @Nonnull
    public static final ConfigKey TOLERATE_ERRORS = new ConfigKey("TolerateErrors", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey MAXIMUM_ERRORS = new ConfigKey("MaximumErrors", "0", Integer.class);
    @Nonnull
    public static final ConfigKey DEFAULT_RENDERING_FORMAT = new ConfigKey("default.rendering.format", "html", String.class);
    @Nonnull
    public static final ConfigKey SUPPORT_EMAIL = new ConfigKey("support.email", "", String.class);
    @Nonnull
    public static final ConfigKey PDF_ASIAN_FONT_ENCODING = new ConfigKey("PdfAsianFontEncoding", "932", Integer.class);
    @Nonnull
    public static final ConfigKey MAP_TO_ADOBE_FONTS = new ConfigKey("mapToAdobeFonts", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey PDF_REPLACE_MISSING_CHAR = new ConfigKey("pdf.replacemissingchar", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey COMPRESSED_PDF = new ConfigKey("CompressedPDF", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey TAGGED_PDF = new ConfigKey("pdf.tagged", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey PDF_REPLACE_NOT_EMBEDDED_FONTS = new ConfigKey("fontmapping.pdf.replaceNotEmbeddedFonts", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey PDF_SANSSERIF_FONT_LIST = new ConfigKey("fontmapping.pdf.sansserifFontList", "[]", List.class);
    @Nonnull
    public static final ConfigKey PDF_SERIF_FONT_LIST = new ConfigKey("fontmapping.pdf.serifFontList", "[]", List.class);
    @Nonnull
    public static final ConfigKey PDF_MONOSPACED_FONT_LIST = new ConfigKey("fontmapping.pdf.monospacedFontList", "[]", List.class);
    @Nonnull
    public static final ConfigKey SIGN_PDF_ENABLED = new ConfigKey("sign.pdf.enabled", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey SIGN_KEYSTORE_TYPE = new ConfigKey("sign.keystore.type", "JKS", String.class);
    @Nonnull
    public static final ConfigKey SIGN_KEYSTORE_FILE = new ConfigKey("sign.keystore.file", "", String.class);
    @Nonnull
    public static final ConfigKey SIGN_KEYSTORE_PASSWORD = new ConfigKey("sign.keystore.password", "", String.class);
    @Nonnull
    public static final ConfigKey SIGN_KEY_NAME = new ConfigKey("sign.key.name", "", String.class);
    @Nonnull
    public static final ConfigKey SIGN_KEY_PASSWORD = new ConfigKey("sign.key.password", "", String.class);
    @Nonnull
    public static final ConfigKey USE_SET_PAGE_DEVICE = new ConfigKey("UseSetPageDevice", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey USE_IMAGE_COMPRESSION = new ConfigKey("UseImageCompression", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_PS_SERIF = new ConfigKey("fontmapping.ps.serif", "Times New Roman", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_PS_SANSSERIF = new ConfigKey("fontmapping.ps.sansserif", "Arial", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_PS_MONOSPACED = new ConfigKey("fontmapping.ps.monospaced", "Courier New", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_DOCUMENT_SERIF = new ConfigKey("fontmapping.rtf.serif", "Times New Roman", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_DOCUMENT_SANSSERIF = new ConfigKey("fontmapping.rtf.sansserif", "Arial", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_DOCUMENT_MONOSPACED = new ConfigKey("fontmapping.rtf.monospaced", "Courier New", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_XLS_SERIF = new ConfigKey("fontmapping.xls.serif", "Times New Roman", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_XLS_SANSSERIF = new ConfigKey("fontmapping.xls.sansserif", "Arial", String.class);
    @Nonnull
    public static final ConfigKey FONTMAPPING_XLS_MONOSPACED = new ConfigKey("fontmapping.xls.monospaced", "Courier New", String.class);
    @Nonnull
    public static final ConfigKey XLS_CELLDISTRIBUTION = new ConfigKey("xls.celldistribution", "staticlayout", String.class);
    @Nonnull
    public static final ConfigKey XLS_CELLTRUNCATE = new ConfigKey("xls.celltruncate", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey TXT_FONTNAME = new ConfigKey("txt.fontname", "Monospaced", String.class);
    @Nonnull
    public static final ConfigKey TXT_FONTSIZE = new ConfigKey("txt.fontsize", "13.33", Double.class);
    @Nonnull
    public static final ConfigKey AUTHENTICATION_SETTINGS = new ConfigKey("authentication.settings", "[{'provider':'system'},{'provider':'product','userCanRegister':'true'}]", HashMap[].class);
    @Nonnull
    public static final ConfigKey AUTHENTICATION_ALLOW_NEW_USER = new ConfigKey("authentication.allowNewUser", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey AUTHENTICATION_STAY_LOGGED_IN = new ConfigKey("authentication.stayLoggedIn", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey MASTER_PASSWORD = new ConfigKey("master.password", null, String.class);
    @Deprecated
    public static final ConfigKey PERMISSION_LOGINTYPE = new ConfigKey("permission.logintype", "automatic", String.class);
    @Deprecated
    public static final ConfigKey PERMISSION_LOGINURL = new ConfigKey("permission.loginurl", "", String.class);
    @Deprecated
    public static final ConfigKey PERMISSION_LOGINURL_TRUSTALL = new ConfigKey("permission.loginurl.trustall", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey PERMISSION_GUEST_ACTIVATED = new ConfigKey("permission.guest.activated", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey PERMISSION_GUEST_USERNAME = new ConfigKey("permission.guest.username", "guest", String.class);
    @Deprecated
    public static final ConfigKey REMOTE_INTERFACE_IPFILTER = new ConfigKey("remoteInterface.ipfilter", "", String.class);
    @Nonnull
    public static final ConfigKey SYSTEMPERMISSION_ENABLED = new ConfigKey("systempermission.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey GUEST_FULL_PERMISSIONS = new ConfigKey("guest.full.permissions", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey SYSTEMPERMISSIONS = new ConfigKey("systempermissions", "", String.class);
    @Deprecated
    public static final ConfigKey PERMISSION_ENABLED = new ConfigKey("permission.enabled", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey PERMISSION = new ConfigKey("permission", "", String.class);
    @Nonnull
    public static final ConfigKey REPOSITORY_ENABLED = new ConfigKey("repository.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey REPOSITORY = new ConfigKey("repository", "", String.class);
    @Nonnull
    public static final ConfigKey FILELOCATION_ENABLED = new ConfigKey("filelocation.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey JNDILOCATION_ENABLED = new ConfigKey("jndilocation.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey REPOLOCATION_ENABLED = new ConfigKey("repolocation.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey LOCALHOST_ENABLED = new ConfigKey("localhost.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_DATASOURCE = new ConfigKey("allow.param.datasource", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_PASSWORD = new ConfigKey("allow.param.password", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_PROMPT = new ConfigKey("allow.param.prompt", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_INIT = new ConfigKey("allow.param.init", "true", Boolean.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_SPROC = new ConfigKey("allow.param.sproc", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_SF = new ConfigKey("allow.param.sf", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_GF = new ConfigKey("allow.param.gf", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_QUERYFILE = new ConfigKey("allow.param.queryfile", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey ALLOW_PARAM_STOPAFTERPAGE = new ConfigKey("allow.param.stopAfterPage", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey PLUGINS_ACTIVATED = new ConfigKey("plugins.activated", "{}", Map.class);
    @Deprecated
    public static final ConfigKey ADHOC_ENABLED = new ConfigKey("adhoc.enabled", "true", Boolean.class);
    @Deprecated
    public static final ConfigKey ADHOC_DATALOCATION_TYPE = new ConfigKey("adhoc.dataLocation.type", "0", Integer.class);
    @Deprecated
    public static final ConfigKey ADHOC_DATALOCATION_DIRECTORY = new ConfigKey("adhoc.dataLocation.directory", "", String.class);
    @Deprecated
    public static final ConfigKey ADHOC_DATALOCATION_ROOT = new ConfigKey("adhoc.dataLocation.root", "adhoc_root", String.class);
    @Deprecated
    public static final ConfigKey ADHOC_SAVE_ENABLED = new ConfigKey("adhoc.save.enabled", "false", String.class);
    @Deprecated
    public static final ConfigKey ADHOC_SAVE_DIRECTORY = new ConfigKey("adhoc.save.directory", "", String.class);
    @Nonnull
    public static final ConfigKey ADHOC_UPLOAD_ENABLED = new ConfigKey("adhoc.upload.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey ADHOC_UPLOAD_SIZELIMIT = new ConfigKey("adhoc.upload.sizeLimit", "1024", Integer.class);
    @Deprecated
    public static final ConfigKey ADHOC_UPLOAD_COLUMNLIMIT = new ConfigKey("adhoc.upload.columnLimit", "100", Integer.class);
    @Deprecated
    public static final ConfigKey ADHOC_RENDERING_FORMAT = new ConfigKey("adhoc.rendering.format", "1", Integer.class);
    @Deprecated
    public static final ConfigKey ADHOC_DOWNLOAD_STATE_ENABLED = new ConfigKey("adhoc.download.state.enabled", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey ADHOC_DOWNLOAD_RPT_ENABLED = new ConfigKey("adhoc.download.rpt.enabled", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey CCREPOSITORY_PATHLIST = new ConfigKey("ccrepository.pathlist", "", String.class);
    @Nonnull
    public static final ConfigKey USERDIRECTORIES_ENABLED = new ConfigKey("userdirectories.enabled", "true", Boolean.class);
    @Nonnull
    public static final ConfigKey USERDIRECTORIES_GUEST_ACCOUNT_ENABLED = new ConfigKey("userdirectories.guestAccountEnabled", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey USERDIRECTORIES_PERMISSIONS = new ConfigKey("userdirectories.permissions", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><reportpermissions><reports pattern=\"*\"><entry type=\"user\" name=\"*\" permission=\"6\"/></reports></reportpermissions>", String.class);
    @Nonnull
    public static final ConfigKey APP_DATA_PATH = new ConfigKey("AppDataPath", "", String.class);
    @Nonnull
    public static final ConfigKey BACKUP_LOCATION = new ConfigKey("BackupLocation", "", String.class);
    @Nonnull
    public static final ConfigKey BACKUP_DEFINITIONS = new ConfigKey("BackupDefinitions", "", String.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_ENABLED_ACTIONS = new ConfigKey("scheduler_enabledActions", "", String.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_CUSTOM_ACTION_DEFINITIONS = new ConfigKey("scheduler_customactiondefinitions", "", String.class);
    public static final ConfigKey SCHEDULER_ACTIONS = new ConfigKey("scheduler_Actions", "", String.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_ACTIVATED = new ConfigKey("scheduler_activated", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_RUNTIME_OPTIONS = new ConfigKey("scheduler_runtimeOptions", "", String.class);
    @Nonnull
    public static final ConfigKey SCHEDULER_MAX_WORKER = new ConfigKey("scheduler.maxworker", "5", Integer.class);
    @Nonnull
    public static final ConfigKey SCHEDULER_PROPERTIES_CHECKER = new ConfigKey("scheduler.propertieschecker", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_SMTPHOST = new ConfigKey("mail.smtphost", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_SMTPPORT = new ConfigKey("mail.smtpport", "25", Integer.class);
    @Nonnull
    public static final ConfigKey MAIL_POP3HOST = new ConfigKey("mail.pop3host", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_POP3PORT = new ConfigKey("mail.pop3port", "110", Integer.class);
    @Nonnull
    public static final ConfigKey MAIL_USER = new ConfigKey("mail.user", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_PASSWORD = new ConfigKey("mail.password", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_SENDER = new ConfigKey("mail.sender", "", String.class);
    @Nonnull
    public static final ConfigKey MAIL_AUTHENTICATION = new ConfigKey("mail.authentication", "0", Integer.class);
    @Nonnull
    public static final ConfigKey MAIL_ENCRYPTION = new ConfigKey("mail.encryption", "NONE", String.class);
    @Nonnull
    public static final ConfigKey MAIL_PUBLIC_EHLO = new ConfigKey("mail.publicehlo", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_CACHEFILTER_ENABLED = new ConfigKey("scheduler_cachefilter.enabled", "false", Boolean.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_PASSWORD = new ConfigKey("scheduler_password", "", String.class);
    @Deprecated
    public static final ConfigKey CACHE_CLEARONREQUESTCOPY = new ConfigKey("cache.clearOnRequestCopy", "", String.class);
    @Deprecated
    public static final ConfigKey CLUSTER_ENABLED = new ConfigKey("cluster.enabled", "", String.class);
    @Deprecated
    public static final ConfigKey CLUSTER_PORT = new ConfigKey("cluster.port", "", String.class);
    @Deprecated
    public static final ConfigKey CLUSTER_LOAD_BALANCING_ENABLED = new ConfigKey("cluster.load_balancing_enabled", "", String.class);
    @Deprecated
    public static final ConfigKey CLUSTER_LOAD_REDUCTION = new ConfigKey("cluster.load_reduction", "", String.class);
    @Deprecated
    public static final ConfigKey CLUSTER_SHOWSTATISTIC = new ConfigKey("cluster.showStatistic", "", String.class);
    @Deprecated
    public static final ConfigKey IPADRESSES = new ConfigKey("ipadresses", "", String.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_CONFIG_ENABLED = new ConfigKey("scheduler_config.enabled", "", String.class);
    @Deprecated
    public static final ConfigKey SCHEDULER_CONFIG_ADDRESSFILTER = new ConfigKey("scheduler_config.addressfilter", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_HOST = new ConfigKey("allow.param.host", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_CATALOG = new ConfigKey("allow.param.catalog", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_URL = new ConfigKey("allow.param.url", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_DATABASE = new ConfigKey("allow.param.database", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_SCHEMA = new ConfigKey("allow.param.schema", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_USER = new ConfigKey("allow.param.user", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_DLL = new ConfigKey("allow.param.dll", "", String.class);
    @Deprecated
    public static final ConfigKey ALLOW_PARAM_SQL = new ConfigKey("allow.param.sql", "", String.class);
    @Nonnull
    public static final ConfigKey HTTP_HEADER_FIELDS = new ConfigKey("listener.header.http", "{}", Map.class);
    @Nonnull
    public static final ConfigKey HTTPS_HEADER_FIELDS = new ConfigKey("listener.header.https", "{}", Map.class);
    @Nonnull
    public static final ConfigKey PRODUCT_NAME = new ConfigKey("frameTitle", "", String.class);
    @Nonnull
    private transient Class<?> b;
    private String c;
    private String d;

    public ConfigKey(String key, String def, @Nonnull Class<?> type) {
        this.c = key;
        this.d = def;
        this.b = type;
        this.b();
    }

    public ConfigKey(String key) {
        this.c = key;
        this.d = "";
        this.b = String.class;
    }

    private static String a() {
        String string = Locale.getDefault().getCountry();
        if ("US".equals(string) || "CA".equals(string)) {
            return "1";
        }
        return "9";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        HashMap<String, ConfigKey> hashMap = a;
        synchronized (hashMap) {
            if (a.containsKey(this.c)) {
                throw new IllegalStateException("A property with the same key '" + this.c + "' already exists.");
            }
            a.put(this.c, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigKey valueOf(String key) {
        HashMap<String, ConfigKey> hashMap = a;
        synchronized (hashMap) {
            return a.get(key);
        }
    }

    @Nonnull
    public String getKey() {
        return this.c;
    }

    public String getDefault() {
        return this.d;
    }

    public void setDefault(String def) {
        if (Objects.equals(def, this.d)) {
            return;
        }
        this.d = def;
        ConfigurationManagerImplBase configurationManagerImplBase = (ConfigurationManagerImplBase)ConfigurationManager.getInstance();
        if (configurationManagerImplBase.currentConfig != null) {
            ConfigurationModificationEvent configurationModificationEvent = new ConfigurationModificationEvent(configurationManagerImplBase.currentConfig, true, Arrays.asList(this.c), 7);
            configurationManagerImplBase.a(configurationModificationEvent);
        }
    }

    @Nonnull
    public Class<?> getType() {
        return this.b;
    }

    public <T> T getCurrent() {
        String string = ConfigurationManager.getInstance().getCurrent().get(this.getKey(), this.getDefault());
        if (string == null) {
            return null;
        }
        return this.convert(string);
    }

    public <T> T convert(@Nonnull String strValue) throws IllegalArgumentException {
        Class<?> clazz = this.getType();
        try {
            if (clazz == String.class) {
                if (strValue.isEmpty()) {
                    return (T)this.getDefault();
                }
                return (T)strValue;
            }
            if (clazz == Integer.class && !strValue.isEmpty()) {
                try {
                    return (T)Integer.valueOf((int)Double.parseDouble(strValue));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Method method = clazz.getMethod("valueOf", String.class);
            try {
                return (T)method.invoke(null, strValue);
            }
            catch (Exception exception) {
                this.a(strValue);
                return (T)method.invoke(null, this.getDefault());
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                try {
                    return (T)constructor.newInstance(strValue);
                }
                catch (Exception exception3) {
                    this.a(strValue);
                    return (T)constructor.newInstance(this.getDefault());
                }
            }
            catch (Exception exception4) {
                Exception exception5 = exception4;
                try {
                    return (T)new Json().fromJson(strValue, clazz);
                }
                catch (Exception exception6) {
                    try {
                        this.a(strValue);
                        return (T)new Json().fromJson(this.getDefault(), clazz);
                    }
                    catch (Exception exception7) {
                        Exception exception8 = exception7;
                        if (this.getDefault() == null) {
                            return null;
                        }
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not supported class: " + String.valueOf(clazz) + "' for key '" + this.getKey() + "'");
                        illegalArgumentException.addSuppressed(exception2);
                        illegalArgumentException.addSuppressed(exception5);
                        illegalArgumentException.addSuppressed(exception8);
                        throw illegalArgumentException;
                    }
                }
            }
        }
    }

    private void a(@Nonnull String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Logger logger = LogManager.getConfigLogger();
        if (logger.isError()) {
            logger.error("Invalid value '" + string + "' for key '" + this.getKey() + "'. Fallback to default '" + this.getDefault() + "'.");
        }
    }
}

