/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.hdr;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class HDRHeader {
    private static final String KEY_FORMAT = "FORMAT=";
    private static final String KEY_PRIMARIES = "PRIMARIES=";
    private static final String KEY_EXPOSURE = "EXPOSURE=";
    private static final String KEY_GAMMA = "GAMMA=";
    private static final String KEY_SOFTWARE = "SOFTWARE=";
    private int width;
    private int height;
    private String software;

    HDRHeader() {
    }

    public static HDRHeader read(ImageInputStream imageInputStream) throws IOException {
        Object object;
        String string;
        HDRHeader hDRHeader = new HDRHeader();
        while (!(string = imageInputStream.readLine().trim()).isEmpty()) {
            if (string.startsWith("#?") || string.startsWith("#")) continue;
            if (string.startsWith(KEY_FORMAT)) {
                object = string.substring(KEY_FORMAT.length()).trim();
                if (((String)object).equals("32-bit_rle_rgbe")) continue;
                throw new IIOException("Unsupported format \"" + (String)object + "\"(expected \"32-bit_rle_rgbe\")");
            }
            if (string.startsWith(KEY_PRIMARIES) || string.startsWith(KEY_EXPOSURE) || string.startsWith(KEY_GAMMA) || !string.startsWith(KEY_SOFTWARE)) continue;
            hDRHeader.software = string.substring(KEY_SOFTWARE.length()).trim();
        }
        string = imageInputStream.readLine().trim();
        object = string.split("\\s");
        if (object[0].equals("-Y") && object[2].equals("+X")) {
            hDRHeader.height = Integer.parseInt((String)object[1]);
            hDRHeader.width = Integer.parseInt((String)object[3]);
            return hDRHeader;
        }
        throw new IIOException("Unsupported RGBE orientation (expected \"-Y ... +X ...\")");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getSoftware() {
        return this.software;
    }
}

