/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageOutputStream;

final class PSDHeader {
    static final int PSD_MAX_SIZE = 30000;
    static final int PSB_MAX_SIZE = 300000;
    final short channels;
    final int width;
    final int height;
    final short bits;
    final short mode;
    final boolean largeFormat;

    PSDHeader(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this((short)n, n2, n3, (short)n4, (short)n5, bl);
    }

    private PSDHeader(short s, int n, int n2, short s2, short s3, boolean bl) {
        if (s < 1 || s > 56) {
            throw new IllegalArgumentException(String.format("Unsupported number of channels for PSD: %d", s));
        }
        this.channels = s;
        this.width = n;
        this.height = n2;
        switch (s2) {
            case 1: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported bit depth for PSD: %d bits", s2));
            }
        }
        this.bits = s2;
        switch (s3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported color mode for PSD: %d", s3));
            }
        }
        this.mode = s3;
        this.largeFormat = bl;
        if (!this.hasValidDimensions()) {
            throw new IllegalArgumentException(String.format("Dimensions exceed maximum allowed for %s: %dx%d (max %dx%d)", bl ? "PSB" : "PSD", n, n2, this.getMaxSize(), this.getMaxSize()));
        }
    }

    static PSDHeader read(DataInput dataInput) throws IOException {
        boolean bl;
        int n = dataInput.readInt();
        if (n != 943870035) {
            throw new IIOException("Not a PSD document, expected signature \"8BPS\": \"" + PSDUtil.intToStr(n) + "\" (0x" + Integer.toHexString(n) + ")");
        }
        int n2 = dataInput.readUnsignedShort();
        switch (n2) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown PSD version, expected 1 or 2: 0x%08x", n2));
            }
        }
        byte[] byArray = new byte[6];
        dataInput.readFully(byArray);
        short s = dataInput.readShort();
        if (s < 1 || s > 56) {
            throw new IIOException(String.format("Unsupported number of channels for PSD: %d", s));
        }
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        short s2 = dataInput.readShort();
        switch (s2) {
            case 1: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported bit depth for PSD: %d bits", s2));
            }
        }
        short s3 = dataInput.readShort();
        switch (s3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported color mode for PSD: %d", s3));
            }
        }
        return new PSDHeader(s, n4, n3, s2, s3, bl);
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt(943870035);
        imageOutputStream.writeShort(this.largeFormat ? 2 : 1);
        imageOutputStream.write(new byte[6]);
        imageOutputStream.writeShort(this.channels);
        imageOutputStream.writeInt(this.height);
        imageOutputStream.writeInt(this.width);
        imageOutputStream.writeShort(this.bits);
        imageOutputStream.writeShort(this.mode);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[version: " + (this.largeFormat ? "2" : "1") + ", channels: " + this.channels + ", width: " + this.width + ", height: " + this.height + ", depth: " + this.bits + ", mode: " + this.mode + " (" + this.modeAsString() + ")]";
    }

    int getMaxSize() {
        return this.largeFormat ? 300000 : 30000;
    }

    boolean hasValidDimensions() {
        return this.width <= this.getMaxSize() && this.height <= this.getMaxSize();
    }

    private String modeAsString() {
        switch (this.mode) {
            case 0: {
                return "Monochrome";
            }
            case 1: {
                return "Grayscale";
            }
            case 2: {
                return "Indexed";
            }
            case 3: {
                return "RGB";
            }
            case 4: {
                return "CMYK";
            }
            case 7: {
                return "Multi channel";
            }
            case 8: {
                return "Duotone";
            }
            case 9: {
                return "Lab color";
            }
        }
        return "Unkown mode";
    }
}

