/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.xwd;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.xwd.XWDImageMetadata;
import com.twelvemonkeys.imageio.plugins.xwd.XWDX11Header;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

final class XWDImageReader
extends ImageReaderBase {
    static final byte[] BIT_REVERSE_TABLE = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};
    private XWDX11Header header;

    XWDImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new XWDImageMetadata(this.getRawImageType(n), this.header);
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.width;
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.height;
    }

    private void readHeader() throws IOException {
        this.assertInput();
        if (this.header == null) {
            this.header = XWDX11Header.read(this.imageInput);
        }
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        return Collections.singletonList(imageTypeSpecifier).iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        switch (this.header.visualClass) {
            case 0: 
            case 1: {
                return ImageTypeSpecifiers.createGrayscale((int)this.header.bitsPerPixel, (int)0, (boolean)false);
            }
            case 2: 
            case 3: {
                return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)this.header.colorMap);
            }
            case 4: 
            case 5: {
                int n2 = this.header.numComponents();
                return ImageTypeSpecifiers.createInterleaved((ColorSpace)ColorSpace.getInstance(1000), (int[])this.createBandArray(n2, this.header), (int)0, (n2 > 3 ? 1 : 0) != 0, (boolean)false);
            }
        }
        throw new IIOException(String.format("Unknown visual class: %d", this.header.visualClass));
    }

    private Raster createRowRaster(byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        switch (this.header.visualClass) {
            case 4: 
            case 5: {
                return Raster.createInterleavedRaster(dataBufferByte, this.header.width, 1, this.header.bytesPerLine, this.header.bitsPerPixel / 8, this.createBandArray(this.header.numComponents(), this.header), null);
            }
        }
        return Raster.createPackedRaster(dataBufferByte, this.header.width, 1, this.header.bitsPerPixel, null);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        BufferedImage bufferedImage = XWDImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.header.width, (int)this.header.height);
        WritableRaster writableRaster = bufferedImage.getRaster();
        XWDImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)this.header.numComponents(), (int)writableRaster.getNumBands());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        XWDImageReader.computeRegions((ImageReadParam)imageReadParam, (int)this.header.width, (int)this.header.height, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        byte[] byArray = new byte[this.header.bytesPerLine];
        Raster raster = this.createRowRaster(byArray).createChild(rectangle.x, 0, rectangle2.width, 1, 0, 0, null);
        boolean bl = this.header.bitsPerPixel < 8 && this.header.bitFillOrder == ByteOrder.LITTLE_ENDIAN;
        boolean bl2 = bufferedImage.getColorModel().hasAlpha();
        int n2 = imageReadParam == null ? 1 : imageReadParam.getSourceXSubsampling();
        int n3 = imageReadParam == null ? 1 : imageReadParam.getSourceYSubsampling();
        this.imageInput.seek(this.header.pixelOffset);
        this.processImageStarted(n);
        for (int i = 0; i < rectangle.y + rectangle.height; ++i) {
            int n4;
            if (i < rectangle.y || i % n3 != 0) {
                this.imageInput.skipBytes(byArray.length);
                continue;
            }
            this.imageInput.readFully(byArray);
            if (bl) {
                for (n4 = 0; n4 < byArray.length; ++n4) {
                    byArray[n4] = ~BIT_REVERSE_TABLE[byArray[n4] & 0xFF];
                }
            }
            if (bl2) {
                for (n4 = 0; n4 < byArray.length; n4 += raster.getNumBands()) {
                    byArray[n4] = ~byArray[n4];
                }
            }
            n4 = this.header.numComponents();
            IIOUtil.subsampleRow((byte[])byArray, (int)(rectangle.x * n4), (int)rectangle.width, (byte[])byArray, (int)(rectangle.x * n4), (int)n4, (int)this.header.bitsPerRGB, (int)n2);
            writableRaster.setDataElements(0, (i - rectangle.y) / n3, raster);
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(i - rectangle.y) * 100.0f / (float)rectangle.height);
        }
        this.processImageComplete();
        return bufferedImage;
    }

    private int bytePos(int n, int n2) {
        switch (n) {
            case 255: {
                return n2 - 1;
            }
            case 65280: {
                return n2 - 2;
            }
            case 0xFF0000: {
                return n2 - 3;
            }
            case -16777216: {
                return n2 - 4;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported bitmask: 0x%08x", n));
    }

    private int[] createBandArray(int n, XWDX11Header xWDX11Header) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.bytePos(xWDX11Header.masks[i], n);
        }
        return nArray;
    }

    protected void resetMembers() {
        this.header = null;
    }
}

