/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.xwd;

import com.twelvemonkeys.imageio.plugins.xwd.XWDProviderInfo;
import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class XWDX11Header {
    final int width;
    final int height;
    final ByteOrder byteOrder;
    final ByteOrder bitFillOrder;
    final int bitsPerPixel;
    final int bytesPerLine;
    final int visualClass;
    final int[] masks;
    final int bitsPerRGB;
    final IndexColorModel colorMap;
    final String windowName;
    final long pixelOffset;

    private XWDX11Header(int n, int n2, ByteOrder byteOrder, ByteOrder byteOrder2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, IndexColorModel indexColorModel, String string, long l) {
        this.width = n;
        this.height = n2;
        this.byteOrder = byteOrder;
        this.bitFillOrder = byteOrder2;
        this.bitsPerPixel = n3;
        this.bytesPerLine = n4;
        this.visualClass = n5;
        this.masks = new int[]{n6, n7, n8, ~(n6 | n7 | n8)};
        this.bitsPerRGB = n9;
        this.colorMap = indexColorModel;
        this.windowName = string;
        this.pixelOffset = l;
    }

    static boolean isX11(DataInput dataInput) throws IOException {
        return dataInput.readInt() >= 100 && dataInput.readInt() == 7;
    }

    static XWDX11Header read(ImageInputStream imageInputStream) throws IOException {
        String string;
        imageInputStream.mark();
        if (!XWDX11Header.isX11(imageInputStream)) {
            throw new IIOException("Not a valid X11 Window Dump");
        }
        imageInputStream.reset();
        long l = imageInputStream.getStreamPosition();
        int n = imageInputStream.readInt();
        imageInputStream.readInt();
        int n2 = imageInputStream.readInt();
        int n3 = imageInputStream.readInt();
        int n4 = imageInputStream.readInt();
        int n5 = imageInputStream.readInt();
        int n6 = imageInputStream.readInt();
        int n7 = imageInputStream.readInt();
        int n8 = imageInputStream.readInt();
        int n9 = imageInputStream.readInt();
        int n10 = imageInputStream.readInt();
        int n11 = imageInputStream.readInt();
        int n12 = imageInputStream.readInt();
        int n13 = imageInputStream.readInt();
        int n14 = imageInputStream.readInt();
        int n15 = imageInputStream.readInt();
        int n16 = imageInputStream.readInt();
        int n17 = imageInputStream.readInt();
        if (n11 == 24 && n17 == 24) {
            n17 = 8;
        }
        int n18 = imageInputStream.readInt();
        int n19 = imageInputStream.readInt();
        int n20 = imageInputStream.readInt();
        int n21 = imageInputStream.readInt();
        int n22 = imageInputStream.readInt();
        int n23 = imageInputStream.readInt();
        int n24 = imageInputStream.readInt();
        byte[] byArray = new byte[n - 100];
        imageInputStream.readFully(byArray);
        String string2 = string = byArray.length <= 1 ? null : new String(byArray, 0, byArray.length - 1, StandardCharsets.UTF_8);
        if (XWDProviderInfo.DEBUG) {
            System.out.println("format = " + n2);
            System.out.println("depth = " + n3);
            System.out.println("byteOrder = " + n7);
            System.out.println("unit = " + n8);
            System.out.println("bitOrder = " + n9);
            System.out.println("pad = " + n10);
            System.out.println("bitsPerPixel = " + n11);
            System.out.println("bytePerLine = " + n12);
            System.out.println("visualClass = " + n13);
            System.out.printf("redMask = 0x%08x%n", n14);
            System.out.printf("greenMask = 0x%08x%n", n15);
            System.out.printf("blueMask = 0x%08x%n", n16);
            System.out.println("bitsPerRGB = " + n17);
            System.out.println("numColors = " + n18);
            System.out.println("colorMapEntries = " + n19);
            System.out.println("windowName = " + string);
        }
        byte[] byArray2 = new byte[12 * n19];
        imageInputStream.readFully(byArray2);
        return new XWDX11Header(n4, n5, n7 == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, n9 == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, n11, n12, n13, n14, n15, n16, n17, XWDX11Header.createColorMap(n17, byArray2), string, l + (long)n + (long)byArray2.length);
    }

    private static IndexColorModel createColorMap(int n, byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        int n2 = byArray.length / 12;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (byArray[i * 12 + 4] & 0xFF) << 16 | (byArray[i * 12 + 6] & 0xFF) << 8 | byArray[i * 12 + 8] & 0xFF;
        }
        return new IndexColorModel(n, n2, nArray, 0, false, -1, 0);
    }

    int numComponents() {
        return this.bitsPerPixel / this.bitsPerRGB;
    }
}

