/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pntg;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.pntg.PNTGImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.pntg.PNTGMetadata;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PNTGImageReader
extends ImageReaderBase {
    private static final Set<ImageTypeSpecifier> IMAGE_TYPES = Collections.singleton(ImageTypeSpecifiers.createIndexed((int[])new int[]{-1, 0}, (boolean)false, (int)-1, (int)1, (int)0));

    PNTGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        return 576;
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        return 720;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkBounds(n);
        return IMAGE_TYPES.iterator();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = PNTGImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)n2, (int)n3);
        int[] nArray = imageReadParam != null ? imageReadParam.getDestinationBands() : null;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        PNTGImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        int n4 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n5 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        WritableRaster writableRaster = bufferedImage.getRaster().createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, nArray);
        Raster raster = Raster.createPackedRaster(0, n2, 1, 1, 1, null).createChild(rectangle.x, 0, rectangle2.width, 1, 0, 0, nArray);
        this.processImageStarted(n);
        this.readData(rectangle, rectangle2, n4, n5, writableRaster, raster);
        this.processImageComplete();
        return bufferedImage;
    }

    private void readData(Rectangle rectangle, Rectangle rectangle2, int n, int n2, WritableRaster writableRaster, Raster raster) throws IOException {
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        try (DataInputStream dataInputStream = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput), (Decoder)new PackBitsDecoder()));){
            int n3 = rectangle.y + rectangle.height;
            for (int i = 0; i < n3; ++i) {
                dataInputStream.readFully(byArray);
                if (i >= rectangle.y && i % n2 == 0) {
                    IIOUtil.subsampleRow((byte[])byArray, (int)rectangle.x, (int)rectangle.width, (byte[])byArray, (int)rectangle2.x, (int)1, (int)1, (int)n);
                    int n4 = (i - rectangle.y) / n2;
                    writableRaster.setDataElements(0, n4, raster);
                    this.processImageProgress((float)i / (float)n3);
                }
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        }
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new PNTGMetadata(this.getRawImageType(n));
    }

    private void readHeader() throws IOException {
        if (PNTGImageReaderSpi.isMacBinaryPNTG(this.imageInput)) {
            this.imageInput.seek(128L);
        } else {
            this.imageInput.seek(0L);
        }
        if (this.imageInput.skipBytes(512) != 512) {
            throw new IIOException("Could not skip pattern data");
        }
    }
}

