/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import javax.imageio.ImageTypeSpecifier;

enum TupleType {
    BLACKANDWHITE(1, 1, 1, 1),
    BLACKANDWHITE_ALPHA(2, 1, 1, 2),
    GRAYSCALE(1, 2, 65535, 1),
    GRAYSCALE_ALPHA(2, 2, 65535, 3),
    RGB(3, 1, 65535, 1),
    RGB_ALPHA(4, 1, 65535, 3),
    CMYK(4, 2, 65535, 1),
    CMYK_ALPHA(5, 1, 65535, 3),
    BLACKANDWHITE_WHITE_IS_ZERO(1, 1, 1, 1);

    private final int samplesPerPixel;
    private final int minMaxSample;
    private final int maxMaxSample;
    private final int transparency;

    private TupleType(int n2, int n3, int n4, int n5) {
        this.samplesPerPixel = n2;
        this.minMaxSample = n3;
        this.maxMaxSample = n4;
        this.transparency = n5;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public boolean isValidMaxSample(int n) {
        return n >= this.minMaxSample && n <= this.maxMaxSample;
    }

    static TupleType forPNM(Raster raster) {
        return TupleType.filterPNM(TupleType.forPAM(raster));
    }

    static TupleType forPNM(ImageTypeSpecifier imageTypeSpecifier) {
        return TupleType.filterPNM(TupleType.forPAM(imageTypeSpecifier));
    }

    private static TupleType filterPNM(TupleType tupleType) {
        if (tupleType == null) {
            return null;
        }
        switch (tupleType) {
            case BLACKANDWHITE: {
                return BLACKANDWHITE_WHITE_IS_ZERO;
            }
            case GRAYSCALE: 
            case RGB: {
                return tupleType;
            }
        }
        return null;
    }

    static TupleType forPAM(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        switch (sampleModel.getTransferType()) {
            case 0: 
            case 1: 
            case 3: {
                int n = sampleModel.getNumBands();
                if (n == 1 && sampleModel.getSampleSize(0) == 1) {
                    return BLACKANDWHITE;
                }
                if (n == 2 && sampleModel.getSampleSize(0) == 1 && sampleModel.getSampleSize(1) == 1) {
                    return BLACKANDWHITE_ALPHA;
                }
                if (sampleModel.getSampleSize(0) != 8 && sampleModel.getSampleSize(0) != 16) {
                    return null;
                }
                for (int i = 1; i < n; ++i) {
                    if (sampleModel.getSampleSize(0) == sampleModel.getSampleSize(i)) continue;
                    return null;
                }
                if (n == 1) {
                    return GRAYSCALE;
                }
                if (n == 2) {
                    return GRAYSCALE_ALPHA;
                }
                if (n == 3) {
                    return RGB;
                }
                if (n != 4) break;
                return RGB_ALPHA;
            }
        }
        return null;
    }

    static TupleType forPAM(ImageTypeSpecifier imageTypeSpecifier) {
        switch (imageTypeSpecifier.getBufferedImageType()) {
            case 12: {
                switch (imageTypeSpecifier.getNumBands()) {
                    case 1: {
                        return imageTypeSpecifier.getBitsPerBand(0) == 1 ? BLACKANDWHITE : null;
                    }
                    case 2: {
                        return imageTypeSpecifier.getBitsPerBand(0) == 2 || imageTypeSpecifier.getBitsPerBand(0) == 1 && imageTypeSpecifier.getBitsPerBand(1) == 1 ? BLACKANDWHITE_ALPHA : null;
                    }
                }
                return null;
            }
            case 10: 
            case 11: {
                return GRAYSCALE;
            }
            case 1: 
            case 4: 
            case 5: {
                return RGB;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return RGB_ALPHA;
            }
        }
        switch (imageTypeSpecifier.getSampleModel().getTransferType()) {
            case 0: 
            case 1: 
            case 3: {
                ColorModel colorModel = imageTypeSpecifier.getColorModel();
                if (colorModel instanceof IndexColorModel) break;
                ColorSpace colorSpace = colorModel.getColorSpace();
                int n = imageTypeSpecifier.getNumBands();
                if (imageTypeSpecifier.getBitsPerBand(0) != 8 && imageTypeSpecifier.getBitsPerBand(0) != 16) {
                    return null;
                }
                for (int i = 1; i < n; ++i) {
                    if (imageTypeSpecifier.getBitsPerBand(0) == imageTypeSpecifier.getBitsPerBand(i)) continue;
                    return null;
                }
                if (colorSpace.getType() == 6 && n == 1) {
                    return GRAYSCALE;
                }
                if (colorSpace.getType() == 6 && colorModel.hasAlpha() && n == 2) {
                    return GRAYSCALE_ALPHA;
                }
                if (colorSpace.getType() == 5 && n == 3) {
                    return RGB;
                }
                if (colorSpace.getType() == 5 && colorModel.hasAlpha() && n == 4) {
                    return RGB_ALPHA;
                }
                if (colorSpace.getType() == 9 && n == 4) {
                    return CMYK;
                }
                if (colorSpace.getType() != 9 || !colorModel.hasAlpha() || n != 5) break;
                return CMYK_ALPHA;
            }
        }
        return null;
    }
}

