/*******************************************************************************
 * Example of an HTML Viewer Extension
 *
 * Beware: the HTML viewer is custom implemented and uses a custom framework
 *         that might look like something you know (e.g. jQuery) but is not.
 ******************************************************************************/
var extension = function() {

    // Our custom init
    this.init = function(){

        // When the init is done, the viewer might not be really ready
        // the viewer will check if it is online or not to determine what
        // it has to show in the toolbar and some other behavioral things.
        amIOnline.check(function( isOnline ) {

            alert( "This alert comes from the HTMLViewer Sample Plugin!" );
        });
    }

};

// This will add our init function to the very end of the
// initialization cycle. But: the viewer will not be ready then
// think of this as the jQuery(function) - init.
var events = (window.hmtlviewer || $).Events;
events && events.addInitEvent((new extension()).init);
