package com.inet.samples.htmlviewer;

import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.renderer.html.viewer.HTMLViewerScriptResource;

/**
 * Server plugin which registers a custom HTML viewer script source
 */
@PluginInfo( //
id = "htmlviewerextension", //
dependencies = "reporting", //
group = "samples", //
version = "25.10.196", //
icon = "com/inet/samples/htmlviewer/htmlviewer_extension_48.png" //
)
public class HTMLViewerExtensionPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {

        // registers the resource
        spm.register( HTMLViewerScriptResource.class, HTMLViewerScriptResource.fileDescription( getClass().getResource( "extension.js" ) ) );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
