# HTML Viewer Print via PDF Plugin

This sample plugin will clear the list of available printers and add the `printPDF` method as the sole printer. That means that clicking the print button will result in a PDF download.

 PDFs will be downloaded but the user has to open and print them manually.

The full JavaScript API for the HTML Viewer is available from the documentation, found in `Documentation and Samples/ReportViewer - HTML API Doc`.

## Activate the included plugin

A compiled version of the plugin is made available as `htmlviewer.printpdf.sample.zip`. In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details.

## Server Plugin

Extending the HTML Viewer requires the registration of every additional resource in the ServerPluginManager. For more information please see the source files of this sample and the chapter `Platform Programming Guide | Plugins` in the Help of the SDK.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `reporting.jar` (included in the `plugins/reporting.zip` file)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `htmlviewer.printpdf.sample.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `htmlviewer.printpdf.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

## Deploying

Copy the ZIP file of the plugin into the plugins directory of the server or Drag & Drop the plugin into the Store application of the server for sideloading. Then restart the server. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

