/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.BoxView;
import com.inet.html.views.ImageView;
import com.inet.html.views.layouts.Layout;
import java.awt.Dimension;
import javax.swing.text.View;

public class MinMaxControl {
    private BoxView view;
    private LengthUnit minWidth;
    private LengthUnit minHeight;
    private LengthUnit maxWidth;
    private LengthUnit maxHeight;
    private boolean hasWHConstraint;
    private boolean hasNoIntrinsicHeight = true;
    private boolean hasNoIntrinsicWidth = true;

    public MinMaxControl(BoxView view) {
        this.view = view;
        switch (view.getDisplay()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            default: {
                this.minWidth = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.MIN_WIDTH);
                this.minHeight = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.MIN_HEIGHT);
                this.maxWidth = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.MAX_WIDHT);
                this.maxHeight = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.MAX_HEIGHT);
                if (this.minWidth != null && !this.minWidth.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.minHeight != null && !this.minHeight.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.maxWidth != null && !this.maxWidth.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.maxHeight != null && !this.maxHeight.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (!this.hasWHConstraint) {
                    this.minHeight = null;
                    this.minWidth = null;
                    this.maxHeight = null;
                    this.maxWidth = null;
                    break;
                }
                if (!(view instanceof ImageView)) break;
                this.hasNoIntrinsicWidth = view.getWidthUnit() != null && !view.getWidthUnit().isAuto();
                this.hasNoIntrinsicHeight = view.getHeightUnit() != null && !view.getHeightUnit().isAuto();
            }
        }
    }

    public MinMaxControl(BoxView view, LengthUnit maxWidth, LengthUnit maxHeight) {
        this.view = view;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.hasWHConstraint = true;
        if (view instanceof ImageView) {
            this.hasNoIntrinsicWidth = view.getWidthUnit() != null && !view.getWidthUnit().isAuto();
            this.hasNoIntrinsicHeight = view.getHeightUnit() != null && !view.getHeightUnit().isAuto();
        }
    }

    public boolean hasWHConstraint() {
        return this.hasWHConstraint;
    }

    public Dimension getMinMaxValues(boolean widthOnly, int w, int h) {
        if (!this.hasWHConstraint) {
            return new Dimension(w, h);
        }
        int minWidthUsed = this.getLengthValue(this.minWidth, 0, false);
        int maxWidthUsed = Math.max(this.getLengthValue(this.maxWidth, w, false), minWidthUsed);
        if (widthOnly) {
            if (w > maxWidthUsed) {
                w = maxWidthUsed;
            } else if (w < minWidthUsed) {
                w = minWidthUsed;
            }
            return new Dimension(w, 0);
        }
        int minHeightUsed = this.getLengthValue(this.minHeight, 0, true);
        int maxHeightUsed = Math.max(this.getLengthValue(this.maxHeight, h, true), minHeightUsed);
        if (w > maxWidthUsed) {
            if (h > maxHeightUsed) {
                if ((float)maxWidthUsed / (float)w < (float)maxHeightUsed / (float)h) {
                    return new Dimension(maxWidthUsed, Math.max(minHeightUsed, this.hasNoIntrinsicHeight ? h : maxWidthUsed * h / w));
                }
                return new Dimension(Math.max(minWidthUsed, this.hasNoIntrinsicWidth ? w : maxHeightUsed * w / h), maxHeightUsed);
            }
            h = Math.max(this.hasNoIntrinsicHeight ? h : maxWidthUsed * h / w, minHeightUsed);
            w = maxWidthUsed;
        } else if (w < minWidthUsed) {
            if (h < minHeightUsed) {
                if ((float)minWidthUsed / (float)w <= (float)minHeightUsed / (float)h) {
                    return new Dimension(Math.min(maxWidthUsed, this.hasNoIntrinsicWidth ? w : (h > 0 ? minHeightUsed * w / h : 0)), minHeightUsed);
                }
                return new Dimension(minWidthUsed, Math.min(maxHeightUsed, this.hasNoIntrinsicHeight ? h : minWidthUsed * h / w));
            }
            h = Math.min(this.hasNoIntrinsicHeight ? h : minHeightUsed * h / w, maxHeightUsed);
            w = minWidthUsed;
        } else {
            if (h > maxHeightUsed) {
                return new Dimension(Math.max(this.hasNoIntrinsicWidth ? w : maxHeightUsed * w / h, minWidthUsed), maxHeightUsed);
            }
            if (h < minHeightUsed) {
                return new Dimension(Math.min(this.hasNoIntrinsicWidth ? w : (h > 0 ? minHeightUsed * w / h : 0), maxWidthUsed), minHeightUsed);
            }
        }
        return new Dimension(w, h);
    }

    private int getLengthValue(LengthUnit l, int fallback, boolean isHeight) {
        if (l == null || l.isAuto() || l.isAsterisk() || isHeight && !this.hasDefinedHeight(Layout.getHeightParent(this.view))) {
            return fallback;
        }
        if (l.getType() == 0) {
            return Math.round(l.getValue());
        }
        if (isHeight) {
            BoxView hp = Layout.getHeightParent(this.view);
            return Math.round(l.calculateValue(Layout.getHeight(this.view, hp, true), hp));
        }
        View parent = this.view.getParent();
        float refValue = parent instanceof BoxView ? (float)((BoxView)parent).getContentWidth() : parent.getPreferredSpan(0);
        return Math.round(l.calculateValue(refValue, parent));
    }

    private boolean hasDefinedHeight(BoxView v) {
        if (v != null) {
            return v.getHeightUnit() != null && !v.getHeightUnit().isAuto();
        }
        return true;
    }
}

