/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;

public class ClearValue
extends HtmlAttribute {
    private byte clear = 0;
    static final ClearValue PARSER = new ClearValue();

    public byte getClear() {
        return this.clear;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        ClearValue br = new ClearValue();
        String lower = valueStr.toLowerCase().trim();
        br.setString(valueStr);
        if ("inherit".equals(lower)) {
            return AttributeValue.INHERIT;
        }
        if (lower.equals("none")) {
            br.clear = 0;
            return br;
        }
        if (lower.equals("left")) {
            br.clear = 1;
            return br;
        }
        if (lower.equals("right")) {
            br.clear = (byte)2;
            return br;
        }
        if (lower.equals("both")) {
            br.clear = (byte)3;
            return br;
        }
        return null;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        String lower = value.toLowerCase().trim();
        if ("all".equals(lower)) {
            ClearValue br = new ClearValue();
            br.setString(value);
            br.clear = (byte)3;
            return br;
        }
        return this.parseCssValue(value, false);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClearValue)) {
            return false;
        }
        ClearValue other = (ClearValue)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.clear == other.clear;
    }
}

