/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.editor.HtmlConverter;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlWriter;
import com.inet.html.handler.PasteFileHandler;
import com.inet.html.image.ImageFetcher;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.ImageView;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class InetHtmlTransferHandler
extends TransferHandler
implements CaretListener {
    private JEditorPane editor;
    private PasteFileHandler customPasteHandler = null;
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private boolean exportoccurred = false;
    private boolean dropPending = false;
    private int sourceStart;
    private int sourceEnd;
    private int insertStart;
    private int insertEnd;
    private boolean pasteAlwaysPlain;
    private long pasteAlwaysPlainActivationTime;
    private boolean isExportToSystemClipboard = false;
    private static final long PASTE_PLAIN_TIMEOUT = 5000L;
    public static final Set<String> IMAGE_TYPES = new HashSet<String>();
    public static final Set<String> HTML_TYPES = new HashSet<String>();
    public static final Set<String> TEXT_TYPES = new HashSet<String>();
    private static DataFlavor FLAVOR_INTERNAL_STRING;
    private static DataFlavor FLAVOR_INTERNAL_HTML;
    private static final boolean RTF_ACTIVE = false;
    private static final String FRAGMENT_START = "<!--StartFragment-->";
    private static final String FRAGMENT_END = "<!--EndFragment-->";

    public InetHtmlTransferHandler(JEditorPane c) {
        this.editor = c;
        Object handler = this.editor.getClientProperty("PasteFileHandler");
        if (handler instanceof PasteFileHandler) {
            this.customPasteHandler = (PasteFileHandler)handler;
        }
        HtmlTransferable.AVAILABLE_FLAVORS_BASE = new ArrayList();
        HtmlTransferable.AVAILABLE_FLAVORS_HTML = new ArrayList();
        HtmlTransferable.AVAILABLE_FLAVORS_IMAGE = new ArrayList();
        try {
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;class=java.lang.String"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;class=java.io.Reader"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(FLAVOR_INTERNAL_STRING);
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;class=java.lang.String"));
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;class=java.io.Reader"));
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(FLAVOR_INTERNAL_HTML);
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(DataFlavor.imageFlavor);
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/png"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/jpeg"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/tiff"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/gif"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-ico"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-icon"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-win-bitmap"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-ms-bmp"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/bmp"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-java-image"));
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
    }

    public void updatePasteFileHandler() {
        if (this.editor == null) {
            return;
        }
        Object handler = this.editor.getClientProperty("PasteFileHandler");
        this.customPasteHandler = handler != null && handler instanceof PasteFileHandler ? (PasteFileHandler)this.editor.getClientProperty("PasteFileHandler") : null;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        boolean hasCustomHandler;
        boolean editable = this.editor.isEditable();
        boolean bl = hasCustomHandler = this.customPasteHandler != null;
        if (flavors != null) {
            for (DataFlavor flavor : flavors) {
                if (flavor == FLAVOR_INTERNAL_HTML) {
                    return editable;
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("text/plain")) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("application/x-java-serialized-object") && flavor.getRepresentationClass() == String.class) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("text/html")) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("text/rtf")) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("image/x-java-image")) {
                    return editable;
                }
                if (flavor.getMimeType().startsWith("application/x-java-file-list") && flavor.getRepresentationClass() == List.class) {
                    return editable || hasCustomHandler;
                }
                if (!flavor.getMimeType().startsWith("text/uri-list") || flavor.getRepresentationClass() != String.class && flavor.getRepresentationClass() != List.class) continue;
                return editable || hasCustomHandler;
            }
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable trans) {
        if (trans == null || !this.canImport(comp, trans.getTransferDataFlavors())) {
            return false;
        }
        Document doc = this.editor.getDocument();
        this.insertStart = this.editor.getSelectionStart();
        this.insertEnd = this.editor.getSelectionEnd();
        if (this.exportoccurred) {
            this.dropPending = true;
        }
        if ((this.editor.isEditable() || this.customPasteHandler != null) && comp.getTransferHandler() instanceof InetHtmlTransferHandler) {
            boolean pastePlain = (this.getCurrentEventModifiers() & 1) > 0 && !this.isNormalInsert() || this.isModePlain();
            InetHtmlTransferHandler componentTransferHandler = (InetHtmlTransferHandler)comp.getTransferHandler();
            boolean success = componentTransferHandler.insertDataIntoDocument(trans, doc, this.insertStart, this.insertEnd, pastePlain);
            if (success) {
                this.editor.setSelectionEnd(this.editor.getSelectionStart());
                this.editor.requestFocus();
            }
            return success;
        }
        return false;
    }

    private int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    private boolean isNormalInsert() {
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof KeyEvent) {
            KeyEvent event = (KeyEvent)currentEvent;
            return event.getKeyCode() == 155 && (event.getModifiers() & InetHtmlEditorKit.SHORTCUT_KEY_MASK) == 0;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent component) {
        return ((JTextComponent)component).isEditable() ? 3 : 1;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        boolean forcePlain;
        this.exportComp = (JTextComponent)comp;
        this.shouldRemove = true;
        this.sourceStart = this.exportComp.getSelectionStart();
        this.sourceEnd = this.exportComp.getSelectionEnd();
        this.exportoccurred = true;
        this.dropPending = false;
        boolean bl = forcePlain = (this.getCurrentEventModifiers() & 1) > 0 || this.isModePlain();
        if (this.isExportToSystemClipboard || forcePlain) {
            return this.sourceStart != this.sourceEnd ? new SelectionTransferable(this.exportComp, this.sourceStart, this.sourceEnd) : null;
        }
        return this.sourceStart != this.sourceEnd ? new HtmlTransferable(this.exportComp, this.sourceStart, this.sourceEnd) : null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.shouldRemove && action == 2) {
            if (this.dropPending && source instanceof JEditorPane) {
                try {
                    int copyLen = this.sourceEnd - this.sourceStart;
                    if (this.insertStart >= this.sourceEnd) {
                        this.exportComp.getDocument().remove(this.sourceStart, copyLen);
                    } else if (this.insertEnd <= this.sourceStart) {
                        this.exportComp.getDocument().remove(this.sourceStart + copyLen, copyLen);
                    } else {
                        int remBefore;
                        int remAfter = this.sourceEnd - this.insertStart;
                        if (remAfter > 0) {
                            this.exportComp.getDocument().remove(this.insertStart + copyLen, remAfter);
                        }
                        if ((remBefore = this.insertStart - this.sourceStart) > 0) {
                            this.exportComp.getDocument().remove(this.sourceStart, remBefore);
                        }
                    }
                }
                catch (BadLocationException e) {
                    HtmlTransferable transfer = (HtmlTransferable)data;
                    transfer.removeData();
                }
            } else {
                HtmlTransferable transfer = (HtmlTransferable)data;
                transfer.removeData();
            }
        }
        this.exportoccurred = false;
        this.dropPending = false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The transfer handler requires local file access to access the content of the files which are pasted into the Sqind editor component.")
    public boolean insertDataIntoDocument(Transferable data, Document doc, int start, int end, boolean pasteAlwaysPlain) {
        DataFlavor[] flavors;
        block88: {
            boolean editable;
            DataFlavor flavorTextPlain;
            block87: {
                DataFlavor flavorFileListString;
                DataFlavor flavorFileList;
                DataFlavor flavorImage;
                DataFlavor flavorRtf;
                block84: {
                    flavors = data.getTransferDataFlavors();
                    pasteAlwaysPlain |= !(doc instanceof InetHtmlDocument);
                    DataFlavor flavorHtmlStream = null;
                    DataFlavor flavorHtmlChar = null;
                    DataFlavor flavorHtmlString = null;
                    flavorRtf = null;
                    flavorImage = null;
                    flavorTextPlain = null;
                    flavorFileList = null;
                    flavorFileListString = null;
                    DataFlavor allDataFlavor = null;
                    try {
                        Field field = DataFlavor.class.getDeclaredField("allHtmlFlavor");
                        if (field != null) {
                            allDataFlavor = (DataFlavor)field.get(null);
                        }
                    }
                    catch (Throwable e) {
                        Logger.debug("Error while fetching all-data flavour" + e.getMessage());
                    }
                    for (DataFlavor flavor : flavors) {
                        if (flavor == FLAVOR_INTERNAL_HTML) {
                            flavorHtmlString = FLAVOR_INTERNAL_HTML;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("text/rtf") && flavor.getRepresentationClass() == InputStream.class) {
                            flavorRtf = flavor;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("text/richtext") && flavor.getRepresentationClass() == InputStream.class) {
                            flavorRtf = flavor;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("text/html")) {
                            Class<?> clazz = flavor.getRepresentationClass();
                            if (flavorHtmlChar == null && clazz == char[].class) {
                                flavorHtmlChar = flavor;
                            }
                            if (flavorHtmlString == null && clazz == String.class) {
                                flavorHtmlString = flavor;
                            }
                            if (flavorHtmlStream != null || clazz != Reader.class) continue;
                            flavorHtmlStream = flavor;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("image/x-java-image") && flavor.getRepresentationClass() == Image.class) {
                            flavorImage = flavor;
                            continue;
                        }
                        if ((flavor.getMimeType().startsWith("text/plain") || DataFlavor.stringFlavor.equals(flavor)) && flavor.getRepresentationClass() == String.class) {
                            flavorTextPlain = flavor;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("application/x-java-serialized-object") && flavor.getRepresentationClass() == String.class) {
                            flavorTextPlain = flavor;
                            continue;
                        }
                        if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass() == String.class) {
                            flavorFileListString = flavor;
                            continue;
                        }
                        if ((!flavor.getMimeType().startsWith("x-special/gnome-copied-files") || flavor.getRepresentationClass() != InputStream.class) && (!flavor.getMimeType().startsWith("application/x-java-file-list") || flavor.getRepresentationClass() != List.class)) continue;
                        flavorFileList = flavor;
                    }
                    editable = this.editor.isEditable();
                    if (!pasteAlwaysPlain) {
                        block83: {
                            boolean useAllFlavor = false;
                            if (flavorHtmlString == FLAVOR_INTERNAL_HTML) {
                                useAllFlavor = true;
                            }
                            try {
                                boolean hasHtmlFlavor;
                                boolean bl = hasHtmlFlavor = flavorHtmlChar != null || flavorHtmlStream != null || flavorHtmlString != null;
                                if (allDataFlavor != null && hasHtmlFlavor && allDataFlavor.getRepresentationClass() == String.class && data.getTransferData(allDataFlavor) != null) {
                                    flavorHtmlString = allDataFlavor;
                                    useAllFlavor = true;
                                }
                            }
                            catch (Exception hasHtmlFlavor) {
                                // empty catch block
                            }
                            if (!useAllFlavor && flavorHtmlStream != null && editable) {
                                try {
                                    int len;
                                    Reader in = (Reader)data.getTransferData(flavorHtmlStream);
                                    CharArrayWriter w = new CharArrayWriter();
                                    char[] buffer = new char[65536];
                                    while ((len = in.read(buffer)) >= 0) {
                                        w.write(buffer, 0, len);
                                    }
                                    in.close();
                                    String html = w.toString();
                                    if (html.length() > 0) {
                                        this.pasteHTML((InetHtmlDocument)doc, start, end, html);
                                        return true;
                                    }
                                }
                                catch (UnsupportedFlavorException e) {
                                    Logger.error(e);
                                }
                                catch (IOException e) {
                                    Logger.error(e);
                                }
                                catch (StackOverflowError e) {
                                    Logger.error(e);
                                }
                            }
                            if (!useAllFlavor && flavorHtmlChar != null && editable) {
                                try {
                                    char[] transferData = (char[])data.getTransferData(flavorHtmlChar);
                                    StringBuffer stringData = new StringBuffer(transferData.length / 2 + 1);
                                    for (int i = 0; i < transferData.length; ++i) {
                                        char c = transferData[i];
                                        if (c == '\u0000' || i <= 3 && c >= '\ufffa') continue;
                                        stringData.append(c);
                                    }
                                    String html = stringData.toString();
                                    this.pasteHTML((InetHtmlDocument)doc, start, end, html);
                                    return true;
                                }
                                catch (UnsupportedFlavorException e1) {
                                    if (Logger.doesLog(1)) {
                                        Logger.error(e1);
                                    }
                                }
                                catch (IOException e1) {
                                    if (!Logger.doesLog(1)) break block83;
                                    Logger.error(e1);
                                }
                            }
                        }
                        if (flavorHtmlString != null && editable) {
                            try {
                                ((InetHtmlDocument)doc).pasteHTML((String)data.getTransferData(flavorHtmlString), start, end);
                                return true;
                            }
                            catch (UnsupportedFlavorException e1) {
                                if (Logger.doesLog(1)) {
                                    Logger.error(e1);
                                }
                            }
                            catch (IOException e1) {
                                if (!Logger.doesLog(1)) break block84;
                                Logger.error(e1);
                            }
                        }
                    }
                }
                if (flavorFileList != null || flavorFileListString != null) {
                    ArrayList<URI> uriList = new ArrayList<URI>();
                    try {
                        String[] parts;
                        if (flavorFileList != null && flavorFileList.getRepresentationClass() == List.class) {
                            List fileList = (List)data.getTransferData(flavorFileList);
                            for (File file : fileList) {
                                uriList.add(file.toURI());
                            }
                        } else if (flavorFileList != null && flavorFileList.getRepresentationClass() == InputStream.class && flavorTextPlain != null) {
                            String list = (String)data.getTransferData(flavorTextPlain);
                            parts = list.split("(\r\n|\r|\n)");
                            uriList = new ArrayList();
                            for (String part : parts) {
                                uriList.add(new File(part).toURI());
                            }
                        } else if (flavorFileListString != null) {
                            String list = (String)data.getTransferData(flavorFileListString);
                            parts = list.split("(\r\n|\r|\n)");
                            uriList = new ArrayList();
                            for (String part : parts) {
                                URI uri = new URI(part);
                                uriList.add(uri);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (Logger.doesLog(2)) {
                            Logger.warning("Failed to insert File/URI-List content: " + e.getMessage() + ", trying to insert text/plain content.");
                        }
                        uriList = null;
                    }
                    if (uriList != null && uriList.size() > 0) {
                        boolean skipToPastePlain = false;
                        for (URI uri : uriList) {
                            int lenBefore;
                            block86: {
                                File file;
                                block85: {
                                    lenBefore = doc.getLength();
                                    file = null;
                                    try {
                                        file = new File(uri);
                                    }
                                    catch (IllegalArgumentException part) {
                                        // empty catch block
                                    }
                                    if (this.customPasteHandler != null) {
                                        try {
                                            if (file != null && this.customPasteHandler.handlePaste(file, doc)) continue;
                                            if (!this.editor.isEditable()) {
                                                return false;
                                            }
                                        }
                                        catch (Throwable t) {
                                            if (Logger.doesLog(1)) {
                                                Logger.error(t);
                                            }
                                            if (this.editor.isEditable()) break block85;
                                            return false;
                                        }
                                    }
                                }
                                if (!(file != null && file.exists() || flavorTextPlain == null)) {
                                    skipToPastePlain = true;
                                    break;
                                }
                                if (file == null || !this.importFile(file, doc, start, end, pasteAlwaysPlain, false)) {
                                    try {
                                        boolean insertBreak;
                                        String transferData = uri.getPath();
                                        int index = transferData.lastIndexOf(47);
                                        if (index > 0) {
                                            transferData = transferData.substring(index + 1);
                                        }
                                        boolean bl = insertBreak = uriList.get(uriList.size() - 1) != uri;
                                        if (!pasteAlwaysPlain && doc instanceof InetHtmlDocument) {
                                            Object defaultClass = doc.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                                            transferData = HtmlConverter.text2html(transferData, null, false, defaultClass != null ? defaultClass.toString() : null);
                                            if (insertBreak) {
                                                transferData = transferData + "<br>";
                                            }
                                            ((InetHtmlDocument)doc).pasteHTML(transferData, start, end, uri);
                                        } else {
                                            doc.remove(start, end - start);
                                            doc.insertString(start, transferData + (insertBreak ? "\n" : ""), null);
                                        }
                                    }
                                    catch (BadLocationException e) {
                                        if (!Logger.doesLog(2)) break block86;
                                        Logger.warning("Failed to insert File/URI-List content: " + e.getMessage());
                                    }
                                }
                            }
                            int lenAfter = doc.getLength();
                            end = start = start + lenAfter - lenBefore;
                        }
                        if (!skipToPastePlain) {
                            return true;
                        }
                    }
                }
                if (!pasteAlwaysPlain && editable && (flavorRtf == null || flavorTextPlain == null) && flavorImage != null) {
                    try {
                        ((InetHtmlDocument)doc).insertImage((Image)data.getTransferData(flavorImage), start, null);
                        return true;
                    }
                    catch (UnsupportedFlavorException e1) {
                        if (Logger.doesLog(1)) {
                            Logger.error(e1);
                        }
                    }
                    catch (IOException e1) {
                        if (!Logger.doesLog(1)) break block87;
                        Logger.error(e1);
                    }
                }
            }
            if (flavorTextPlain != null && editable) {
                try {
                    String transferData = (String)data.getTransferData(flavorTextPlain);
                    if (transferData == null) {
                        return false;
                    }
                    if (doc instanceof InetHtmlDocument) {
                        transferData = HtmlConverter.text2html(transferData, null, false, (String)doc.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS));
                        this.pasteHTML((InetHtmlDocument)doc, start, end, transferData);
                    } else {
                        doc.remove(start, end - start);
                        doc.insertString(start, transferData, null);
                    }
                    return true;
                }
                catch (UnsupportedFlavorException e1) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e1);
                    }
                }
                catch (IOException e1) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e1);
                    }
                }
                catch (BadLocationException e) {
                    if (!Logger.doesLog(1)) break block88;
                    Logger.error(e);
                }
            }
        }
        if (flavors.length > 0 && Logger.doesLog(2)) {
            Logger.warning("The editor cannot use this type of pasted data. " + flavors[0]);
        }
        return false;
    }

    private void pasteHTML(InetHtmlDocument doc, int start, int end, String html) {
        if (start > 0 || end != doc.getLength()) {
            doc.pasteHTML(html, start, end);
        } else {
            if (start == end) {
                try {
                    doc.remove(0, 0);
                }
                catch (BadLocationException e) {
                    Logger.error(e);
                }
            }
            doc.pasteHTML(html, start, end, null);
        }
    }

    public boolean importFile(File file, Document doc, int start, int end, boolean pasteAlwaysPlain, boolean ignoreHandler) {
        if (!this.editor.isEditable()) {
            return true;
        }
        if (file == null || !file.exists() || !file.canRead() || doc == null) {
            return false;
        }
        String lowerName = file.getName().toLowerCase();
        int lastIndex = lowerName.lastIndexOf(46);
        if (lastIndex < 0 || lastIndex >= lowerName.length() - 1) {
            return false;
        }
        String suffix = lowerName.substring(lastIndex + 1);
        pasteAlwaysPlain |= !(doc instanceof InetHtmlDocument);
        InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
        if (IMAGE_TYPES.contains(suffix)) {
            if (pasteAlwaysPlain) {
                if (Logger.doesLog(1)) {
                    Logger.error("Cannot insert an image into a text/plain document.");
                }
                return false;
            }
            BufferedImage image = null;
            try {
                image = (BufferedImage)ImageFetcher.fetchImage(file);
            }
            catch (IOException e) {
                if (Logger.doesLog(1)) {
                    Logger.error(e);
                }
                Logger.error(e);
            }
            if (image != null && ((InetHtmlConfiguration)htmlDoc.getProperty(InetHtmlDocument.PROPERTY_CONFIGURATION)).isAllowInternalImages()) {
                htmlDoc.insertImage(image, start, file);
            } else {
                htmlDoc.insertImage(null, start, file);
            }
            return true;
        }
        if (HTML_TYPES.contains(suffix)) {
            String content = this.getContent(file);
            if (content != null) {
                if (!pasteAlwaysPlain) {
                    htmlDoc.pasteHTML(content, start, end, file.toURI());
                    return true;
                }
                content = HtmlConverter.html2text(content);
                try {
                    doc.remove(start, end - start);
                    doc.insertString(start, content, null);
                    return true;
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unable to paste the html content referenced by the filename '" + file.getPath() + "'");
            }
            return false;
        }
        if (TEXT_TYPES.contains(suffix)) {
            String content = this.getContent(file);
            if (content != null) {
                if (!pasteAlwaysPlain) {
                    Object defaultClass = doc.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                    content = HtmlConverter.text2html(content, null, true, defaultClass != null ? defaultClass.toString() : null);
                    this.pasteHTML((InetHtmlDocument)doc, start, end, content);
                    return true;
                }
                try {
                    doc.remove(start, end - start);
                    doc.insertString(start, content, null);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unable to paste the html content referenced by the filename '" + file.getPath() + "'");
            }
            return false;
        }
        return false;
    }

    private String getContent(File f) {
        StringBuilder b = new StringBuilder();
        try {
            FileInputStream in = new FileInputStream(f);
            int inByte = 0;
            while ((inByte = ((InputStream)in).read()) >= 0) {
                b.append((char)inByte);
            }
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return b.toString();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getSource() == this.editor && e.getDot() != e.getMark()) {
            try {
                Clipboard systemSelection = this.editor.getToolkit().getSystemSelection();
                if (systemSelection != null) {
                    this.isExportToSystemClipboard = true;
                    this.exportToClipboard(this.editor, systemSelection, 1);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.isExportToSystemClipboard = false;
            }
        }
    }

    public void setModePlain() {
        this.pasteAlwaysPlain = true;
        this.pasteAlwaysPlainActivationTime = System.currentTimeMillis();
    }

    private boolean isModePlain() {
        if (System.currentTimeMillis() - this.pasteAlwaysPlainActivationTime > 5000L) {
            this.pasteAlwaysPlain = false;
        }
        boolean result = this.pasteAlwaysPlain;
        this.pasteAlwaysPlain = false;
        return result;
    }

    static {
        try {
            FLAVOR_INTERNAL_STRING = new DataFlavor("application/jplain;class=java.lang.String");
        }
        catch (ClassNotFoundException e1) {
            FLAVOR_INTERNAL_STRING = new DataFlavor(PlainFlavor.class, null);
        }
        try {
            FLAVOR_INTERNAL_HTML = new DataFlavor("application/jhtml;class=java.lang.String");
        }
        catch (ClassNotFoundException e) {
            FLAVOR_INTERNAL_HTML = new DataFlavor(HtmlFlavor.class, null);
        }
        IMAGE_TYPES.add("png");
        IMAGE_TYPES.add("gif");
        IMAGE_TYPES.add("jpg");
        IMAGE_TYPES.add("jpeg");
        IMAGE_TYPES.add("bmp");
        IMAGE_TYPES.add("tif");
        IMAGE_TYPES.add("tiff");
        HTML_TYPES.add("htm");
        HTML_TYPES.add("html");
        TEXT_TYPES.add("txt");
        TEXT_TYPES.add("csv");
        TEXT_TYPES.add("log");
    }

    private static class HtmlTransferable
    implements Transferable {
        private static List<DataFlavor> AVAILABLE_FLAVORS_BASE;
        private static List<DataFlavor> AVAILABLE_FLAVORS_HTML;
        private static List<DataFlavor> AVAILABLE_FLAVORS_IMAGE;
        private String html = null;
        private String htmlAbsolutPathes = null;
        private String plain = null;
        private int start;
        private int end;
        private JComponent source;
        private Image image;

        public HtmlTransferable(JComponent comp, int start, int end) {
            this.start = start;
            this.end = end;
            this.source = comp;
            if (comp instanceof JEditorPane) {
                JEditorPane textPane = (JEditorPane)comp;
                Document doc = textPane.getDocument();
                try {
                    int docLen = doc.getLength();
                    if (start > docLen) {
                        start = docLen;
                    }
                    if (end > docLen) {
                        end = docLen;
                    }
                    if (start == end) {
                        this.plain = "";
                        this.html = "";
                        return;
                    }
                    this.plain = doc.getText(start, end - start);
                    if (doc instanceof InetHtmlDocument) {
                        View imageView;
                        View rootView;
                        Element leaf = ElementUtils.getLeafAt(doc.getRootElements()[0], start);
                        if (end - start == 1 && leaf != null && "IMG".equalsIgnoreCase(leaf.getName()) && (rootView = textPane.getUI().getRootView(textPane)) != null && (imageView = this.findViewForElement(rootView, leaf)) instanceof ImageView) {
                            this.image = ((ImageView)imageView).getImage();
                            URL url = ((ImageView)imageView).getUrl();
                            this.plain = url != null ? url.toString() : "image";
                            return;
                        }
                        CharArrayWriter out = new CharArrayWriter();
                        InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
                        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, htmlDoc, start, end - start);
                        writer.write();
                        this.html = InetHtmlTransferHandler.FRAGMENT_START + out.toString() + InetHtmlTransferHandler.FRAGMENT_END;
                        out = new CharArrayWriter();
                        writer = new InetHtmlWriter((Writer)out, htmlDoc, start, end - start);
                        writer.setAbsolutePathMode(true);
                        writer.write();
                        this.htmlAbsolutPathes = InetHtmlTransferHandler.FRAGMENT_START + out.toString() + InetHtmlTransferHandler.FRAGMENT_END;
                    }
                }
                catch (BadLocationException e) {
                    Logger.error(e);
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            }
        }

        private View findViewForElement(View baseView, Element el) {
            if (baseView.getElement() == el) {
                return baseView;
            }
            for (int i = 0; i < baseView.getViewCount(); ++i) {
                View searchView;
                View view = baseView.getView(i);
                if (view == null || (searchView = this.findViewForElement(view, el)) == null) continue;
                return searchView;
            }
            return null;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (FLAVOR_INTERNAL_STRING == flavor) {
                return this.plain;
            }
            if (FLAVOR_INTERNAL_HTML.equals(flavor)) {
                return this.html;
            }
            if (flavor.getPrimaryType().endsWith("text")) {
                String data = null;
                if (flavor.getSubType().equals("plain")) {
                    data = this.plain;
                }
                if (flavor.getSubType().equals("html")) {
                    data = this.htmlAbsolutPathes;
                }
                if (data != null) {
                    Class<?> type = flavor.getRepresentationClass();
                    if (type == String.class) {
                        return data;
                    }
                    if (type == InputStream.class) {
                        return new StringBufferInputStream(data);
                    }
                    if (type == Reader.class) {
                        return new StringReader(data);
                    }
                }
            }
            if (flavor.getPrimaryType().equals("image")) {
                if (flavor.equals(DataFlavor.imageFlavor)) {
                    return this.image;
                }
                int colorModel = 2;
                if (flavor.getSubType().startsWith("bmp")) {
                    colorModel = 1;
                }
                BufferedImage copy = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), colorModel);
                copy.getGraphics().drawImage(this.image, 0, 0, new Color(1, 1, 1, 1), null);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                boolean written = false;
                if (flavor.getSubType().startsWith("jpeg")) {
                    written = ImageIO.write((RenderedImage)copy, "jpeg", stream);
                }
                if (flavor.getSubType().startsWith("tiff")) {
                    written = ImageIO.write((RenderedImage)copy, "tiff", stream);
                }
                if (flavor.getSubType().startsWith("png")) {
                    written = ImageIO.write((RenderedImage)copy, "png", stream);
                }
                if (flavor.getSubType().startsWith("gif")) {
                    written = ImageIO.write((RenderedImage)copy, "gif", stream);
                }
                if (flavor.getSubType().startsWith("bmp")) {
                    written = ImageIO.write((RenderedImage)copy, "bmp", stream);
                }
                if (!written) {
                    return null;
                }
                byte[] byteArray = stream.toByteArray();
                if (flavor.getRepresentationClass() == InputStream.class) {
                    return new ByteArrayInputStream(byteArray, 0, byteArray.length);
                }
                return byteArray;
            }
            if (FLAVOR_INTERNAL_STRING.equals(flavor) || DataFlavor.stringFlavor.equals(flavor)) {
                return this.plain;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            ArrayList<DataFlavor> flavours = new ArrayList<DataFlavor>();
            if (this.image != null) {
                flavours.addAll(AVAILABLE_FLAVORS_IMAGE);
            }
            if (this.html != null && this.image == null) {
                flavours.addAll(AVAILABLE_FLAVORS_HTML);
            }
            if (this.plain != null && this.image == null) {
                flavours.addAll(AVAILABLE_FLAVORS_BASE);
            }
            return flavours.toArray(new DataFlavor[flavours.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor f : this.getTransferDataFlavors()) {
                if (!f.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        public void removeData() {
            if (this.source instanceof JEditorPane) {
                try {
                    JEditorPane textPane = (JEditorPane)this.source;
                    textPane.getDocument().remove(this.start, this.end - this.start);
                }
                catch (BadLocationException e) {
                    Logger.error(e);
                }
            }
        }
    }

    private static class SelectionTransferable
    implements Transferable {
        private String plain = null;

        public SelectionTransferable(JComponent comp, int start, int end) {
            if (comp instanceof JEditorPane) {
                JEditorPane textPane = (JEditorPane)comp;
                Document doc = textPane.getDocument();
                try {
                    int docLen = doc.getLength();
                    if (start > docLen) {
                        start = docLen;
                    }
                    if (end > docLen) {
                        end = docLen;
                    }
                    if (start == end) {
                        this.plain = "";
                        return;
                    }
                    this.plain = doc.getText(start, end - start);
                }
                catch (BadLocationException e) {
                    Logger.error(e);
                }
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.getPrimaryType().endsWith("text") && flavor.getSubType().equals("plain")) {
                return this.plain;
            }
            if (flavor.equals(FLAVOR_INTERNAL_STRING)) {
                return this.plain;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return HtmlTransferable.AVAILABLE_FLAVORS_BASE.toArray(new DataFlavor[HtmlTransferable.AVAILABLE_FLAVORS_BASE.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor f : this.getTransferDataFlavors()) {
                if (!f.equals(flavor)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class PlainFlavor {
        private PlainFlavor() {
        }
    }

    private static final class HtmlFlavor {
        private HtmlFlavor() {
        }
    }
}

