/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;

public class ColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Color color = Color.BLACK;
    private boolean buttonBorderPainted = false;
    private Border border = new SoftBevelBorder(0){
        private static final long serialVersionUID = 1L;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (ColorButton.this.buttonBorderPainted) {
                super.paintBorder(c, g, x, y, width, height);
            }
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(width - 14, 1, width - 14, height - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (ColorButton.this.isEnabled()) {
                ColorButton.this.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            ColorButton.this.setBorderPainted(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ColorButton.this.isEnabled() && e.getX() < ColorButton.this.getWidth() - 14) {
                ColorButton.this.setBorderPainted(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorButton.this.setBorderPainted(false);
        }
    };

    public ColorButton() {
        this.initGUI();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.setBorderPainted(false);
    }

    private void initGUI() {
        this.setBorder(this.border);
        this.setBorderPainted(false);
        this.addMouseListener(this.mouseListener);
        this.setIcon(this.createIcon(this.color));
        this.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isArmed() {
                if (this.isEnabled()) {
                    return super.isArmed();
                }
                return false;
            }
        });
    }

    public void setColor(Color c) {
        if (c != null) {
            this.setIcon(this.createIcon(c));
            this.color = c;
        }
    }

    public Color getColor() {
        return this.color;
    }

    private ImageIcon createIcon(Color c) {
        ImageIcon icon = HtmlEditorUtils.getResourceImage("font_color.gif");
        BufferedImage image = new BufferedImage(29, 16, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
        graphics.setColor(c == null ? this.getBackground() : c);
        graphics.fillRect(0, 12, 16, 4);
        graphics.setColor(Color.BLACK);
        int x = 21;
        int y = 6;
        for (int h = 0; h < 4; ++h) {
            graphics.drawLine(x + h, y + h, x + 7 - h, y + h);
        }
        return new ImageIcon(image);
    }
}

