/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.EmbeddedImage;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.text.Element;

public class DocumentImage
implements EmbeddedImage {
    private ImageIcon image;
    private String url;
    private Element elementToUpdate;

    public DocumentImage(Image image, Element elementToUpdate) {
        if (image != null) {
            this.image = new ImageIcon(image);
        }
        this.elementToUpdate = elementToUpdate;
    }

    public void removeChachedImage() {
        if (this.url != null) {
            this.image = null;
        }
    }

    @Override
    public ImageIcon getImageData() {
        RemoteImage cached;
        if (this.image != null) {
            return this.image;
        }
        if (ImageCache.isCacheReference(this.url) && (cached = ImageCache.getStaticInstance().getImage(this.url, null, false, null)) != null && cached.getContent() != null) {
            this.image = new ImageIcon(cached.getContent());
        }
        return this.image;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setURL(String location) {
        this.url = location;
        InetHtmlDocument doc = (InetHtmlDocument)this.elementToUpdate.getDocument();
        if (location != null) {
            doc.addAttribute(this.elementToUpdate.getAttributes(), (Object)HTML.Attribute.SRC, new UrlValue(location, doc.getBase()));
        } else {
            doc.addAttribute(this.elementToUpdate.getAttributes(), (Object)HTML.Attribute.SRC, null);
        }
    }

    public void setRefElement(Element imageElement) {
        this.elementToUpdate = imageElement;
    }

    public String toString() {
        return "Image(" + (this.image != null ? "local" : "remote") + "): Location=" + this.url + " @ element=" + this.elementToUpdate;
    }
}

