/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.actions.InetHtmlAction;
import com.inet.html.utils.ElementUtils;
import com.inet.html.views.HtmlRootView;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class BeginEndLineAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private final boolean select;
    private final boolean begin;

    public BeginEndLineAction(String name, boolean begin, boolean select) {
        super(name);
        this.begin = begin;
        this.select = select;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JEditorPane textComp = this.getHtmlEditor(ev);
        if (textComp != null) {
            try {
                int offs = textComp.getCaretPosition();
                offs = BeginEndLineAction.getRowBeginEnd(textComp, offs, this.begin);
                if (this.select) {
                    textComp.moveCaretPosition(offs);
                } else {
                    textComp.setCaretPosition(offs);
                }
            }
            catch (BadLocationException bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(textComp);
            }
        }
    }

    public static int getRowBeginEnd(JTextComponent textComp, int offs, boolean begin) throws BadLocationException {
        Rectangle r = textComp.modelToView(offs);
        if (r == null) {
            return -1;
        }
        Document doc = textComp.getDocument();
        int length = doc.getLength();
        int y1 = r.y;
        int y2 = y1 + r.height;
        int lastStep = 0;
        do {
            lastStep = 0;
            do {
                if (begin) {
                    --offs;
                    ++lastStep;
                    continue;
                }
                ++offs;
                --lastStep;
            } while (!ElementUtils.isValidEditPosition(offs, doc) && offs >= 0 && offs <= length);
            Rectangle rectangle = r = offs <= length && offs >= 0 ? textComp.modelToView(offs) : null;
        } while (r != null && y2 > r.y && y1 < r.y + r.height || r == null && offs <= length && offs >= 0);
        return offs + lastStep;
    }

    public static Rectangle modelToView(JTextComponent textComp, int offs) throws BadLocationException {
        try {
            HtmlRootView rootView = (HtmlRootView)textComp.getUI().getRootView(textComp).getView(0);
            Insets insets = textComp.getMargin();
            Rectangle rec = insets == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rectangle(insets.left, insets.top, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return (Rectangle)rootView.nativeModelToView(offs, rec, Position.Bias.Forward);
        }
        catch (Exception e) {
            return textComp.modelToView(offs);
        }
    }
}

