/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AutoCompletionKeyListener
implements KeyListener {
    private JComboBox cmbTagAdding;
    private Action deletePrevCharAction;

    public AutoCompletionKeyListener(JComboBox cmbTagAdding) {
        this.cmbTagAdding = cmbTagAdding;
        JTextField textField = (JTextField)cmbTagAdding.getEditor().getEditorComponent();
        this.deletePrevCharAction = textField.getActionMap().get("delete-previous");
        textField.getActionMap().put("delete-previous", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField textField = (JTextField)AutoCompletionKeyListener.this.cmbTagAdding.getEditor().getEditorComponent();
                textField.replaceSelection("");
                AutoCompletionKeyListener.this.deletePrevCharAction.actionPerformed(e);
            }
        });
        cmbTagAdding.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AutoCompletionKeyListener.this.autoComplete(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getModifiers() != 0 || e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 16) {
            return;
        }
        this.autoComplete(false);
    }

    private void autoComplete(boolean popupShouldbeVisible) {
        JTextField textField = (JTextField)this.cmbTagAdding.getEditor().getEditorComponent();
        int caretPosition = textField.getCaretPosition();
        String typedtext = textField.getText();
        if (typedtext.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.cmbTagAdding.getItemCount(); ++i) {
            String item = this.cmbTagAdding.getItemAt(i).toString();
            if (!item.toLowerCase().startsWith(typedtext.toLowerCase())) continue;
            if (this.cmbTagAdding.isPopupVisible() || popupShouldbeVisible) {
                this.cmbTagAdding.setSelectedItem(item);
            }
            textField.setText(item);
            textField.setCaretPosition(item.length());
            textField.moveCaretPosition(caretPosition);
            break;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

