/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.views.ContentPainter;
import com.inet.html.views.ContentView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;

public class RotationPainter
extends ContentPainter {
    private static final double NINETY_DEGREES = Math.toRadians(90.0);
    private static final double ONE_EIGHTY_DEGREES = Math.toRadians(180.0);
    public static final int GLYPH_RIGHT = 1;
    public static final int GLYPH_LEFT = 2;
    public static final int GLYPH_DOWN = 3;
    public static final int GLYPH_UP = 4;
    private final int glyphOrientation;
    private ContentView view;
    private float[] charWidth;

    public RotationPainter(int glyphOrientation, ContentView view) {
        super(view);
        this.glyphOrientation = glyphOrientation;
        this.view = view;
    }

    @Override
    public void setView(ContentView view) {
        super.setView(view);
        this.view = view;
    }

    private int getRotationCharWidth(char c) {
        return this.getAscent() + this.getDescent();
    }

    @Override
    protected float calculateWidth() {
        try {
            switch (this.glyphOrientation) {
                case 1: 
                case 2: {
                    return this.getRotationCharWidth(' ') * this.view.getSegment().count;
                }
            }
            return super.calculateWidth();
        }
        catch (BadLocationException e1) {
            return 1.0f;
        }
    }

    @Override
    public void paint(Graphics g, Shape a, int start, int length, int baseline) {
        try {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            int x = alloc.x;
            int y = alloc.y + baseline;
            Segment text = this.view.getSegment();
            if (this.glyphOrientation != 4) {
                this.drawTabbedText(text, x, y, g, start, length);
            } else {
                g.drawString(text.toString().substring(start, start + length), x, y);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private final int drawTabbedText(Segment s, int xStart, int y, Graphics gr, int startOffset, int length) {
        float x;
        float nextX = x = (float)xStart;
        char[] txt = s.array;
        int txtOffset = s.offset + startOffset;
        int n = s.offset + Math.max(startOffset + length, s.count);
        for (int i = txtOffset; i < n; ++i) {
            float width = 0.0f;
            if (this.charWidth != null) {
                int textPos = i - txtOffset + startOffset;
                width = this.charWidth[textPos + 1] - this.charWidth[textPos];
            } else {
                width = this.getFontMetrics().charWidth(txt[i]);
            }
            Graphics2D g = (Graphics2D)gr.create();
            switch (this.glyphOrientation) {
                case 1: {
                    g.rotate(NINETY_DEGREES, x, y);
                    g.translate(-(width + (float)this.getAscent() - (float)this.getDescent()) / 2.0f, (double)(-this.getDescent()));
                    nextX += (float)this.getRotationCharWidth(txt[i]);
                    break;
                }
                case 2: {
                    g.rotate(-NINETY_DEGREES, x, y);
                    g.translate(((float)(this.getAscent() - this.getDescent()) - width) / 2.0f, (double)this.getAscent());
                    nextX += (float)this.getRotationCharWidth(txt[i]);
                    break;
                }
                case 3: {
                    g.rotate(ONE_EIGHTY_DEGREES, x, y);
                    g.translate(-width, (double)(this.getAscent() - this.getDescent()));
                    nextX += width;
                    break;
                }
                default: {
                    nextX += width;
                }
            }
            g.drawChars(txt, i, 1, Math.round(x), y);
            g.dispose();
            x = nextX;
        }
        return Math.round(x);
    }

    @Override
    protected void calculateCharOffsets(Segment text) {
        super.calculateCharOffsets(text);
        if (this.glyphOrientation <= 2) {
            this.charWidth = this.getCharOffsets();
            float[] charOffsets = new float[text.count + 1];
            charOffsets[0] = 0.0f;
            for (int i = 1; i <= text.count; ++i) {
                charOffsets[i] = charOffsets[i - 1] + (float)this.getRotationCharWidth(text.array[text.offset + i - 1]);
            }
            this.setCharOffsets(charOffsets);
        }
    }

    public int getGlyphOrientation() {
        return this.glyphOrientation;
    }

    @Override
    public ContentPainter copy(ContentView target) {
        return new RotationPainter(this.glyphOrientation, target);
    }
}

