/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.BMPDecoder;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.SuppressFBWarnings;

public class UrlBMPDecoder
extends BMPDecoder {
    private URL location;
    private InputStream input;
    private byte[] intArray = new byte[4];
    private byte[] rgb24Array = new byte[3];
    private byte[] shortArray = new byte[2];
    private byte[] byteArray = new byte[1];
    private int readLen;
    private long skipLen;

    public UrlBMPDecoder(URL location) {
        this.location = location;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The decoder for BMP images requires access to any ressource location. Content can only be interpreted as BMP or will be ignored.")
    public Image decodeImage(int suggestedWidth, int suggestedHeight) throws IOException {
        URLConnection connection = this.location.openConnection();
        connection.connect();
        this.input = connection.getInputStream();
        Image image = super.decodeImage(suggestedWidth, suggestedHeight);
        this.input.close();
        return image;
    }

    private void doRead(byte[] target) throws IOException {
        if (this.input == null) {
            throw new IOException("Socket not yet open.");
        }
        this.readLen = this.input.read(target, 0, target.length);
        if (this.readLen < target.length) {
            int localLen = this.input.read(target, this.readLen, target.length - this.readLen);
            while (localLen >= 0 && this.readLen < target.length) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.readLen += localLen;
                if (target.length <= this.readLen) continue;
                localLen = this.input.read(target, this.readLen, target.length - this.readLen);
            }
        }
        if (this.readLen < target.length) {
            throw new IOException("Premature end of image data.");
        }
    }

    @Override
    protected byte readByte() throws IOException {
        this.doRead(this.byteArray);
        return this.byteArray[0];
    }

    @Override
    protected int readInt() throws IOException {
        this.doRead(this.intArray);
        int result = (this.intArray[0] & 0xFF) + ((this.intArray[1] & 0xFF) << 8) + ((this.intArray[2] & 0xFF) << 16) + (this.intArray[3] << 24);
        return result;
    }

    @Override
    protected int readShort() throws IOException {
        this.doRead(this.shortArray);
        int result = (this.shortArray[0] & 0xFF) + (this.shortArray[1] << 8);
        return result;
    }

    @Override
    protected int readRGB24() throws IOException {
        this.doRead(this.rgb24Array);
        int result = 0xFF000000 | this.rgb24Array[0] & 0xFF | (this.rgb24Array[1] & 0xFF) << 8 | (this.rgb24Array[2] & 0xFF) << 16;
        return result;
    }

    @Override
    protected void skipBytes(int count) throws IOException {
        if (count == 0) {
            return;
        }
        this.skipLen = this.input.skip(count);
        if (this.skipLen < (long)count) {
            throw new IOException("Premature end of image data.");
        }
    }
}

