/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class URLUtils {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static URI encode(String url) {
        block4: {
            if (url != null) {
                String fragment = null;
                int index = url.indexOf(35);
                if (index >= 0 && index < url.length() - 1) {
                    fragment = url.substring(index + 1);
                    url = url.substring(0, index);
                }
                try {
                    return new URI(null, url, fragment);
                }
                catch (URISyntaxException e) {
                    if (!Logger.doesLog(4)) break block4;
                    Logger.debug(e.getMessage());
                }
            }
        }
        return null;
    }

    private static char[] charToHex(int c) {
        char[] values;
        if (c < 256) {
            values = new char[]{'0', '0'};
        } else if (c < 65536) {
            values = new char[]{'0', '0', '%', '0', '0'};
        } else {
            return new char[]{'0'};
        }
        int idx = values.length - 1;
        while (c != 0 && c != -1) {
            values[idx] = HEX[c & 0xF];
            c >>= 4;
            if (--idx != 2) continue;
            idx = 1;
        }
        return values;
    }

    private static String decode(String url) {
        block3: {
            if (url != null) {
                try {
                    return URLDecoder.decode(url, ENCODING_UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    if (!Logger.doesLog(1)) break block3;
                    Logger.error(e);
                }
            }
        }
        return url;
    }

    public static String safeEncode(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("\\\\")) {
            return url;
        }
        if (!url.equals(URLUtils.decode(url))) {
            return url;
        }
        URI uri = URLUtils.encode(url.replace('\\', '/'));
        if (uri != null) {
            return uri.toString();
        }
        return url;
    }

    public static URL safeEncode(URL url) {
        block5: {
            if (url == null) {
                return null;
            }
            String original = url.toString();
            String decoded = URLUtils.decode(original);
            if (original.indexOf(92) < 0 && !original.equals(decoded)) {
                return url;
            }
            URI uri = URLUtils.encode(original.replace('\\', '/'));
            if (uri != null && !original.equals(uri.toString())) {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    if (!Logger.doesLog(2)) break block5;
                    Logger.warning("Could not encode the URL '" + url + "'. This may lead to unresolved links or images!");
                }
            }
        }
        return url;
    }

    public static URI safeDecode(String url) {
        if (url == null) {
            return null;
        }
        url = URLUtils.decode(url);
        try {
            return new URI(null, url, null);
        }
        catch (URISyntaxException e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
            return null;
        }
    }

    public static String transcode(String attribute, String charsetName) throws UnsupportedEncodingException {
        if (attribute == null) {
            return null;
        }
        int len = attribute.length();
        StringBuilder b = new StringBuilder(attribute.length());
        for (int i = 0; i < len; ++i) {
            char ch = attribute.charAt(i);
            if (ch < ' ' || ch > '\u007f') {
                byte[] ba = String.valueOf(ch).getBytes(charsetName);
                for (int j = 0; j < ba.length; ++j) {
                    b.append("%");
                    b.append(URLUtils.charToHex(ba[j]));
                }
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }
}

