/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.net.MalformedURLException;
import java.net.URL;

public class UrlValue
extends HtmlAttribute
implements URLResolver.URLResolverContainer {
    static final UrlValue PARSER = new UrlValue();
    private URLResolver value;

    private UrlValue() {
    }

    public UrlValue(String value) {
        this.setString(value);
        this.value = new URLResolver(value);
    }

    public UrlValue(String value, URL baseURL) {
        this.setString(value);
        this.value = new URLResolver(value, baseURL);
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        return new UrlValue(value, doc.getBase());
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UrlValue)) {
            return false;
        }
        UrlValue otherObj = (UrlValue)obj;
        return this.value != null ? this.value.equals(otherObj.value) : otherObj.value != null;
    }

    public URL getAbsoluteURL() {
        try {
            return this.value != null ? this.value.getFullURL() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URLResolver getResolver() {
        return this.value;
    }

    @Override
    public void setResolver(URLResolver resolver) {
        this.value = resolver;
        boolean isNone = resolver.getOriginalURI() == null;
        this.setString(isNone ? "none" : resolver.getOriginalURI());
    }
}

