/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.utils.Logger;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransformValue
extends SingleAttributeValue {
    static final TransformValue PARSER = new TransformValue();
    private static final Pattern PARSE_PATTERN = Pattern.compile("(\\w+)\\((.*?)\\)", 2);
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private AffineTransform transform;
    private AffineTransform inverse;
    private boolean isNone = true;

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        TransformValue br = new TransformValue();
        String lower = valueStr.toLowerCase().trim();
        br.setString(valueStr);
        if ("inherit".equals(lower)) {
            return AttributeValue.INHERIT;
        }
        if ("none".equals(lower)) {
            return br;
        }
        Matcher m = PARSE_PATTERN.matcher(lower);
        while (m.find()) {
            double[] params;
            String function = m.group(1);
            try {
                boolean isRotate;
                boolean bl = isRotate = function.startsWith("rotate") || function.startsWith("skew");
                if (m.group(2).indexOf(44) > 0) {
                    String[] parts = m.group(2).trim().split("\\s*,\\s*");
                    params = new double[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        params[i] = this.parseNumber(parts[i], isRotate);
                    }
                } else {
                    params = new double[]{this.parseNumber(m.group(2).trim(), isRotate)};
                }
            }
            catch (Exception e) {
                if (!Logger.doesLog(2)) continue;
                Logger.error(e);
                continue;
            }
            br.isNone = false;
            if (br.transform == null) {
                br.transform = new AffineTransform();
            }
            if ("scale".equals(function) && params.length >= 1) {
                br.transform.scale(params[0], params.length > 1 ? params[1] : params[0]);
                continue;
            }
            if ("scalex".equals(function) && params.length >= 1) {
                br.transform.scale(params[0], 1.0);
                continue;
            }
            if ("scaley".equals(function) && params.length >= 1) {
                br.transform.scale(1.0, params[0]);
                continue;
            }
            if ("translate".equals(function) && params.length >= 1) {
                br.transform.translate(params[0], params.length > 1 ? params[1] : 0.0);
                continue;
            }
            if ("translatex".equals(function) && params.length >= 1) {
                br.transform.translate(params[0], 1.0);
                continue;
            }
            if ("translatey".equals(function) && params.length >= 1) {
                br.transform.translate(1.0, params[0]);
                continue;
            }
            if ("skew".equals(function) && params.length >= 1) {
                br.transform.shear(Math.tan(params[0]), Math.tan(params.length > 1 ? params[1] : 0.0));
                continue;
            }
            if ("skewx".equals(function) && params.length >= 1) {
                br.transform.shear(Math.tan(params[0]), 0.0);
                continue;
            }
            if ("skewy".equals(function) && params.length >= 1) {
                br.transform.shear(0.0, Math.tan(params[0]));
                continue;
            }
            if ("rotate".equals(function) && params.length >= 1) {
                br.transform.rotate(params[0]);
                continue;
            }
            if (!"matrix".equals(function) || params.length < 6) continue;
            br.transform.setTransform(params[0], params[1], params[2], params[3], params[4], params[5]);
        }
        if (br.transform == null) {
            br.isNone = true;
            br.inverse = null;
            return br;
        }
        try {
            br.inverse = br.transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            br.inverse = new AffineTransform();
            Logger.warning(e.getMessage() + " for transform '" + valueStr + "'");
        }
        if (br.transform.isIdentity()) {
            br.isNone = true;
            br.transform = null;
            br.inverse = null;
        }
        return br;
    }

    private double parseNumber(String data, boolean isAngle) throws NumberFormatException {
        if (isAngle) {
            double factor = 1.0;
            if ((data = data.toLowerCase()).endsWith("deg")) {
                factor = Math.PI / 180;
                data = data.substring(0, data.length() - 3);
            } else if (data.endsWith("grad")) {
                factor = 0.015707963267948967;
                data = data.substring(0, data.length() - 4);
            } else if (data.endsWith("rad")) {
                factor = 1.0;
                data = data.substring(0, data.length() - 3);
            } else if (data.endsWith("turn")) {
                factor = Math.PI * 2;
                data = data.substring(0, data.length() - 4);
            }
            return Double.parseDouble(data) * factor;
        }
        LengthUnit length = (LengthUnit)LengthUnit.PARSER.parseCssValue(data, false);
        if (length != null) {
            return length.calculateValue(0.0f, null);
        }
        throw new NumberFormatException("'" + data + "' is not a valid transform parameter");
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public AffineTransform getTransform(boolean inverse) {
        if (this.isNone) {
            return IDENTITY_TRANSFORM;
        }
        return inverse ? this.inverse : this.transform;
    }

    public boolean isNone() {
        return this.isNone;
    }
}

