/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import javax.swing.JTextPane;

public class JTimeoutTextPane
extends JTextPane {
    private int timeout;

    public JTimeoutTextPane(int timeout) {
        this.timeout = timeout;
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout has to be zero or positive");
        }
    }

    @Override
    public void setPage(URL page) throws IOException {
        String path = page.getPath();
        path = path + (page.getQuery() != null ? "?" + page.getQuery() : "");
        path = path + (page.getRef() != null ? "#" + page.getRef() : "");
        URL loader = new URL(page, path, new TimeoutHandler(this.timeout));
        super.setPage(loader);
    }

    @Override
    public void setPage(String url) throws IOException {
        URL loader = new URL(null, url, new TimeoutHandler(this.timeout));
        super.setPage(loader);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout has to be zero or positive");
        }
    }

    private static class TimeoutHandler
    extends URLStreamHandler {
        private final int timeout;

        public TimeoutHandler(int timeout) {
            this.timeout = timeout;
        }

        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Wrapper for a normal URL connection which sets a connection timeout upon connect.")
        protected URLConnection openConnection(URL u) throws IOException {
            URLConnection con = new URL(u.toString()).openConnection();
            con.setReadTimeout(this.timeout);
            if (con instanceof HttpURLConnection) {
                return new HttpConnectionWrapper((HttpURLConnection)con, u);
            }
            return con;
        }
    }

    private static class HttpConnectionWrapper
    extends HttpURLConnection {
        private final HttpURLConnection con;
        private final URL origUrl;

        public HttpConnectionWrapper(HttpURLConnection con, URL origUrl) {
            super(origUrl);
            this.con = con;
            this.origUrl = origUrl;
        }

        @Override
        public void disconnect() {
            this.con.disconnect();
        }

        @Override
        public boolean usingProxy() {
            return this.con.usingProxy();
        }

        @Override
        public void connect() throws IOException {
            this.con.connect();
        }

        @Override
        public void addRequestProperty(String key, String value) {
            this.con.addRequestProperty(key, value);
        }

        @Override
        public boolean getAllowUserInteraction() {
            return this.con.getAllowUserInteraction();
        }

        @Override
        public int getConnectTimeout() {
            return this.con.getConnectTimeout();
        }

        @Override
        public Object getContent() throws IOException {
            return this.con.getContent();
        }

        public Object getContent(Class[] classes) throws IOException {
            return this.con.getContent(classes);
        }

        @Override
        public String getContentEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public int getContentLength() {
            return this.con.getContentLength();
        }

        @Override
        public String getContentType() {
            return this.con.getContentType();
        }

        @Override
        public long getDate() {
            return this.con.getDate();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return this.con.getDefaultUseCaches();
        }

        @Override
        public boolean getDoInput() {
            return this.con.getDoInput();
        }

        @Override
        public boolean getDoOutput() {
            return this.con.getDoOutput();
        }

        @Override
        public InputStream getErrorStream() {
            return this.con.getErrorStream();
        }

        @Override
        public long getExpiration() {
            return this.con.getExpiration();
        }

        @Override
        public String getHeaderField(int n) {
            return this.con.getHeaderField(n);
        }

        @Override
        public String getHeaderField(String name) {
            return this.con.getHeaderField(name);
        }

        @Override
        public long getHeaderFieldDate(String name, long Default) {
            return this.con.getHeaderFieldDate(name, Default);
        }

        @Override
        public int getHeaderFieldInt(String name, int Default) {
            return this.con.getHeaderFieldInt(name, Default);
        }

        @Override
        public String getHeaderFieldKey(int n) {
            return this.con.getHeaderFieldKey(n);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.con.getHeaderFields();
        }

        @Override
        public long getIfModifiedSince() {
            return this.con.getIfModifiedSince();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.con.getInputStream();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return this.con.getInstanceFollowRedirects();
        }

        @Override
        public long getLastModified() {
            return this.con.getLastModified();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.con.getOutputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.con.getPermission();
        }

        @Override
        public int getReadTimeout() {
            return this.con.getReadTimeout();
        }

        @Override
        public String getRequestMethod() {
            return this.con.getRequestMethod();
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return this.con.getRequestProperties();
        }

        @Override
        public String getRequestProperty(String key) {
            return this.con.getRequestProperty(key);
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.con.getResponseCode();
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.con.getResponseMessage();
        }

        @Override
        public URL getURL() {
            return this.origUrl;
        }

        @Override
        public boolean getUseCaches() {
            return this.con.getUseCaches();
        }
    }
}

