/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.SingleAttributeValue;

public class BackgroundSize
extends SingleAttributeValue {
    private LengthUnit percentX = (LengthUnit)LengthUnit.PARSER.parseCssValue("auto", false);
    private LengthUnit percentY = (LengthUnit)LengthUnit.PARSER.parseCssValue("auto", false);
    private boolean isContain = false;
    private boolean isCover = false;
    static final BackgroundSize PARSER = new BackgroundSize();

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BackgroundSize) {
            BackgroundSize other = (BackgroundSize)obj;
            if (other.isImportant() != this.isImportant()) {
                return false;
            }
            return this.percentX.equals(other.getPercentX()) && this.percentY.equals(other.getPercentY()) && this.isContain == other.isContain && this.isCover == other.isCover;
        }
        return false;
    }

    public LengthUnit getPercentX() {
        return this.percentX;
    }

    public LengthUnit getPercentY() {
        return this.percentY;
    }

    public boolean isAuto() {
        return this.percentX.isAuto() && this.percentY.isAuto() && !this.isContain && !this.isCover;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        String value = valueStr.toLowerCase().trim();
        if ("inherit".equals(value)) {
            return AttributeValue.INHERIT;
        }
        BackgroundSize size = new BackgroundSize();
        size.setImportant(important);
        size.setString(valueStr);
        String[] parts = value.split("[\\s\\t]+");
        if (parts == null || parts.length == 0) {
            return size;
        }
        if ("contain".equalsIgnoreCase(parts[0])) {
            size.isContain = true;
            return size;
        }
        if ("cover".equalsIgnoreCase(parts[0])) {
            size.isCover = true;
            return size;
        }
        if (parts.length == 1) {
            size.percentX = new LengthUnit(parts[0]);
            return size;
        }
        size.percentX = new LengthUnit(parts[0]);
        size.percentY = new LengthUnit(parts[1]);
        return size;
    }

    public boolean isCover() {
        return this.isCover;
    }

    public boolean isContain() {
        return this.isContain;
    }

    @Override
    public String toString() {
        if (this.isContain) {
            return "contain";
        }
        if (this.isCover) {
            return "cover";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.percentX.toString());
        if (!this.percentY.isAuto()) {
            b.append(' ').append(this.percentY.toString());
        }
        return b.toString();
    }
}

