/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import com.inet.html.image.ImageFetcher;
import com.inet.html.utils.InetStreamHandler;
import com.inet.html.utils.Logger;
import com.inet.protocol.data.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Hashtable;
import javax.annotation.SuppressFBWarnings;

public class URLResolver {
    private String target;
    private URL baseURL;
    private String contentType;

    public URLResolver(String target) {
        this.target = target;
    }

    public URLResolver(String target, URL baseURL) {
        this.target = target;
        this.baseURL = baseURL;
    }

    public URLResolver(URL target) {
        this.target = target.toString();
    }

    public void setBase(URL baseURL) {
        this.baseURL = baseURL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof URLResolver)) {
            return false;
        }
        URLResolver otherUri = (URLResolver)obj;
        if (this.baseURL != null && otherUri.baseURL == null || this.baseURL == null && otherUri.baseURL != null) {
            return false;
        }
        if (this.baseURL != null && !this.baseURL.equals(otherUri.baseURL)) {
            return false;
        }
        if (this.target == null != (otherUri.target == null)) {
            return false;
        }
        return this.target == null || this.target.toLowerCase().equals(otherUri.target.toLowerCase());
    }

    public URL getFullURL() throws MalformedURLException {
        if (this.baseURL != null) {
            return new URL(this.baseURL, this.target);
        }
        return new URL(this.target);
    }

    public String getOriginalURI() {
        return this.target;
    }

    public InputStream getContent(int timeout) throws MalformedURLException, IOException {
        URL url = this.getTarget(this.target, this.baseURL);
        if (url != null && this.baseURL != null) {
            url = this.getURLwithReferrer(url, this.baseURL);
        }
        URLConnection connection = ImageFetcher.openConnection(url, timeout);
        this.contentType = connection.getContentType();
        return ImageFetcher.openStream(connection);
    }

    public String getContentType() {
        return this.contentType;
    }

    private URL getURLwithReferrer(URL url, URL base) {
        if (url == null) {
            return null;
        }
        InetStreamHandler urlHandler = new InetStreamHandler(url);
        urlHandler.setReferrer(base);
        String path = url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : "") + (url.getRef() != null ? "#" + url.getRef() : "");
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), path, urlHandler);
        }
        catch (MalformedURLException e) {
            return url;
        }
        catch (SecurityException e) {
            if (Logger.doesLog(4)) {
                Logger.debug("Could not attach referrer due to security restriction. URL was '" + url + "'");
            }
            return url;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The SRC of an image can be a local file-URL thus the ImageCache need to check this location for beeing an image.")
    private URL getTarget(String identifier, URL base) throws IOException {
        URL url;
        block18: {
            block17: {
                if (base == null && !identifier.contains(":")) {
                    Logger.warning("Missing base URL for image '" + identifier + "'. This image may not load.");
                }
                try {
                    url = new URL(base, identifier);
                }
                catch (MalformedURLException e1) {
                    if (identifier.startsWith("data:")) {
                        try {
                            Field field = URL.class.getDeclaredField("handlers");
                            field.setAccessible(true);
                            Hashtable handlers = (Hashtable)field.get(null);
                            handlers.put("data", new Handler());
                            url = new URL(identifier);
                        }
                        catch (Throwable e2) {
                            url = null;
                        }
                    } else {
                        try {
                            File testFile = new File(URLDecoder.decode(identifier, "UTF-8"));
                            if (testFile.exists()) {
                                try {
                                    url = testFile.toURI().toURL();
                                }
                                catch (MalformedURLException e) {
                                    url = null;
                                }
                            } else {
                                url = null;
                            }
                        }
                        catch (Exception e2) {
                            url = null;
                        }
                    }
                    if (url != null) break block17;
                    if (Logger.doesLog(2)) {
                        Logger.error(e1);
                    }
                    throw e1;
                }
            }
            try {
                url.toURI();
            }
            catch (URISyntaxException e) {
                if (!Logger.doesLog(2)) break block18;
                Logger.error(e.getMessage());
            }
        }
        if (!this.isAllowedToConnectTo(url)) {
            return null;
        }
        return url;
    }

    private boolean isAllowedToConnectTo(URL url) {
        if (url != null && url.getHost() != null && url.getHost().length() > 0 && "file".equals(url.getProtocol())) {
            return false;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (url != null && securityManager != null) {
            String host = url.getHost();
            int port = url.getPort();
            if (host != null) {
                try {
                    securityManager.checkConnect(host, port);
                }
                catch (SecurityException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static interface URLResolverContainer {
        public URLResolver getResolver();

        public void setResolver(URLResolver var1);
    }
}

