/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.actions.search.ISearchDialog;
import com.inet.html.actions.search.SearchControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultSearchDialog
implements ISearchDialog,
ActionListener {
    private JTextField text;
    private JRadioButton forward;
    private JRadioButton backward;
    private JCheckBox caseSensitive;
    private JButton search;
    private JButton close;
    private JLabel status;
    private static String lastSearch = "";
    private static boolean lastCS = false;
    private static boolean lastForward = true;
    private Point lastPosition = null;
    private SearchControl control;
    private JDialog dialog;
    private final JEditorPane editor;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultSearchDialog.this.text.requestFocus();
                    int length = DefaultSearchDialog.this.text.getText().length();
                    if (length > 0) {
                        DefaultSearchDialog.this.fireSearchTextChanged();
                        DefaultSearchDialog.this.text.setSelectionStart(0);
                        DefaultSearchDialog.this.text.setSelectionEnd(length);
                    }
                }
            });
        }
    };

    public DefaultSearchDialog(JEditorPane editor) {
        this.editor = editor;
    }

    private void initGui() {
        if (this.dialog != null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this.editor);
        this.dialog = window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog((Frame)window);
        this.dialog.setDefaultCloseOperation(2);
        Container content = this.dialog.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        content.setLayout(layout);
        String suchen = HtmlEditorUtils.getTranslation("search.title");
        this.dialog.setTitle(suchen);
        Insets insets = new Insets(2, 2, 2, 2);
        this.text = new JTextField(lastSearch, 20);
        JLabel label = new JLabel(suchen + ":");
        label.setLabelFor(this.text);
        content.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 8, 3, 2), 0, 0));
        content.add((Component)this.text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 2), 0, 0));
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }
        });
        this.text.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        this.forward = new JRadioButton(HtmlEditorUtils.getTranslation("search.forward"));
        this.forward.setSelected(lastForward);
        content.add((Component)this.forward, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        group.add(this.forward);
        this.backward = new JRadioButton(HtmlEditorUtils.getTranslation("search.backward"));
        content.add((Component)this.backward, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        group.add(this.backward);
        this.caseSensitive = new JCheckBox(HtmlEditorUtils.getTranslation("search.caseSensitive"));
        content.add((Component)this.caseSensitive, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.caseSensitive.addActionListener(this);
        this.caseSensitive.setSelected(lastCS);
        this.search = new JButton(HtmlEditorUtils.getTranslation("search.next"));
        this.dialog.getRootPane().setDefaultButton(this.search);
        this.search.addActionListener(this);
        this.close = new JButton(HtmlEditorUtils.getTranslation("search.close"));
        this.close.addActionListener(this);
        this.dialog.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel pnlButtons = new JPanel(new FlowLayout(2));
        pnlButtons.add(this.search);
        pnlButtons.add(this.close);
        Color color = new Color(pnlButtons.getBackground().getRGB());
        pnlButtons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color.brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, color.darker())));
        content.add((Component)pnlButtons, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.status = new JLabel(" ");
        content.add((Component)this.status, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        this.dialog.pack();
        this.dialog.setMinimumSize(this.dialog.getSize());
        this.dialog.setPreferredSize(this.dialog.getSize());
        if (this.lastPosition == null) {
            Dimension dSize = this.dialog.getSize();
            Rectangle wPos = window.getBounds();
            this.lastPosition = new Point(wPos.x + wPos.width / 2 - dSize.width / 2, wPos.y + wPos.height / 2 - dSize.height / 2);
        }
        this.dialog.setLocation(this.lastPosition);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (DefaultSearchDialog.this.dialog != null) {
                    DefaultSearchDialog.this.close();
                }
            }
        });
        this.editor.addPropertyChangeListener("document", this.listener);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public String getSearchString() {
        return this.text != null ? this.text.getText() : lastSearch;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive != null ? this.caseSensitive.isSelected() : lastCS;
    }

    @Override
    public boolean isForward() {
        return this.forward != null ? this.forward.isSelected() : lastForward;
    }

    @Override
    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    @Override
    public void requestShow(boolean clear) {
        this.initGui();
        if (clear) {
            this.clear();
        }
        this.dialog.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSearchDialog.this.text.requestFocus();
                int length = DefaultSearchDialog.this.text.getText().length();
                if (length > 0) {
                    DefaultSearchDialog.this.fireSearchTextChanged();
                    DefaultSearchDialog.this.text.setSelectionStart(0);
                    DefaultSearchDialog.this.text.setSelectionEnd(length);
                }
            }
        });
    }

    @Override
    public void setController(SearchControl control) {
        this.control = control;
    }

    private void fireSearchTextChanged() {
        if (this.isForward()) {
            this.editor.setSelectionEnd(this.editor.getSelectionStart());
        } else {
            this.editor.setSelectionStart(this.editor.getSelectionEnd());
        }
        this.control.doSearch(this.isForward(), false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if ((source == this.close || source == this.dialog.getRootPane()) && this.dialog != null) {
            this.close();
        } else if (source == this.caseSensitive) {
            this.control.doSearch(this.isForward(), false);
        }
        if (source == this.search || source == this.text) {
            this.control.doSearch(this.isForward(), true);
        }
    }

    @Override
    public void notifyMatches(int matches) {
        if (this.text == null) {
            return;
        }
        if (this.text.getText().length() == 0) {
            this.status.setText("");
        } else if (matches > 0) {
            this.status.setText(HtmlEditorUtils.getTranslation("search.matches") + ": " + matches);
        } else {
            this.status.setText(HtmlEditorUtils.getTranslation("search.noMatches"));
        }
    }

    @Override
    public void clear() {
        if (this.text != null) {
            this.text.setText("");
            this.status.setText("");
            this.forward.setSelected(true);
        }
    }

    @Override
    public void close() {
        this.editor.removePropertyChangeListener("document", this.listener);
        lastSearch = this.getSearchString();
        lastForward = this.isForward();
        lastCS = this.isCaseSensitive();
        this.control.clearHighlights();
        this.dialog.setVisible(false);
        this.dialog = null;
        this.text = null;
        this.backward = null;
        this.caseSensitive = null;
        this.close = null;
        this.forward = null;
        this.search = null;
        this.status = null;
    }
}

