/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.TextDecoration;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class UnderlineAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;

    public UnderlineAction() {
        super("font-underline");
    }

    @Override
    public Object getValue(String key) {
        if (key == "ShortDescription") {
            return InetHtmlAction.getTranslation("underline");
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane editor = this.getHtmlEditor(e);
        if (editor != null && editor.getDocument() instanceof InetHtmlDocument) {
            Document doc = editor.getDocument();
            Caret c = editor.getCaret();
            if (c.getDot() - c.getMark() != 0) {
                Element paragraph;
                int pos = c.getMark();
                if (c.getDot() < c.getMark()) {
                    --pos;
                }
                if ((paragraph = ((InetHtmlDocument)doc).getParagraphElement(pos)).getEndOffset() - 1 == pos) {
                    --pos;
                }
                Element characterElement = ((InetHtmlDocument)doc).getCharacterElement(pos);
                boolean underline = CSS.isUnderline(characterElement);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                CSS.setTextDecoration(sas, underline ? 0 : 1);
                int start = Math.min(c.getDot(), c.getMark());
                int end = Math.max(c.getDot(), c.getMark());
                ((InetHtmlDocument)doc).setCharacterAttributes(start, end - start, sas, false);
            }
            if (editor instanceof JTextPane) {
                MutableAttributeSet atts = ((JTextPane)editor).getInputAttributes();
                Object value = atts.getAttribute((Object)CSS.Attribute.TEXT_DECORATION);
                boolean useUnderline = value == null || value instanceof TextDecoration && ((TextDecoration)value).getDecoration() == 0;
                CSS.setTextDecoration(atts, useUnderline ? 1 : 0);
                this.updateCaretListeners(editor);
            }
        }
    }
}

