/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.annotations.PublicApi;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.PainterFactory;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.utils.CSSRules;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.BulletView;
import com.inet.html.views.ContentView;
import com.inet.html.views.ControlView;
import com.inet.html.views.HRuleView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ImageView;
import com.inet.html.views.InlineView;
import com.inet.html.views.InsertedContentView;
import com.inet.html.views.ObjectView;
import com.inet.html.views.TableView;
import com.inet.html.views.VariableSpaceView;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

@PublicApi
public class InetHtmlFactory
implements ViewFactory {
    public static final String END_BLOCK_MARKER = "CR";
    private final PainterFactory factory;
    private InetHtmlFontFactory fontFactory;
    private boolean useTextAntiAlias = true;
    private boolean autoScaleImages;

    public InetHtmlFactory() {
        this.factory = new DefaultPainterFactory();
        this.fontFactory = null;
    }

    public InetHtmlFactory(PainterFactory painterFactory, InetHtmlFontFactory fontFactory) {
        this.factory = painterFactory == null ? new DefaultPainterFactory() : painterFactory;
        this.fontFactory = fontFactory != null ? fontFactory : null;
    }

    public void setUseTextAntiAlias(boolean useTextAntiAlias) {
        this.useTextAntiAlias = useTextAntiAlias;
    }

    public void setFontFactory(InetHtmlFontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public void setAutoScaleImages(boolean enable) {
        this.autoScaleImages = enable;
    }

    @Override
    public View create(Element elem) {
        Position positionValue;
        AttributeSet attrs = elem.getAttributes();
        Object tag = attrs.getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.SCRIPT || tag == HTML.Tag.META) {
            return null;
        }
        byte display = 2;
        byte floating = 0;
        byte position = 0;
        if (tag == HTML.Tag.CONTENT) {
            ContentView createdView;
            if (elem.getAttributes().isDefined(END_BLOCK_MARKER)) {
                createdView = new VariableSpaceView(elem, this.factory.createInstance());
                createdView.setBreakable(true);
            } else {
                createdView = new ContentView(elem, this.factory.createInstance());
            }
            createdView.factoryPreset(floating, display, position);
            return createdView;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(elem, AttributeFinder.DISPLAY);
        if (displayValue != null) {
            display = displayValue.getDisplay();
        }
        if (display == 1) {
            return null;
        }
        FloatValue floatValue = StyleResolver.getAttributeValue(elem, AttributeFinder.FLOAT);
        if (floatValue != null) {
            floating = floatValue.getFloat();
        }
        if (floating == 0 && (display == 8 || tag == HTML.Tag.IMG) && (floatValue = StyleResolver.getAttributeValue(elem, AttributeFinder.FLOAT_ALIGN)) != null) {
            floating = floatValue.getFloat();
        }
        if ((positionValue = StyleResolver.getAttributeValue(elem, AttributeFinder.POSITION)) != null) {
            position = positionValue.getPosition();
        }
        if (tag == HTML.Tag.IMG && floating == 1) {
            display = 3;
        }
        if (!CSSRules.isInFlow(position, floating)) {
            display = CSSRules.convertDisplayOnNonFlow(display);
        }
        BoxView createdView = null;
        if (tag == HTML.Tag.INPUT || tag == HTML.Tag.SELECT || tag == HTML.Tag.OPTION || tag == HTML.Tag.TEXTAREA) {
            createdView = this.createControl(elem);
        } else {
            if (display == 2 && elem.getElementCount() > 0) {
                return new InlineView(elem);
            }
            if (tag == HTML.Tag.OBJECT || tag == HTML.Tag.APPLET) {
                createdView = this.createObject(elem);
            } else if (tag == HTML.Tag.BR) {
                VariableSpaceView br = new VariableSpaceView(elem, this.factory.createInstance());
                br.setFixed(true);
                br.setWidth(1);
                createdView = br;
            } else if (tag == HTML.Tag.CONTENT) {
                createdView = new ContentView(elem, this.factory.createInstance());
            } else if (tag == HTML.Tag.TABLE || display == 8) {
                createdView = this.createTable(elem);
            } else if (tag == HTML.Tag.HR) {
                createdView = this.createHRule(elem);
            } else if (tag == HTML.Tag.IMG) {
                createdView = this.createImage(elem);
            } else {
                if (tag == HTML.Tag.SCRIPT || tag == HTML.Tag.HEAD) {
                    return null;
                }
                if (tag == HTML.Tag.HTML && elem.getParentElement() == null) {
                    HtmlRootView root = new HtmlRootView(elem, this.factory.createInstance(), this.fontFactory);
                    root.getRenderContext().setTextAntiAlias(this.useTextAntiAlias);
                    createdView = root;
                } else {
                    createdView = this.createBlock(elem);
                }
            }
        }
        createdView.factoryPreset(floating, display, position);
        return createdView;
    }

    public BoxView createControl(Element elem) {
        return new ControlView(elem, this.factory.createInstance());
    }

    public BoxView createObject(Element elem) {
        ObjectView view = new ObjectView(elem);
        BoxView createdView = view.canLoad() ? view : this.createBlock(elem);
        return createdView;
    }

    public BoxView createBlock(Element elem) {
        return new BlockView(elem, this.factory.createInstance());
    }

    public BoxView createTable(Element elem) {
        return new TableView(elem, this.factory.createInstance());
    }

    public BoxView createHRule(Element elem) {
        return new HRuleView(elem, this.factory.createInstance());
    }

    public VariableSpaceView createSpace(Element elem, boolean isBreakChar) {
        return new VariableSpaceView(elem, isBreakChar, this.factory.createInstance());
    }

    public VariableSpaceView createSpace(Element elem, int paintMode) {
        return new VariableSpaceView(elem, paintMode, this.factory.createInstance());
    }

    public ImageView createImage(Element elem) {
        ImageView img = new ImageView(elem, this.factory.createInstance());
        img.setAutoScaleMode(this.autoScaleImages);
        return img;
    }

    public BoxView create(Element elem, int displayValue) {
        switch (displayValue) {
            case 8: {
                return this.createTable(elem);
            }
            case 3: {
                return this.createBlock(elem);
            }
        }
        return (BoxView)this.create(elem);
    }

    public BoxView createListItem(BoxView view, int numericValue) {
        UriValue uri = AttributeFinder.LIST_STYLE_IMAGE.getAttributeValue(view);
        if (uri != null) {
            ImageView insertView = this.createImage(view.getElement());
            insertView.predictSource(uri);
            insertView.setMarker(true);
            insertView.setListItemFallback(this.createNonImageListItem(view, numericValue));
            return insertView;
        }
        return this.createNonImageListItem(view, numericValue);
    }

    private BoxView createNonImageListItem(BoxView view, int numericValue) {
        int type = AttributeFinder.LIST_STYLE_TYPE.getAttributeValue(view).getType();
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return new BulletView(view.getElement(), type, this.factory.createInstance());
            }
        }
        InsertedContentView insertView = new InsertedContentView(view.getElement(), this.factory.createInstance());
        insertView.setNewContent(InetHtmlFactory.getListValue(numericValue, type));
        insertView.setMarker(true);
        return insertView;
    }

    private static final String getListValue(int number, int listType) {
        switch (listType) {
            case 0: {
                return "\u2022";
            }
            case 1: {
                return "\u25e6";
            }
            case 2: {
                return "\u25aa";
            }
            case 15: {
                return InetHtmlFactory.getLatinListValue(number, true);
            }
            case 16: {
                return InetHtmlFactory.getLatinListValue(number, false);
            }
            case 6: {
                if (number <= 0) {
                    return number + ".";
                }
                return InetHtmlFactory.calculateRomanNumerals(number) + ".";
            }
            case 5: {
                if (number <= 0) {
                    return number + ".";
                }
                return InetHtmlFactory.calculateRomanNumerals(number).toLowerCase() + ".";
            }
        }
        return number + ".";
    }

    private static String getLatinListValue(int number, boolean lowerCase) {
        int offset = lowerCase ? 97 : 65;
        String result = "";
        if (number <= 0) {
            return number + ".";
        }
        result = (char)(--number % 26 + offset) + result;
        number /= 26;
        while (number > 0) {
            result = (char)((number - 1) % 26 + offset) + result;
            number /= 26;
        }
        return result + ".";
    }

    private static final String calculateRomanNumerals(int number) {
        String wh = "IVXLCDM";
        String str = "";
        int divisor = 1000;
        if (number < 1 || number > 4999) {
            return "0";
        }
        if (number > 3999) {
            str = str + wh.charAt(6);
            number -= 1000;
        }
        for (int k = 3; k >= 0; --k) {
            int i = number / divisor;
            number %= divisor;
            switch (i) {
                case 0: {
                    break;
                }
                case 5: {
                    str = str + wh.charAt(2 * k + 1);
                    break;
                }
                case 9: {
                    str = str + wh.charAt(2 * k);
                    str = str + wh.charAt(2 * k + 2);
                    break;
                }
                case 4: {
                    str = str + wh.charAt(2 * k);
                    str = str + wh.charAt(2 * k + 1);
                    break;
                }
                default: {
                    if (i > 5) {
                        str = str + wh.charAt(2 * k + 1);
                        i -= 5;
                    }
                    for (int j = 0; j < i; ++j) {
                        str = str + wh.charAt(2 * k);
                    }
                }
            }
            divisor /= 10;
        }
        return str;
    }

    private class DefaultPainterFactory
    implements PainterFactory {
        private DefaultPainterFactory() {
        }

        @Override
        public ViewPainter createInstance() {
            return null;
        }
    }

    public static class DefaultFontFactory
    implements InetHtmlFontFactory {
        @Override
        public Font getFont(String name, int style, int size, String text) {
            return new Font(name, style, size);
        }

        @Override
        public Font getFont(String name, int style, float size, String text) {
            Font font = new Font(name, style, (int)size);
            if (size != (float)((int)size)) {
                font = font.deriveFont(size);
            }
            return font;
        }

        @Override
        public boolean requiresText() {
            return false;
        }
    }
}

