/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.utils.Logger;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;

public class HtmlEditorUtils {
    private static final Map<String, ImageIcon> IMAGE_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static String getTranslation(String key) {
        block2: {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("com.inet.editor.i18n.Resources");
                key = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                if (!Logger.doesLog(2)) break block2;
                Logger.warning("No lokalization for: " + key + " = " + key);
            }
        }
        return key;
    }

    static ImageIcon getResourceImage(String name) {
        ImageIcon imic = null;
        if (IMAGE_CACHE != null) {
            imic = IMAGE_CACHE.get(name);
        }
        if (imic == null) {
            try {
                URL url = HtmlEditorUtils.class.getResource("images/" + name);
                if (url != null) {
                    imic = new ImageIcon(url);
                    IMAGE_CACHE.put(name, imic);
                }
            }
            catch (Throwable e) {
                Logger.error(e);
            }
        }
        return imic;
    }

    static void printStackTrace(Exception ex) {
        Logger.error(ex);
    }
}

