/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ZIndexValue;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.Layout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

public class StackManager {
    public static final byte CLEAR_NONE = 0;
    public static final byte CLEAR_LEFT = 1;
    public static final byte CLEAR_RIGHT = 2;
    public static final byte CLEAR_BOTH = 3;
    private static final int NO_MORE_FLOATS_BELOW = 2146483647;
    private static final Integer AUTO_POSITION = new Integer(Integer.MIN_VALUE);
    private static final Insets IGNORE_MARGIN = new Insets(0, 0, 0, 0);
    private static final Iterator<PositionInfo> EMPTY_ITERATOR = new EmptyIterator();
    public static final int MODE_NEGATIVE = 0;
    public static final int MODE_FLOATING = 1;
    public static final int MODE_NEUTRAL = 2;
    public static final int MODE_POSITIVE = 3;
    private static final int MODE_ALL = 4;
    public static final int MODE_ALL_NON_NEGATIVE = 5;
    private BlockView root;
    private List<PositionInfo> floated;
    private SortedMap<Integer, List<PositionInfo>> positionedNegative;
    private List<PositionInfo> positionedNeutral;
    private SortedMap<Integer, List<PositionInfo>> positionedPositive;
    private List<PositionInfo> recentFloats;
    private Rectangle spanNegative = new Rectangle();
    private Rectangle spanPositive = new Rectangle();
    private Rectangle spanNeutral = new Rectangle();
    private Rectangle spanFloated = new Rectangle();
    private boolean hasObjects = false;

    public StackManager(BlockView root) {
        this.root = root;
    }

    public Point getPositionInfo(BoxView child) {
        if (!this.hasViews()) {
            return null;
        }
        if (this.floated != null) {
            for (PositionInfo fi : this.floated) {
                if (fi.view != child) continue;
                Point pi = new Point(fi.x, fi.y);
                return pi;
            }
        }
        PositionIterator i = new PositionIterator(4, true);
        while (i.hasNext()) {
            PositionInfo next = i.next();
            if (next.view != child) continue;
            return next.getLocation();
        }
        return null;
    }

    public FloatChange addView(BoxView box, int x, int y) {
        this.hasObjects = true;
        if (box.isFloating()) {
            BoxView parent = (BoxView)box.getParent();
            Object tag = parent.getTag();
            PositionInfo info = new PositionInfo(box, box.getFloat() == 3);
            if (tag == HTML.Tag.P || tag == HTML.Tag.PRE) {
                if (this.recentFloats == null) {
                    this.recentFloats = new ArrayList<PositionInfo>();
                }
                this.recentFloats.add(info);
            } else if (this.floatView(y, info, x)) {
                return new FloatChange(info.typeLeft, info.width);
            }
        } else {
            PositionInfo pos = new PositionInfo(box);
            pos.y = y;
            pos.x = x;
            pos.layouted = !box.isAbsolutePositioned();
            ZIndexValue zindexValue = StyleResolver.getAttributeValue(box.getElement(), AttributeFinder.ZINDEX);
            Integer zindex = zindexValue == null || zindexValue.isAuto() ? AUTO_POSITION : Integer.valueOf(zindexValue.getInt());
            this.addToStack(zindex, pos);
        }
        return null;
    }

    public void paint(Graphics g, Shape allocation, int mode) {
        Rectangle parentRef = (Rectangle)allocation;
        Rectangle clip = g.getClipBounds();
        if (this.floated != null && mode == 1) {
            ArrayList<PositionInfo> clone = new ArrayList<PositionInfo>(this.floated.size());
            clone.addAll(this.floated);
            for (PositionInfo f : clone) {
                this.paintView(parentRef, clip, f, g);
            }
        }
        switch (mode) {
            case 0: {
                if (this.positionedNegative == null) break;
                for (PositionInfo f : new PositionIterable(mode, true)) {
                    this.paintView(parentRef, clip, f, g);
                }
                break;
            }
            case 3: {
                if (this.positionedNeutral != null) {
                    for (PositionInfo f : this.positionedNeutral) {
                        this.paintView(parentRef, clip, f, g);
                    }
                }
                if (this.positionedPositive == null) break;
                for (PositionInfo f : new PositionIterable(mode, true)) {
                    this.paintView(parentRef, clip, f, g);
                }
                break;
            }
        }
    }

    private void paintView(Rectangle parentRef, Rectangle clip, PositionInfo f, Graphics g) {
        Insets margins = f.pos_relative && !f.view.isFloating() ? IGNORE_MARGIN : f.view.getMargins();
        Rectangle span = f.view.getSpan();
        Rectangle r = new Rectangle(parentRef.x + f.x + margins.left, parentRef.y + f.y + margins.top, f.view.getOuterWidth(), f.view.getOuterHeight());
        r.width = Math.max(1, r.width);
        r.height = Math.max(1, r.height);
        Rectangle spanTest = r;
        if (clip != null && (span.width > r.width || span.height > r.height)) {
            spanTest = new Rectangle(r);
            spanTest.width = span.width;
            spanTest.height = span.height;
        }
        if (clip == null || r.intersects(spanTest)) {
            f.view.paint(g, r);
        }
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn, int mode) {
        Rectangle rect = a.getBounds();
        for (PositionInfo f : new PositionIterable(mode, false)) {
            int result;
            Rectangle r = this.getBoundingRect(rect, f, x, y);
            if (r == null || (result = f.view.viewToModel(x, y, r, biasReturn)) < 0) continue;
            f.view.viewToModel(x, y, r, biasReturn);
            return result;
        }
        return -1;
    }

    private Rectangle getBoundingRect(Rectangle bounds, PositionInfo f, float x, float y) {
        Rectangle span = f.view.getSpan();
        Rectangle spanRect = new Rectangle(bounds.x + f.x + span.x, bounds.y + f.y + span.y, span.width, span.height);
        if (spanRect.contains(x, y)) {
            Rectangle r = new Rectangle(bounds.x + f.x + f.view.getMargins().left, bounds.y + f.y + f.view.getMargins().top, f.view.getOuterWidth(), f.view.getOuterHeight());
            return r;
        }
        return null;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b, int mode) throws BadLocationException {
        Rectangle rect = a.getBounds();
        for (PositionInfo f : new PositionIterable(mode, false)) {
            Shape result = this.modelToViewSingular(pos, b, rect, f);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Shape modelToViewSingular(int pos, Position.Bias b, Rectangle rect, PositionInfo f) throws BadLocationException {
        int startOffset = f.view.getStartOffset();
        int endOffset = f.view.getEndOffset();
        if (b == Position.Bias.Forward) {
            --endOffset;
        } else {
            ++startOffset;
        }
        if (startOffset <= pos && endOffset >= pos) {
            rect.x += f.x + f.view.getMargins().left;
            rect.y += f.y + f.view.getMargins().top;
            rect.width = f.view.getOuterWidth();
            rect.height = f.view.getOuterHeight();
            return f.view.modelToView(pos, rect, b);
        }
        return null;
    }

    private PositionInfo getMostOuterFloat(int top, boolean typeLeft) {
        PositionInfo mR = null;
        for (PositionInfo f : this.floated) {
            if (f.getTop() > top || f.getBottom() <= top || f.typeLeft != typeLeft) continue;
            if (mR != null) {
                if (typeLeft) {
                    if (f.getRight() <= mR.getRight()) continue;
                    mR = f;
                    continue;
                }
                if (f.getLeft() >= mR.getLeft()) continue;
                mR = f;
                continue;
            }
            mR = f;
        }
        return mR;
    }

    private PositionInfo findMostOuterFloat(int top, int bottom, boolean typeLeft) {
        PositionInfo mR = null;
        for (PositionInfo f : this.floated) {
            boolean inRange = f.getTop() <= top && f.getBottom() > top || f.getTop() <= bottom && f.getBottom() > bottom || f.getTop() < top && f.getBottom() > bottom;
            if (!inRange || f.typeLeft != typeLeft) continue;
            if (mR != null) {
                if (typeLeft) {
                    if (f.getRight() <= mR.getRight()) continue;
                    mR = f;
                    continue;
                }
                if (f.getLeft() >= mR.getLeft()) continue;
                mR = f;
                continue;
            }
            mR = f;
        }
        return mR;
    }

    public PositionInfo getNextFloatBelow(int y, int leftX, int rightX, boolean typeleft) {
        for (PositionInfo f : this.floated) {
            if (f.typeLeft != typeleft || f.getRight() <= leftX || f.getLeft() >= rightX || f.y <= y) continue;
            return f;
        }
        return null;
    }

    public int getAvailableVSpace(int y, int leftX, int rightX) {
        for (PositionInfo f : this.floated) {
            if (f.getRight() <= leftX || f.getLeft() >= rightX || f.y <= y) continue;
            return f.y - y;
        }
        return 2146483647;
    }

    public LineSpaceInfo findLineSpace(Rectangle minRequired, Rectangle bounds, int clear, int textAlign) {
        LineSpaceInfo line = new LineSpaceInfo();
        int leftX = bounds.x;
        int rightX = bounds.x + bounds.width;
        line.y = bounds.y;
        if (this.floated == null || this.floated.size() == 0) {
            line.maxWidth = bounds.width;
            line.x = leftX;
            line.maxHeightOnMaxWidth = 2146483647;
            line.maxHeightOnReqWidth = 2146483647;
            return line;
        }
        PositionInfo leftEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, true);
        PositionInfo rightEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, false);
        int leftFloatX = 0;
        int leftFloatXend = 0;
        int leftFloatBottom = 0;
        int rightFloatX = 0;
        int rightFloatBottom = 0;
        int spaceH = 0;
        boolean doStep = false;
        do {
            PositionInfo next;
            doStep = false;
            if (leftEnd != null && leftEnd.getRight() > leftX) {
                leftFloatX = leftEnd.x;
                leftFloatXend = leftEnd.getRight();
                leftFloatBottom = leftEnd.getBottom();
            } else {
                leftFloatX = leftX;
                leftFloatXend = leftX;
                next = this.getNextFloatBelow(line.y, leftX, rightX, true);
                if (next != null) {
                    leftFloatBottom = next.y;
                } else {
                    int n = leftFloatBottom = leftEnd != null ? leftEnd.getBottom() : 2146483647;
                }
            }
            if (rightEnd != null && rightEnd.x < rightX) {
                rightFloatX = rightEnd.x;
                rightFloatBottom = rightEnd.getBottom();
            } else {
                rightFloatX = rightX;
                next = this.getNextFloatBelow(line.y, leftX, rightX, false);
                rightFloatBottom = next != null ? next.y : (rightEnd != null ? rightEnd.getBottom() : 2146483647);
            }
            spaceH = leftFloatX < rightFloatX ? rightFloatX - leftFloatXend : rightFloatX - leftX;
            boolean bl = doStep = spaceH < minRequired.width && (rightFloatBottom != 2146483647 || leftFloatBottom != 2146483647) || (clear == 1 || clear == 3) && leftEnd != null || (clear == 2 || clear == 3) && rightEnd != null;
            if (!doStep) continue;
            if (leftFloatBottom < rightFloatBottom) {
                line.y = leftFloatBottom;
            } else {
                line.y = rightFloatBottom;
            }
            leftEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, true);
            rightEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, false);
        } while (spaceH < minRequired.width && doStep);
        line.x = leftFloatX < rightFloatX ? leftFloatXend : leftX;
        line.maxWidth = spaceH;
        line.maxHeightOnMaxWidth = this.getAvailableVSpace(line.y, line.x, line.x + spaceH);
        if (textAlign == 0) {
            line.maxHeightOnReqWidth = this.getAvailableVSpace(line.y, line.x, line.x + minRequired.width);
        } else {
            line.maxHeightOnReqWidth = this.getAvailableVSpace(line.y, line.x + spaceH - minRequired.width, line.x + spaceH);
        }
        return line;
    }

    public LineSpaceInfo findClearSpace(Rectangle minRequired, Rectangle bounds, int clear, int textAlign) {
        LineSpaceInfo line = new LineSpaceInfo();
        int leftX = bounds.x;
        int rightX = bounds.x + bounds.width;
        line.y = bounds.y;
        if (this.floated.size() == 0) {
            line.maxWidth = bounds.width;
            line.x = leftX;
            line.maxHeightOnMaxWidth = 2146483647;
            line.maxHeightOnReqWidth = 2146483647;
            return line;
        }
        PositionInfo leftEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, true);
        PositionInfo rightEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, false);
        int leftFloatX = 0;
        int leftFloatXend = 0;
        int leftFloatBottom = 0;
        int rightFloatX = 0;
        int rightFloatBottom = 0;
        int spaceH = 0;
        do {
            boolean doStep;
            PositionInfo next;
            if (leftEnd != null) {
                leftFloatX = leftEnd.x;
                leftFloatXend = leftEnd.getRight();
                leftFloatBottom = leftEnd.getBottom();
            } else {
                leftFloatX = leftX;
                leftFloatXend = leftX;
                next = this.getNextFloatBelow(line.y, leftX, rightX, true);
                leftFloatBottom = next != null ? next.y : 2146483647;
            }
            if (rightEnd != null) {
                rightFloatX = rightEnd.x;
                rightFloatBottom = rightEnd.getBottom();
            } else {
                rightFloatX = rightX;
                next = this.getNextFloatBelow(line.y, leftX, rightX, false);
                rightFloatBottom = next != null ? next.y : 2146483647;
            }
            spaceH = leftFloatX < rightFloatX ? rightFloatX - leftFloatXend : rightFloatX - leftX;
            boolean bl = doStep = spaceH < minRequired.width || (clear == 1 || clear == 3) && leftEnd != null || (clear == 2 || clear == 3) && rightEnd != null;
            if (!doStep) continue;
            if (leftFloatBottom < rightFloatBottom) {
                line.y = leftFloatBottom;
            } else {
                line.y = rightFloatBottom;
            }
            leftEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, true);
            rightEnd = this.findMostOuterFloat(line.y, line.y + minRequired.height, false);
        } while (spaceH < minRequired.width);
        line.x = leftFloatX < rightFloatX ? leftFloatXend : leftX;
        line.maxWidth = spaceH;
        line.maxHeightOnMaxWidth = this.getAvailableVSpace(line.y, line.x, line.x + spaceH);
        if (textAlign == 0) {
            line.maxHeightOnReqWidth = this.getAvailableVSpace(line.y, line.x, line.x + minRequired.width);
        } else {
            line.maxHeightOnReqWidth = this.getAvailableVSpace(line.y, line.x + spaceH - minRequired.width, line.x + spaceH);
        }
        return line;
    }

    private int getMinY(int topY, boolean typeLeft) {
        int top = topY;
        for (int i = this.floated.size() - 1; i >= 0; --i) {
            PositionInfo info = this.floated.get(i);
            if (info.typeLeft != typeLeft) continue;
            if (info.y <= top) break;
            top = info.y;
            break;
        }
        return top;
    }

    private void findLocation(PositionInfo floatData, Point reference, int width) {
        int leftX = reference.x;
        int rightX = reference.x + width;
        floatData.y = this.getMinY(reference.y, floatData.typeLeft);
        PositionInfo leftEnd = this.getMostOuterFloat(floatData.y, true);
        PositionInfo rightEnd = this.getMostOuterFloat(floatData.y, false);
        floatData.x = floatData.typeLeft ? reference.x : rightX - floatData.width;
        int limit = 0;
        boolean newCycle = false;
        do {
            newCycle = false;
            if (floatData.typeLeft) {
                if (leftEnd != null && floatData.getLeft() < leftEnd.getRight()) {
                    floatData.x = leftEnd.getRight();
                    if (floatData.getRight() > rightX) {
                        floatData.x = leftX;
                        floatData.y = leftEnd.getBottom();
                        leftEnd = this.getMostOuterFloat(floatData.y, true);
                        rightEnd = this.getMostOuterFloat(floatData.y, false);
                        newCycle = true;
                    }
                }
                if (rightEnd == null || floatData.getRight() <= rightEnd.getLeft()) continue;
                if (leftEnd == null || leftEnd.getBottom() > rightEnd.getBottom()) {
                    floatData.y = rightEnd.getBottom();
                } else {
                    floatData.y = leftEnd.getBottom();
                    floatData.x = leftX;
                }
                leftEnd = this.getMostOuterFloat(floatData.y, true);
                rightEnd = this.getMostOuterFloat(floatData.y, false);
                newCycle = true;
                continue;
            }
            if (rightEnd != null && floatData.getRight() > rightEnd.getLeft()) {
                floatData.x = rightEnd.getLeft() - floatData.width;
                if (floatData.getLeft() < leftX) {
                    floatData.x = rightX - floatData.width;
                    floatData.y = rightEnd.getBottom();
                    rightEnd = this.getMostOuterFloat(floatData.y, false);
                    leftEnd = this.getMostOuterFloat(floatData.y, true);
                }
                newCycle = true;
            }
            if (leftEnd == null || floatData.getLeft() >= leftEnd.getRight()) continue;
            if (rightEnd == null || leftEnd.getBottom() < rightEnd.getBottom()) {
                floatData.y = leftEnd.getBottom();
            } else {
                floatData.y = rightEnd.getBottom();
                floatData.x = rightX - floatData.width;
            }
            rightEnd = this.getMostOuterFloat(floatData.y, false);
            leftEnd = this.getMostOuterFloat(floatData.y, true);
            newCycle = true;
        } while (++limit < 10000 && newCycle);
    }

    public void notifyNewLine(float topY) {
        if (this.recentFloats != null && this.recentFloats.size() > 0) {
            for (PositionInfo f : this.recentFloats) {
                this.floatView(topY, f, -1);
            }
        }
        this.recentFloats = null;
    }

    public boolean floatView(float topY, PositionInfo f, int currentLineLength) {
        if (currentLineLength >= 0 && this.recentFloats != null && this.recentFloats.size() > 0) {
            this.recentFloats.add(f);
            return false;
        }
        BlockView parent = (BlockView)f.view.getParent();
        Point reference = parent.getLeftUpperCorner(parent);
        reference.y = (int)((float)reference.y + topY);
        int width = parent.getContentWidth();
        if (this.floated == null) {
            this.floated = new ArrayList<PositionInfo>();
        }
        Insets margin = f.view.getMargins();
        f.width = f.view.getOuterWidth() + margin.left + margin.right;
        f.height = f.view.getOuterHeight() + margin.top + margin.bottom;
        if (currentLineLength >= 0) {
            int leftX = reference.x;
            int rightX = reference.x + width;
            f.y = this.getMinY(reference.y, f.typeLeft);
            PositionInfo leftEnd = this.getMostOuterFloat(f.y, true);
            PositionInfo rightEnd = this.getMostOuterFloat(f.y, false);
            leftX = Math.max(leftEnd != null ? leftEnd.x + leftEnd.width : 0, leftX);
            rightX = Math.min(rightEnd != null ? rightEnd.x : Integer.MAX_VALUE, rightX);
            if (f.width > rightX - leftX - currentLineLength) {
                if (this.recentFloats == null) {
                    this.recentFloats = new ArrayList<PositionInfo>();
                }
                this.recentFloats.add(f);
                return false;
            }
        }
        this.findLocation(f, reference, width);
        if (f.view.getPosition() == 1) {
            Layout.offsetRelative(f);
        }
        Layout.union(this.spanFloated, f.x, f.y, f.width, f.height);
        this.floated.add(f);
        return true;
    }

    public int getBottomPosition(BlockView parent) {
        int bottom = 0;
        Point reference = parent.getLeftUpperCorner(parent);
        if (this.floated != null && this.floated.size() > 0) {
            for (PositionInfo f : this.floated) {
                int fbottom = f.y + f.height;
                if (fbottom <= bottom) continue;
                bottom = fbottom;
            }
        }
        return bottom - reference.y;
    }

    public void clear() {
        if (this.floated != null) {
            this.floated.clear();
        }
        if (this.positionedNegative != null) {
            this.positionedNegative.clear();
        }
        if (this.positionedNeutral != null) {
            this.positionedNeutral.clear();
        }
        if (this.positionedPositive != null) {
            this.positionedPositive.clear();
        }
        this.hasObjects = false;
        this.recentFloats = null;
        this.spanFloated.setBounds(0, 0, 0, 0);
        this.spanNegative.setBounds(0, 0, 0, 0);
        this.spanNeutral.setBounds(0, 0, 0, 0);
        this.spanPositive.setBounds(0, 0, 0, 0);
    }

    public void clearMyFloats(BoxView parent) {
        if (this.floated == null) {
            return;
        }
        ArrayList<PositionInfo> clone = new ArrayList<PositionInfo>(this.floated.size());
        clone.addAll(this.floated);
        for (PositionInfo info : clone) {
            if (info.view.getParent() != parent) continue;
            this.floated.remove(info);
        }
        if (!(this.floated.size() != 0 || this.positionedNegative != null && this.positionedNegative.size() != 0 || this.positionedNeutral != null && this.positionedNeutral.size() != 0 || this.positionedPositive != null && this.positionedPositive.size() != 0)) {
            this.hasObjects = false;
        }
        this.recalculateSpan();
    }

    private void recalculateSpan() {
        this.spanFloated.setBounds(0, 0, 0, 0);
        this.spanNegative.setBounds(0, 0, 0, 0);
        this.spanNeutral.setBounds(0, 0, 0, 0);
        this.spanPositive.setBounds(0, 0, 0, 0);
        for (PositionInfo info : new PositionIterable(4, true)) {
            Layout.union(this.spanFloated, info.x, info.y, info.width, info.height);
        }
    }

    public boolean hasViews() {
        return this.hasObjects;
    }

    public ViewPositionInfo getViewForPosition(Point position, Rectangle a, int mode) {
        Rectangle rect = a.getBounds();
        for (PositionInfo f : new PositionIterable(mode, false)) {
            Insets m = f.view.getMargins();
            Rectangle r = new Rectangle(rect.x + f.x + m.left, rect.y + f.y + m.top, f.view.getOuterWidth(), f.view.getOuterHeight());
            if (!r.contains(position) || f.view.getVisibility() == 1) continue;
            ViewPositionInfo location = f.view.getViewForPosition(position, r);
            if (location == null) {
                return new ViewPositionInfo(r, f.view, f.view.getViewCount() != 0);
            }
            return location;
        }
        return null;
    }

    public Rectangle getSpan() {
        Rectangle span = this.spanFloated.getBounds();
        Layout.union(span, this.spanNegative);
        Layout.union(span, this.spanNeutral);
        Layout.union(span, this.spanPositive);
        return span;
    }

    public void notifyBlockFinished(boolean hard) {
        int zindex;
        if (this.positionedNegative != null && this.positionedNegative.size() > 0) {
            for (Map.Entry<Integer, List<PositionInfo>> entry : this.positionedNegative.entrySet()) {
                zindex = entry.getKey();
                this.processPositioned(hard, entry.getValue(), zindex);
            }
        }
        if (this.positionedNeutral != null && this.positionedNeutral.size() > 0) {
            this.processPositioned(true, this.positionedNeutral, Integer.MIN_VALUE);
        }
        if (this.positionedPositive != null && this.positionedPositive.size() > 0) {
            for (Map.Entry<Integer, List<PositionInfo>> entry : this.positionedPositive.entrySet()) {
                zindex = entry.getKey();
                this.processPositioned(hard, entry.getValue(), zindex);
            }
        }
    }

    private void processPositioned(boolean hard, List<PositionInfo> infoList, int zindex) {
        for (PositionInfo info : infoList) {
            boolean doLayout;
            BoxView child = info.view;
            boolean alreadyLayoutedByCaller = !child.isInFlow() && !child.isFloating();
            boolean bl = doLayout = !info.layouted || hard && alreadyLayoutedByCaller;
            if (doLayout) {
                child.performLayoutWidth();
            }
            this.placePositioned(info);
            if (doLayout) {
                child.performLayout(hard);
            }
            info.height = child.getOuterHeight();
            info.width = child.getOuterWidth();
            this.addSpan(zindex, info);
        }
    }

    private void addSpan(int zindex, PositionInfo info) {
        Rectangle span = info.view.getSpan().getBounds();
        span.x += info.x;
        span.y += info.y;
        if (zindex == Integer.MIN_VALUE) {
            Layout.union(this.spanNeutral, span.x, span.y, span.width, span.height);
        } else if (zindex < 0) {
            Layout.union(this.spanNegative, span.x, span.y, span.width, span.height);
        } else {
            Layout.union(this.spanPositive, span.x, span.y, span.width, span.height);
        }
    }

    private void addToStack(Integer level, PositionInfo view) {
        ArrayList<PositionInfo> list;
        if (level != AUTO_POSITION) {
            SortedMap<Integer, List<PositionInfo>> positioned;
            if (level >= 0) {
                if (this.positionedPositive == null) {
                    this.positionedPositive = new TreeMap<Integer, List<PositionInfo>>();
                }
                positioned = this.positionedPositive;
            } else {
                if (this.positionedNegative == null) {
                    this.positionedNegative = new TreeMap<Integer, List<PositionInfo>>();
                }
                positioned = this.positionedNegative;
            }
            list = (ArrayList<PositionInfo>)positioned.get(level);
            if (list == null) {
                list = new ArrayList<PositionInfo>();
                positioned.put(level, list);
            }
        } else {
            if (this.positionedNeutral == null) {
                this.positionedNeutral = new ArrayList<PositionInfo>();
            }
            list = this.positionedNeutral;
        }
        list.add(view);
    }

    public BlockView getRoot() {
        return this.root;
    }

    private void placePositioned(PositionInfo pos) {
        int rightX;
        int leftX;
        if (pos.view.getPosition() == 1) {
            BlockView parent = (BlockView)pos.view.getParent();
            Point leftUpperCorner = parent.getLeftUpperCorner(parent);
            pos.x += leftUpperCorner.x;
            pos.y += leftUpperCorner.y;
            return;
        }
        Element elem = pos.view.getElement();
        LengthUnit top = StyleResolver.getAttributeValue(elem, AttributeFinder.TOP);
        LengthUnit bottom = StyleResolver.getAttributeValue(elem, AttributeFinder.BOTTOM);
        LengthUnit left = StyleResolver.getAttributeValue(elem, AttributeFinder.LEFT);
        LengthUnit right = StyleResolver.getAttributeValue(elem, AttributeFinder.RIGHT);
        boolean definedWidth = !pos.view.getWidthUnit().isAuto();
        boolean leftSet = left != null && left.getType() != -1;
        boolean rightSet = right != null && right.getType() != -1;
        BlockView positionContainer = this.root;
        BlockView blockParent = (BlockView)pos.view.getParent();
        Point parentPos = blockParent.getLeftUpperCorner(blockParent);
        if (leftSet || rightSet) {
            leftX = 0;
            rightX = positionContainer.getContentWidth();
            if (leftSet) {
                leftX = (int)left.calculateValue(positionContainer.getContentWidth(), pos.view);
                if (definedWidth) {
                    rightX = leftX + pos.view.getContentWidth();
                } else if (rightSet) {
                    rightX -= (int)right.calculateValue(positionContainer.getContentWidth(), pos.view);
                }
            } else {
                rightX -= (int)right.calculateValue(positionContainer.getContentWidth(), pos.view);
                if (definedWidth) {
                    leftX = rightX - pos.view.getContentWidth();
                }
            }
        } else {
            int margin = pos.view.getBox().getTotalWidthGain();
            leftX = parentPos.x;
            rightX = definedWidth ? leftX + pos.view.getContentWidth() : Math.min(positionContainer.getContentWidth() - parentPos.x - margin, pos.view.getContentWidth());
        }
        pos.x = leftX;
        pos.width = rightX - leftX;
        int topY = pos.y + parentPos.y;
        int bottomY = topY + pos.view.getOuterHeight();
        if (top != null && top.getType() != -1) {
            int offset;
            topY = offset = (int)top.calculateValue(this.root.getContentHeight(), pos.view);
            bottomY = topY + pos.view.getOuterHeight();
        }
        if (bottom != null && bottom.getType() != -1) {
            int ref = this.root.getOuterHeight();
            bottomY = (int)((float)ref - bottom.calculateValue(ref, pos.view));
            if (top == null || top.getType() == -1) {
                if (pos.view.getStatus() != 0) {
                    pos.view.performLayout(false);
                }
                topY = bottomY - pos.view.getContentHeight();
            }
            if (bottomY < topY) {
                bottomY = topY;
            }
        }
        pos.y = topY;
        pos.height = bottomY - topY;
        pos.width = rightX - leftX;
        pos.view.setSize(pos.width, pos.height);
    }

    public Rectangle getSpan(int mode) {
        switch (mode) {
            case 0: {
                return this.spanNegative;
            }
            case 1: {
                return this.spanFloated;
            }
            case 2: {
                return this.spanNeutral;
            }
            case 3: {
                return this.spanPositive;
            }
        }
        return this.getSpan();
    }

    public boolean getVisibleElements(Rectangle2D clip, BoxView parent, boolean zPositive, DOMUtils.ResultMap result) {
        if (zPositive) {
            return this.addForMode(5, clip, parent, result);
        }
        return this.addForMode(0, clip, parent, result);
    }

    private boolean addForMode(int mode, Rectangle2D clip, BoxView parent, DOMUtils.ResultMap result) {
        PositionIterator i = new PositionIterator(mode, true);
        Point parentOffset = ((BlockView)parent).getLeftUpperCorner(this.root);
        if (parentOffset.x != 0 || parentOffset.y != 0) {
            clip = new Rectangle2D.Double(clip.getX() + (double)parentOffset.x, clip.getY() + (double)parentOffset.y, clip.getWidth(), clip.getHeight());
        }
        boolean hasVisibleElements = false;
        while (i.hasNext()) {
            PositionInfo next = (PositionInfo)i.next();
            if (next.view.getParent() != parent) continue;
            Point offset = this.getViewOffset(next.view);
            Rectangle2D.Double subClip = new Rectangle2D.Double(clip.getX() - offset.getX(), clip.getY() - offset.getY(), clip.getWidth(), clip.getHeight());
            if ((double)next.y < clip.getMaxY()) {
                hasVisibleElements |= next.view.getVisibleDOM(subClip, result);
                result.setLastVisibleContentLocation(-((RectangularShape)subClip).getY());
                continue;
            }
            result.setFirstClippedContentLocation(-((RectangularShape)subClip).getY());
        }
        return hasVisibleElements;
    }

    private Point getViewOffset(BoxView view) {
        Point rootPos = this.root.getLeftUpperCorner(this.root);
        Point viewPos = ((BlockView)view.getParent()).getLeftUpperCorner(view);
        viewPos.x -= rootPos.x;
        viewPos.y -= rootPos.y;
        return viewPos;
    }

    private class PositionInfo
    extends Layout.ViewPosition {
        private static final long serialVersionUID = 1L;
        private boolean layouted = false;
        private boolean pos_relative = false;
        private boolean typeLeft;

        PositionInfo(BoxView box) {
            this.pos_relative = box.getPosition() == 1;
            this.view = box;
        }

        PositionInfo(BoxView box, boolean typeLeft) {
            this(box);
            this.typeLeft = typeLeft;
        }

        public int getLeft() {
            return this.x;
        }

        public int getRight() {
            return this.x + this.width;
        }

        public int getTop() {
            return this.y;
        }

        public int getBottom() {
            return this.height > 0 ? this.y + this.height : this.y + 1;
        }

        @Override
        public String toString() {
            return "Floated: " + this.view.toString();
        }
    }

    private class PositionIterator
    implements Iterator<PositionInfo> {
        private List<List<PositionInfo>> sortedList;
        private List<PositionInfo> current;
        private PositionInfo info;
        private int level;
        private int index;
        private final boolean forward;

        public PositionIterator(int mode, boolean forward) {
            this.forward = forward;
            this.sortedList = new ArrayList<List<PositionInfo>>();
            switch (mode) {
                case 0: {
                    if (StackManager.this.positionedNegative == null) break;
                    this.sortedList.addAll(StackManager.this.positionedNegative.values());
                    break;
                }
                case 2: {
                    if (StackManager.this.positionedNeutral == null) break;
                    this.sortedList.add(StackManager.this.positionedNeutral);
                    break;
                }
                case 3: {
                    if (StackManager.this.positionedPositive == null) break;
                    this.sortedList.addAll(StackManager.this.positionedPositive.values());
                    break;
                }
                case 4: {
                    if (StackManager.this.positionedNegative != null) {
                        this.sortedList.addAll(StackManager.this.positionedNegative.values());
                    }
                }
                case 5: {
                    if (StackManager.this.floated != null && StackManager.this.floated.size() > 0) {
                        this.sortedList.add(StackManager.this.floated);
                    }
                    if (StackManager.this.positionedNeutral != null && StackManager.this.positionedNeutral.size() > 0) {
                        this.sortedList.add(StackManager.this.positionedNeutral);
                    }
                    if (StackManager.this.positionedPositive == null || StackManager.this.positionedPositive.size() <= 0) break;
                    this.sortedList.addAll(StackManager.this.positionedPositive.values());
                }
            }
            if (!forward && this.sortedList.size() > 1) {
                Collections.reverse(this.sortedList);
            }
            while (this.sortedList.size() > this.level && this.sortedList.get(this.level).size() == 0) {
                ++this.level;
            }
            List<PositionInfo> list = this.current = this.sortedList.size() > this.level ? this.sortedList.get(this.level) : null;
            if (this.current != null) {
                this.index = forward ? 0 : this.current.size() - 1;
                this.info = this.current.get(this.index);
            }
        }

        @Override
        public boolean hasNext() {
            return this.info != null && this.current != null;
        }

        @Override
        public PositionInfo next() {
            if (this.current == null || this.info == null) {
                return null;
            }
            PositionInfo now = this.info;
            if (this.forward ? this.index >= this.current.size() - 1 : this.index <= 0) {
                while (this.sortedList.size() > this.level && this.sortedList.get(this.level++).size() == 0) {
                }
                if (this.sortedList.size() == this.level) {
                    this.current = null;
                    this.info = null;
                } else {
                    this.current = this.sortedList.size() > this.level ? this.sortedList.get(this.level) : null;
                    this.index = this.forward ? 0 : this.current.size() - 1;
                    this.info = this.current.get(this.index);
                }
            } else {
                this.index += this.forward ? 1 : -1;
                this.info = this.current.get(this.index);
            }
            return now;
        }

        @Override
        public void remove() {
        }
    }

    public static class FloatChange {
        private boolean left;
        private int offsetChange;

        private FloatChange(boolean left, int offsetChange) {
            this.left = left;
            this.offsetChange = offsetChange;
        }

        public boolean isLeft() {
            return this.left;
        }

        public int getOffsetChange() {
            return this.offsetChange;
        }
    }

    private class PositionIterable
    implements Iterable<PositionInfo> {
        private Iterator<PositionInfo> iterator;

        public PositionIterable(int mode, boolean forward) {
            switch (mode) {
                case 1: {
                    this.iterator = StackManager.this.floated != null ? StackManager.this.floated.iterator() : EMPTY_ITERATOR;
                    break;
                }
                default: {
                    this.iterator = StackManager.this.hasObjects ? new PositionIterator(mode, forward) : EMPTY_ITERATOR;
                }
            }
        }

        @Override
        public Iterator<PositionInfo> iterator() {
            return this.iterator;
        }
    }

    public static class LineSpaceInfo {
        private int x;
        private int y;
        private int maxWidth;
        private int maxHeightOnMaxWidth;
        private int maxHeightOnReqWidth;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getMaxHeightOnMaxWidth() {
            return this.maxHeightOnMaxWidth;
        }

        public int getMaxHeightOnReqWidth() {
            return this.maxHeightOnReqWidth;
        }
    }

    private static class EmptyIterator
    implements Iterator<PositionInfo> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public PositionInfo next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

