/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Logger {
    public static final int SILENT = -1;
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static int logLevel = 1;
    private static int errors = 0;
    private static int criticals = 0;
    private static int warnings = 0;
    private static JFrame auxDisplay;
    private static JTextPane console;
    private static boolean showTime;
    private static boolean showFrame;
    private static PrintStream errStream;
    private static PrintStream outStream;
    private static final String CRITICAL_PREFIX = "[CRITICAL] ";
    private static final String ERROR_PREFIX = "[ERROR   ] ";
    private static final String WARNING_PREFIX = "[WARNING ] ";
    private static final String INFO_PREFIX = "[info    ] ";
    private static final String DEBUG_PREFIX = "[debug   ] ";

    public static boolean doesLog(int level) {
        return level <= logLevel;
    }

    public static final void critical(String msg) {
        Logger.checkFrame();
        if (logLevel >= 0) {
            errStream.println(CRITICAL_PREFIX + msg);
        }
        ++criticals;
    }

    public static final void critical(Throwable t) {
        Logger.checkFrame();
        if (logLevel >= 0) {
            outStream.println("[CRITICAL] EXCEPTION");
            t.printStackTrace(outStream);
        }
        ++criticals;
    }

    public static final void error(String msg) {
        Logger.checkFrame();
        if (logLevel >= 1) {
            outStream.println(ERROR_PREFIX + msg);
        }
        ++errors;
    }

    public static final void error(Throwable t) {
        Logger.checkFrame();
        if (logLevel >= 1) {
            outStream.println("[ERROR   ] EXCEPTION");
            t.printStackTrace(outStream);
        }
        ++errors;
    }

    public static final void warning(String msg) {
        Logger.checkFrame();
        if (logLevel >= 2) {
            outStream.println(WARNING_PREFIX + msg);
        }
        ++warnings;
    }

    public static final void warning(Throwable t) {
        Logger.checkFrame();
        if (logLevel >= 2) {
            outStream.println("[WARNING ] EXCEPTION");
            t.printStackTrace(outStream);
        }
        ++warnings;
    }

    public static final void info(String msg) {
        Logger.checkFrame();
        if (logLevel >= 3) {
            outStream.println(INFO_PREFIX + msg);
        }
    }

    public static final void debug(String msg) {
        Logger.checkFrame();
        if (logLevel >= 4) {
            outStream.println(DEBUG_PREFIX + msg);
        }
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void reset() {
        errors = 0;
        criticals = 0;
        warnings = 0;
    }

    public static int getCriticals() {
        return criticals;
    }

    public static int getErrors() {
        return errors;
    }

    public static int getWarnings() {
        return warnings;
    }

    private static void checkFrame() {
        if (showFrame && auxDisplay == null) {
            Logger.setAuxConsoleMode(true);
        }
    }

    public static void setAuxConsoleMode(boolean activate) {
        if (activate) {
            if (auxDisplay != null) {
                auxDisplay.setVisible(true);
                return;
            }
            auxDisplay = new JFrame("Logger AUX");
            auxDisplay.setLayout(new BorderLayout());
            auxDisplay.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    showFrame = false;
                }
            });
            console = new JTextPane();
            console.setEditable(false);
            auxDisplay.add((Component)new JScrollPane(console), "Center");
            JPanel south = new JPanel(new FlowLayout(2));
            auxDisplay.add((Component)south, "South");
            JCheckBox checkBox = new JCheckBox(new AbstractAction("Show Time"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    showTime = !showTime;
                }
            });
            checkBox.setSelected(showTime);
            south.add(checkBox);
            final JComboBox<String> combo = new JComboBox<String>(new String[]{"Silent", "Critical", "Error", "Warning", "Info", "Debug"});
            south.add(combo);
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Logger.setLogLevel(combo.getSelectedIndex() - 1);
                }
            });
            combo.setSelectedIndex(Logger.getLogLevel() + 1);
            south.add(new JButton(new AbstractAction("Clear"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    console.setText("");
                }
            }));
            outStream = errStream = new PrintStream(new FrameStream());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    auxDisplay.setSize(400, 400);
                    auxDisplay.setVisible(true);
                }
            });
        } else {
            if (auxDisplay == null) {
                return;
            }
            errStream = System.err;
            outStream = System.out;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    auxDisplay.setVisible(false);
                    auxDisplay.dispose();
                    auxDisplay = null;
                }
            });
        }
    }

    public static void setLogStream(PrintStream stream) {
        Objects.requireNonNull(stream);
        errStream = stream;
        outStream = stream;
    }

    static {
        showFrame = false;
        errStream = System.err;
        outStream = System.out;
        try {
            String prop = System.getProperty("jwebengine.debug");
            if (prop != null && "true".equalsIgnoreCase(prop.toString())) {
                logLevel = 4;
            }
            if ((prop = System.getProperty("showLogFrame")) != null && "true".equalsIgnoreCase(prop.toString())) {
                showFrame = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class FrameStream
    extends OutputStream {
        private DateFormat format = DateFormat.getTimeInstance(2);

        private FrameStream() {
        }

        @Override
        public void write(int b) throws IOException {
            Document doc = console.getDocument();
            try {
                doc.insertString(doc.getLength(), new String(new char[]{(char)b}), null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Document doc = console.getDocument();
            try {
                String str = new String(b, off, len);
                SimpleAttributeSet atts = null;
                if (str.startsWith(Logger.CRITICAL_PREFIX)) {
                    atts = new SimpleAttributeSet();
                    StyleConstants.setForeground(atts, Color.RED);
                    StyleConstants.setBold(atts, true);
                }
                if (str.startsWith(Logger.ERROR_PREFIX)) {
                    atts = new SimpleAttributeSet();
                    StyleConstants.setForeground(atts, Color.RED);
                }
                if (str.startsWith(Logger.WARNING_PREFIX)) {
                    atts = new SimpleAttributeSet();
                    StyleConstants.setForeground(atts, Color.ORANGE);
                }
                if (str.startsWith(Logger.DEBUG_PREFIX)) {
                    atts = new SimpleAttributeSet();
                    StyleConstants.setForeground(atts, Color.GRAY);
                }
                if (showTime && len > Logger.CRITICAL_PREFIX.length()) {
                    doc.insertString(doc.getLength(), this.format.format(new Date()), atts);
                }
                doc.insertString(doc.getLength(), str, atts);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

