/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.css.CSS;
import com.inet.html.css.CSSChangeListener;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class Styles
implements Cloneable {
    private static final String INITIAL = "initial_styles";
    private static final String DEFAULT_INLINE = "default_inline";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("-?[_a-zA-Z]+[_a-zA-Z0-9-]*");
    private StyleSourceMap sources = new StyleSourceMap();
    private final HashMap<CSS.Attribute, ArrayList<Selector>> importantSelectors = new HashMap();
    private final HashMap<CSS.Attribute, ArrayList<Selector>> normalSelectors = new HashMap();
    private final HashMap<HTML.Tag, ArrayList<Selector>> tagSelectors = new HashMap();
    private final ArrayList<Selector> allSelectors = new ArrayList();
    private final HashMap<HTML.Tag, ArrayList<Selector>> otherSelectors = new HashMap();
    private boolean compiled = false;
    private final HashMap<HTML.Tag, MutableAttributeSet> defaultAttributes = new HashMap();
    private MutableAttributeSet baseSet = null;
    private int index;
    private ClassIDGenerator idGenerator = new ClassIDGenerator();
    public static final Object DONT_PARSE = new Object();
    private int initialCount = 0;
    private boolean dropInitials = true;
    private int dropOffset = 0;
    private String filename;
    private CSSChangeListener resolver;
    private int indexChecked;

    public Styles(String filename) {
        this.filename = filename;
        this.sources.create(DEFAULT_INLINE, true, false);
    }

    public Styles(String filename, Styles base) {
        this.filename = filename;
        this.sources.create(DEFAULT_INLINE, true, false);
        if (base != null && base.sources.get(DEFAULT_INLINE) != null) {
            this.initialCount = ((StyleSource)base.sources.get(DEFAULT_INLINE)).size();
            for (StyleSheetEntry entry : (StyleSource)base.sources.get(DEFAULT_INLINE)) {
                this.addInitialRule(entry.selector, entry.atts, INITIAL);
            }
            this.index = this.initialCount;
        }
    }

    public void addInitialRule(String selectors, AttributeSet attrs, String fileName) {
        this.dropInitials = false;
        if (this.sources.get(DEFAULT_INLINE) != null && ((StyleSource)this.sources.get(DEFAULT_INLINE)).size() > 0) {
            this.dropInitials = true;
            return;
        }
        if (this.sources.get(INITIAL) == null) {
            this.sources.put(INITIAL, new StyleSource(INITIAL, true, false));
        }
        if (this.initialCount >= ((StyleSource)this.sources.get(INITIAL)).size()) {
            this.addRule(selectors, attrs, INITIAL, false);
            ++this.initialCount;
        }
        this.dropInitials = true;
    }

    public Object register(Object source, boolean isInline, boolean isForeign) {
        if (source == null) {
            return null;
        }
        if (this.sources.get(source) != null) {
            if (Logger.doesLog(4)) {
                Logger.debug("Style source registered twice: " + source);
            }
            return DONT_PARSE;
        }
        this.sources.create(source, isInline, isForeign);
        Object className = this.getClassName(source);
        if (Logger.doesLog(4)) {
            Logger.debug("Created CSS Namespace '" + className + "'  for source: " + source);
        }
        return className;
    }

    public void unregister(Object source) {
        StyleSource context = (StyleSource)this.sources.get(source);
        if (context != null) {
            StyleSource defaultInline = (StyleSource)this.sources.get(DEFAULT_INLINE);
            if (defaultInline == null) {
                defaultInline = new StyleSource(DEFAULT_INLINE, true, false);
                this.sources.put(DEFAULT_INLINE, defaultInline);
            }
            defaultInline.addAll(context);
            this.sources.remove(source);
        }
    }

    public void updateIndex() {
        StyleSource inlines = (StyleSource)this.sources.get(DEFAULT_INLINE);
        if (inlines.size() > this.indexChecked) {
            for (int i = this.indexChecked; i < inlines.size(); ++i) {
                Matcher m;
                StyleSheetEntry entry = (StyleSheetEntry)inlines.get(i);
                if (entry.selector == null || !entry.selector.contains("jwe-style") || !(m = ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(entry.selector)).matches()) continue;
                try {
                    this.idGenerator.register(Integer.parseInt(m.group(1)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.indexChecked = inlines.size();
    }

    public boolean addRule(String selectors, AttributeSet attrs, Object source, boolean skipIfKnown) {
        if (this.dropInitials && this.initialCount > 0 && this.dropOffset < this.initialCount) {
            int initIndex = this.index - this.initialCount + this.dropOffset;
            StyleSource styleSource = (StyleSource)this.sources.get(INITIAL);
            if (styleSource != null) {
                if (initIndex < styleSource.size()) {
                    StyleSheetEntry entry = (StyleSheetEntry)styleSource.get(initIndex);
                    if ((entry.selector.equals(selectors) || source instanceof String && entry.selector.toLowerCase().equals(selectors + "." + source)) && entry.atts.equals(attrs)) {
                        ++this.dropOffset;
                        return !(source instanceof String) || !entry.selector.toLowerCase().equals(selectors + "." + source);
                    }
                    this.dropInitials = false;
                } else {
                    this.dropInitials = false;
                }
            }
        }
        this.dropInitials = false;
        StyleSheetEntry entry = new StyleSheetEntry(attrs, selectors);
        Object className = this.sources.add(entry, source == null ? DEFAULT_INLINE : source);
        if (className instanceof CssParser.MediaSelector) {
            CssParser.MediaSelector selector = (CssParser.MediaSelector)className;
            boolean useSelector = selector.isUseStyles();
            className = selector.getSourceID();
            if (!useSelector) {
                if (className != null && className != DEFAULT_INLINE) {
                    for (String part : selectors.split(",")) {
                        try {
                            String partTrim = part.trim();
                            if (partTrim.length() == 0) continue;
                            Selector sel = new Selector(partTrim, attrs, this.index++);
                            sel.setSourceClass(className);
                            entry.addSelector(sel);
                        }
                        catch (IllegalArgumentException e) {
                            if (!Logger.doesLog(4)) continue;
                            Logger.debug(e.getMessage());
                        }
                    }
                }
                return true;
            }
        }
        String[] parts = selectors.split(",");
        boolean hasGeneratedStyle = true;
        for (String part : parts) {
            try {
                String partTrim = part.trim();
                if (partTrim.length() == 0) continue;
                Selector sel = new Selector(partTrim, attrs, this.index++);
                if (className != null && source != null && !sel.hasJWEclass()) {
                    sel.setSourceClass(className);
                    entry.addSelector(sel);
                    hasGeneratedStyle = false;
                }
                this.addToSplittedLists(sel);
                if (this.resolver != null) {
                    this.resolver.handleNewCSSEntry(sel);
                }
                Enumeration<?> atts = attrs.getAttributeNames();
                while (atts.hasMoreElements()) {
                    Object name = atts.nextElement();
                    if (name instanceof CSS.Attribute) {
                        AttributeValue value = (AttributeValue)attrs.getAttribute(name);
                        this.addSelector(sel, (CSS.Attribute)((Object)name), value.isImportant());
                        continue;
                    }
                    if (!Logger.doesLog(2)) continue;
                    Logger.warning("Unknown CSS attribute: " + name);
                }
            }
            catch (IllegalArgumentException e) {
                if (!Logger.doesLog(4)) continue;
                Logger.debug(e.getMessage());
            }
        }
        return hasGeneratedStyle;
    }

    private void addToSplittedLists(Selector sel) {
        HTML.Tag tag = sel.getMatchedTag();
        if (tag != null) {
            ArrayList<Selector> selectorList = this.tagSelectors.get((Object)tag);
            if (selectorList == null) {
                selectorList = new ArrayList();
                this.tagSelectors.put(tag, selectorList);
            }
            selectorList.add(sel);
        } else if (sel.isUnversalTagOnly()) {
            this.allSelectors.add(sel);
        } else {
            ArrayList<Selector> selectorList;
            tag = sel.getPrimaryTag();
            if (tag == null) {
                tag = HTML.Tag.CSSALL;
            }
            if ((selectorList = this.otherSelectors.get((Object)tag)) == null) {
                selectorList = new ArrayList();
                this.otherSelectors.put(tag, selectorList);
            }
            selectorList.add(sel);
        }
    }

    public int getRuleCount() {
        return this.sources.size();
    }

    public List<Object> getSourceIdentifiers() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object id : this.sources.keySet()) {
            if (id == INITIAL) {
                list.add(0, id);
                continue;
            }
            list.add(id);
        }
        return list;
    }

    public boolean isExternal(Object identifier) {
        StyleSource source = (StyleSource)this.sources.get(identifier);
        return source != null && !source.isInline();
    }

    public List<StyleSheetEntry> getEntries(Object sourceIdentifier) {
        return (List)this.sources.get(sourceIdentifier);
    }

    private void addSelector(Selector selector, CSS.Attribute attribName, boolean important) {
        HashMap<CSS.Attribute, ArrayList<Selector>> selectors = important ? this.importantSelectors : this.normalSelectors;
        ArrayList<Selector> tree = selectors.get((Object)attribName);
        if (tree == null) {
            tree = new ArrayList();
            selectors.put(attribName, tree);
        }
        int idx = Collections.binarySearch(tree, selector);
        tree.add(-idx - 1, selector);
    }

    public AttributeValue getCssAttribute(Element elemAttrs, CSS.Attribute searchAttr, boolean important) {
        ArrayList<Selector> selectors = important ? this.importantSelectors.get((Object)searchAttr) : this.normalSelectors.get((Object)searchAttr);
        if (selectors == null) {
            return null;
        }
        for (int i = 0; i < selectors.size(); ++i) {
            Selector selector = selectors.get(i);
            if (!selector.matches(elemAttrs)) continue;
            return (AttributeValue)selector.getRule().getAttribute((Object)searchAttr);
        }
        return null;
    }

    public AttributeValue getCssAttribute(Element elemAttrs, CSS.Attribute searchAttr, boolean important, List<Selector> matchList) {
        ArrayList<Selector> selectors = important ? this.importantSelectors.get((Object)searchAttr) : this.normalSelectors.get((Object)searchAttr);
        if (selectors == null) {
            return null;
        }
        if (matchList.size() < selectors.size()) {
            for (int i = 0; i < matchList.size(); ++i) {
                Selector selector = matchList.get(i);
                int pos = Collections.binarySearch(selectors, selector);
                if (pos < 0) continue;
                return (AttributeValue)selectors.get(pos).getRule().getAttribute((Object)searchAttr);
            }
        } else {
            for (int i = 0; i < selectors.size(); ++i) {
                Selector selector = selectors.get(i);
                int pos = Collections.binarySearch(matchList, selector);
                if (pos < 0) continue;
                return (AttributeValue)matchList.get(pos).getRule().getAttribute((Object)searchAttr);
            }
        }
        return null;
    }

    public List<Selector> createMatchList(Element targetElement, HTML.Tag tag) {
        int i;
        int size;
        ArrayList<Selector> list;
        ArrayList<Selector> matches = new ArrayList<Selector>();
        if (!this.compiled) {
            ArrayList<Selector> list2;
            if (tag != null && (list2 = this.tagSelectors.get((Object)tag)) != null) {
                matches.addAll(list2);
            }
            if (this.allSelectors != null) {
                matches.addAll(this.allSelectors);
            }
        }
        Selector current = null;
        if (tag != null && (list = this.otherSelectors.get((Object)tag)) != null) {
            size = list.size();
            for (i = 0; i < size; ++i) {
                current = list.get(i);
                if (!current.matches(targetElement)) continue;
                matches.add(current);
            }
        }
        if ((list = this.otherSelectors.get((Object)HTML.Tag.CSSALL)) != null) {
            size = list.size();
            for (i = 0; i < size; ++i) {
                current = list.get(i);
                if (!current.matches(targetElement)) continue;
                matches.add(current);
            }
        }
        Collections.sort(matches, Selector.COMPARATOR);
        return matches;
    }

    public void clear() {
        this.sources.clear();
        this.importantSelectors.clear();
        this.normalSelectors.clear();
        this.index = 0;
        this.sources.create(DEFAULT_INLINE, true, false);
    }

    public String getName() {
        return this.filename;
    }

    public int getInitialCount() {
        return this.initialCount;
    }

    public void setResolver(CSSChangeListener resolver) {
        this.resolver = resolver;
    }

    public void compile() {
        this.baseSet = new SimpleAttributeSet();
        for (Selector selector : this.allSelectors) {
            this.convertToTemp(selector.getRule(), this.baseSet);
            this.removeSelectorFromMatchList(selector, this.importantSelectors);
            this.removeSelectorFromMatchList(selector, this.normalSelectors);
        }
        for (HTML.Tag tag : HTML.Tag.values()) {
            SimpleAttributeSet attSet = new SimpleAttributeSet(this.baseSet);
            this.defaultAttributes.put(tag, attSet);
        }
        for (Map.Entry entry : this.tagSelectors.entrySet()) {
            MutableAttributeSet set = this.defaultAttributes.get(entry.getKey());
            for (Selector sel : (ArrayList)entry.getValue()) {
                this.convertToTemp(sel.getRule(), set);
                this.removeSelectorFromMatchList(sel, this.importantSelectors);
                this.removeSelectorFromMatchList(sel, this.normalSelectors);
            }
        }
        this.compiled = true;
        this.allSelectors.clear();
        this.tagSelectors.clear();
    }

    private void convertToTemp(AttributeSet set, MutableAttributeSet target) {
        if (set == null || target == null) {
            return;
        }
        Enumeration<?> names = set.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (!(name instanceof CSS.Attribute)) continue;
            Object value = set.getAttribute(name);
            TemporaryStyle.Attribute temp = TemporaryStyle.getAttribute((CSS.Attribute)((Object)name));
            target.addAttribute((Object)temp, value);
        }
    }

    private void removeSelectorFromMatchList(Selector s, HashMap<CSS.Attribute, ArrayList<Selector>> matchList) {
        ArrayList<CSS.Attribute> emptyKeys = new ArrayList<CSS.Attribute>();
        for (Map.Entry<CSS.Attribute, ArrayList<Selector>> entry : matchList.entrySet()) {
            ArrayList<Selector> list = entry.getValue();
            int pos = Collections.binarySearch(list, s);
            if (pos >= 0) {
                list.remove(pos);
            }
            if (list.size() != 0) continue;
            emptyKeys.add(entry.getKey());
        }
        for (CSS.Attribute key : emptyKeys) {
            matchList.remove((Object)key);
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public Set<CSS.Attribute> getDescribedAttributes() {
        TreeSet<CSS.Attribute> set = new TreeSet<CSS.Attribute>();
        set.addAll(this.importantSelectors.keySet());
        set.addAll(this.normalSelectors.keySet());
        return set;
    }

    public MutableAttributeSet getDefaultSet(Object tag) {
        if (this.compiled) {
            MutableAttributeSet set = this.defaultAttributes.get(tag);
            if (set == null) {
                return this.baseSet;
            }
            return set;
        }
        return null;
    }

    public Object getClassName(Object identifier) {
        StyleSource set = (StyleSource)this.sources.get(identifier);
        if (set != null) {
            return set.getNameSpace();
        }
        return null;
    }

    private class StyleSourceMap
    extends LinkedHashMap<Object, StyleSource> {
        private static final long serialVersionUID = 1L;

        private StyleSourceMap() {
        }

        public void create(Object identifier, boolean isInline, boolean external) {
            this.put(identifier, new StyleSource(identifier, isInline, external));
        }

        public Object add(StyleSheetEntry entry, Object identifier) {
            StyleSource source = (StyleSource)this.get(identifier);
            if (source != null) {
                source.add(entry);
                return source.getNameSpace();
            }
            if (Logger.doesLog(1)) {
                Logger.error("No source CSS found for '" + entry.selector + "', style will be ignored");
            }
            return null;
        }

        @Override
        public int size() {
            int size = 0;
            for (StyleSource source : this.values()) {
                size += source.size();
            }
            return size;
        }
    }

    private class StyleSource
    extends ArrayList<StyleSheetEntry> {
        private static final long serialVersionUID = 1L;
        private boolean isInline = true;
        private Object identifier;
        private Object nameSpace;

        public StyleSource(Object identifier, boolean isInline, boolean external) {
            this.identifier = identifier;
            this.isInline = isInline;
            if (external) {
                this.nameSpace = identifier instanceof String && CLASS_NAME_PATTERN.matcher((String)identifier).matches() ? identifier : (identifier instanceof CssParser.MediaSelector ? identifier : Styles.this.idGenerator.getClassID(false));
            }
        }

        public boolean isInline() {
            return this.isInline;
        }

        public Object getNameSpace() {
            return this.nameSpace;
        }

        @Override
        public int hashCode() {
            return this.identifier.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.identifier.equals(obj);
        }
    }

    public static class StyleSheetEntry {
        private AttributeSet atts;
        private String selector;
        private List<Selector> selectors;

        public StyleSheetEntry(AttributeSet atts, String selector) {
            this.atts = atts;
            this.selector = selector;
        }

        public AttributeSet getAttributess() {
            return this.atts;
        }

        public String getSelector() {
            if (this.selectors == null) {
                return this.selector;
            }
            StringBuilder b = new StringBuilder();
            for (Selector sel : this.selectors) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(sel.toExternal());
            }
            return b.toString();
        }

        public void addSelector(Selector selector) {
            if (this.selectors == null) {
                this.selectors = new ArrayList<Selector>(1);
            }
            this.selectors.add(selector);
        }
    }
}

