/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

public class Selector
implements Comparable<Selector> {
    public static final Comparator COMPARATOR = new Comparator();
    private static final Map<String, PSEUDO_CLASS> pseudoClasses = new HashMap<String, PSEUDO_CLASS>();
    private List<Tag> tagList;
    private int levelTag;
    private int levelClass;
    private int levelID;
    private int levelTotal;
    private int index;
    private AttributeSet rule;
    private boolean isAbsolutByTag = false;
    private boolean isAbsolutByElement = false;

    public Selector(String selectorString, AttributeSet rule, int index) {
        List<String> l = this.splitSelector(selectorString);
        if (l == null) {
            return;
        }
        this.index = index;
        this.rule = rule;
        this.tagList = new ArrayList<Tag>();
        for (String tag : l) {
            Tag t = new Tag(tag);
            this.tagList.add(t);
            this.levelTag += t.getLevelCount(1);
            this.levelClass += t.getLevelCount(2);
            this.levelID += t.getLevelCount(3);
        }
        Collections.reverse(this.tagList);
        if (this.tagList.size() == 1) {
            this.isAbsolutByElement = true;
            if (this.tagList.get(0).isTagOnly) {
                this.isAbsolutByTag = true;
            }
        }
        this.levelTotal = this.levelID * 65536 + this.levelClass * 256 + this.levelTag;
    }

    private List<String> splitSelector(String selector) {
        if (selector == null) {
            return null;
        }
        boolean isBracket = false;
        boolean isBrace = false;
        boolean isString = false;
        boolean wasBracket = false;
        boolean wasBrace = false;
        boolean wasString = false;
        boolean wasPrefixed = false;
        ArrayList<String> selectors = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < selector.length(); ++i) {
            char c = selector.charAt(i);
            if (wasPrefixed && c != ' ') {
                wasPrefixed = false;
            }
            if (!(isBracket || isBrace || isString || wasPrefixed || c != ' ' && c != '+' && c != '>' || buf.length() <= 0)) {
                selectors.add(buf.toString());
                buf = new StringBuffer();
                wasBracket = false;
                wasBrace = false;
                wasString = false;
                if (c != '+' && c != '>') continue;
            }
            if (isString || c != ' ') {
                wasPrefixed = buf.length() == 0 && (c == '>' || c == '+');
                buf.append(c);
            }
            if (c == '\"') {
                if (wasString) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "' at position " + i);
                }
                if (!isString) {
                    isString = true;
                } else {
                    isString = false;
                    wasString = true;
                }
            }
            if (c == '[') {
                if (wasBracket || isBracket) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "' at position " + i);
                }
                isBracket = true;
            }
            if (c == '(') {
                if (wasBrace || isBrace) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "' at position " + i);
                }
                isBrace = true;
            }
            if (c == ']') {
                if (wasBracket || !isBracket) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "' at position " + i);
                }
                isBracket = false;
                wasBracket = true;
            }
            if (c != ')') continue;
            if (wasBrace || !isBrace) {
                throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "' at position " + i);
            }
            isBrace = false;
            wasBrace = true;
        }
        if (isBracket) {
            throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "', missing closing bracket.");
        }
        if (isString) {
            throw new IllegalArgumentException("Syntax Error in Selector '" + selector + "', missing closing quote.");
        }
        if (buf.length() > 0) {
            selectors.add(buf.toString());
        }
        return selectors;
    }

    public int getLevelTotal() {
        return this.levelTotal;
    }

    public int getIndex() {
        return this.index;
    }

    public HTML.Tag getMatchedTag() {
        if (this.isAbsolutByTag) {
            return this.tagList.get(0).getMatchedTag();
        }
        return null;
    }

    public boolean isUnversalTagOnly() {
        if (this.isAbsolutByTag) {
            return this.tagList.get(0).isUnversalTagOnly();
        }
        return false;
    }

    public boolean matches(Element targetElement) {
        int posInTags = 0;
        boolean childFlag = true;
        if (this.tagList.size() == 0) {
            return true;
        }
        Tag currentTag = this.tagList.get(posInTags++);
        for (Element node = targetElement; node != null; node = node.getParentElement()) {
            if (currentTag.matches(node)) {
                childFlag = false;
                if (posInTags == this.tagList.size()) {
                    return true;
                }
                if (currentTag.modifier == 1) {
                    childFlag = true;
                }
                if (currentTag.modifier == 2) {
                    Element parent = node.getParentElement();
                    if (parent == null || !(parent instanceof AbstractDocument.BranchElement)) {
                        return false;
                    }
                    AbstractDocument.BranchElement parentNode = (AbstractDocument.BranchElement)parent;
                    if (parentNode.getChildCount() <= 1) {
                        return false;
                    }
                    while (currentTag.modifier == 2) {
                        int nodeIndex = parentNode.getIndex((TreeNode)((Object)node));
                        if (nodeIndex <= 0) {
                            return false;
                        }
                        currentTag = this.tagList.get(posInTags++);
                        Element prevNode = parentNode.getElement(nodeIndex - 1);
                        while (prevNode.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT && nodeIndex > 0) {
                            prevNode = parentNode.getElement(--nodeIndex);
                        }
                        if (!currentTag.matches(prevNode)) {
                            return false;
                        }
                        node = prevNode;
                        if (posInTags != this.tagList.size()) continue;
                        return true;
                    }
                }
                if (posInTags == this.tagList.size()) {
                    return true;
                }
                currentTag = this.tagList.get(posInTags++);
                continue;
            }
            if (!childFlag) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        list.addAll(this.tagList);
        Collections.reverse(list);
        return ((Object)list).toString();
    }

    public String toExternal() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        list.addAll(this.tagList);
        Collections.reverse(list);
        StringBuilder b = new StringBuilder();
        for (Tag tag : list) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(tag.toString());
        }
        return b.toString();
    }

    public AttributeSet getRule() {
        return this.rule;
    }

    public boolean isAbsolutByElement() {
        return this.isAbsolutByElement;
    }

    public boolean isAbsolutByTag() {
        return this.isAbsolutByTag;
    }

    @Override
    public int compareTo(Selector o) {
        return COMPARATOR.compare(this, o);
    }

    public void setSourceClass(Object className) {
        if (className == null || this.tagList.size() == 0) {
            return;
        }
        Tag tag = this.tagList.get(0);
        if (tag.classNames == null) {
            tag.classNames = new ArrayList();
            tag.classNames.add(className);
        } else {
            tag.classNames.add(0, className);
        }
        tag.isTagOnly = false;
        this.isAbsolutByTag = false;
    }

    public HTML.Tag getPrimaryTag() {
        if (this.tagList.size() > 0) {
            Object tagName = this.tagList.get(0).tagName;
            return tagName instanceof HTML.Tag ? (HTML.Tag)((Object)tagName) : null;
        }
        return null;
    }

    boolean hasJWEclass() {
        if (this.tagList != null && this.tagList.size() > 0) {
            Tag tag = this.tagList.get(0);
            if (tag.classNames == null || tag.classNames.size() == 0) {
                return false;
            }
            for (Object className : tag.classNames) {
                String classString;
                if (!(className instanceof String) || !(classString = (String)className).startsWith("jwe-style") || !ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(classString).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private class Tag {
        private int modifier;
        private Object tagName;
        private List<String> pseudoClasses;
        private List<PSEUDO_CLASS> namedPseudoClasses;
        private Object id;
        private Object attrib;
        private String attribValue;
        private int eqType;
        private List<Object> classNames;
        private boolean isUniversal = false;
        private boolean isTagOnly = false;
        private static final int STATE_PREFIX = 0;
        private static final int STATE_TAG = 1;
        private static final int STATE_ID = 2;
        private static final int STATE_PSEUDOCLASS = 3;
        private static final int STATE_CLASS = 4;
        private static final int STATE_ATTRIB = 5;
        private static final int STATE_COMPSIGN = 6;
        private static final int STATE_ATTRIBVALUES = 7;
        private static final int STATE_DONE = 8;
        private static final int TYPE_DESCENDANT = 0;
        private static final int TYPE_CHILD = 1;
        private static final int TYPE_ADJACENT = 2;
        public static final int LEVEL_ID = 3;
        public static final int LEVEL_CLASS = 2;
        public static final int LEVEL_TAG = 1;
        private static final int COMP_EQUAL = 1;
        private static final int COMP_EQUALS_ONE = 2;
        private static final int COMP_EQUALS_ONEH = 3;

        public Tag(String tagString) {
            this.parseTagString(tagString, 0);
        }

        private void parseTagString(String tagString, int offset) {
            StringBuilder buf = new StringBuilder();
            boolean inArguments = false;
            if (tagString != null) {
                int state = 0;
                block21: for (int i = 0; i < tagString.length(); ++i) {
                    char c = tagString.charAt(i);
                    switch (state) {
                        case 0: {
                            if (c == '+') {
                                this.modifier = 2;
                                ++state;
                                continue block21;
                            }
                            if (c == '>') {
                                this.modifier = 1;
                                ++state;
                                continue block21;
                            }
                            state = 1;
                        }
                        case 1: {
                            if ((c | 0x20) >= 97 && (c | 0x20) <= 122 || c == '*' || c >= '0' && c <= '9' || c == '-') {
                                buf.append(c);
                                continue block21;
                            }
                            if (c == '#') {
                                if (buf.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                                }
                                buf = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                state = 2;
                                continue block21;
                            }
                            if (c == ':') {
                                if (buf.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                                }
                                buf = new StringBuilder();
                                state = 3;
                                continue block21;
                            }
                            if (c == '.') {
                                if (buf.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                                }
                                buf = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                state = 4;
                                continue block21;
                            }
                            if (c == '[') {
                                this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                                buf = new StringBuilder();
                                state = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Illegal character '" + c + "' in selector part '" + tagString + "' at position " + (i + offset));
                        }
                        case 2: {
                            if (c != '.' && c != ':' && c != '[') {
                                buf.append(c);
                                continue block21;
                            }
                            if (c == ':') {
                                this.id = InetHtmlDocument.getCachedString(buf.toString());
                                buf = new StringBuilder();
                                state = 3;
                                continue block21;
                            }
                            if (c == '.') {
                                this.id = InetHtmlDocument.getCachedString(buf.toString());
                                buf = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                state = 4;
                                continue block21;
                            }
                            if (c == '[') {
                                this.id = InetHtmlDocument.getCachedString(buf.toString());
                                buf = new StringBuilder();
                                state = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Illegal character '" + c + "' in selector part '" + tagString + "' at position " + (i + offset));
                        }
                        case 3: {
                            if (Character.isLetterOrDigit(c) || c == '(' || c == ')' || c == '-' || c == '_') {
                                if (c == '(') {
                                    inArguments = true;
                                }
                                if (c == ')') {
                                    inArguments = false;
                                }
                                buf.append(c);
                                continue block21;
                            }
                            if (inArguments && (c == ' ' || c == ',')) {
                                buf.append(c);
                                continue block21;
                            }
                            if (c == '[') {
                                this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                                buf = new StringBuilder();
                                state = 5;
                                continue block21;
                            }
                            this.addPseudoClass(buf.toString());
                            buf = new StringBuilder();
                            state = 0;
                            --i;
                            continue block21;
                        }
                        case 4: {
                            if (c != '.' && c != '[') {
                                buf.append(c);
                                continue block21;
                            }
                            if (c == '.') {
                                this.classNames.add(InetHtmlDocument.getCachedString(buf.toString()).toLowerCase());
                                buf = new StringBuilder();
                                state = 4;
                                continue block21;
                            }
                            if (c == '[') {
                                this.classNames.add(InetHtmlDocument.getCachedString(buf.toString()).toLowerCase());
                                buf = new StringBuilder();
                                state = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (i + offset));
                        }
                        case 5: {
                            if (c == '=') {
                                this.attrib = this.getAttribute(buf.toString());
                                this.eqType = 1;
                                buf = new StringBuilder();
                                state = 7;
                                continue block21;
                            }
                            if (c == '|' || c == '~') {
                                this.attrib = this.getAttribute(buf.toString());
                                buf = new StringBuilder();
                                buf.append(c);
                                state = 6;
                                continue block21;
                            }
                            if (c == ']') {
                                this.attrib = this.getAttribute(buf.toString());
                                buf = null;
                                state = 8;
                                continue block21;
                            }
                            buf.append(c);
                            continue block21;
                        }
                        case 6: {
                            if (c == '=') {
                                if (buf.charAt(0) == '~') {
                                    this.eqType = 2;
                                }
                                if (buf.charAt(0) == '|') {
                                    this.eqType = 3;
                                }
                                buf = new StringBuilder();
                                state = 7;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (i + offset) + ". Expected '='");
                        }
                        case 7: {
                            if (this.attribValue == null && buf == null) {
                                buf = new StringBuilder();
                            }
                            if ((c == '\"' || c == '\'') && this.attribValue == null && buf.length() == 0) continue block21;
                            if (c == '\"' || c == '\'') {
                                this.attribValue = InetHtmlDocument.getCachedString(buf.toString());
                                buf = null;
                                continue block21;
                            }
                            if (c != ']') {
                                if (buf == null) continue block21;
                                buf.append(c);
                                continue block21;
                            }
                            if (this.attribValue == null) {
                                this.attribValue = InetHtmlDocument.getCachedString(buf.toString());
                                buf = null;
                            }
                            state = 8;
                        }
                        case 8: {
                            if (c == ']') continue block21;
                            throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (i + offset));
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        throw new IllegalArgumentException("Syntax error : tag is empty at position " + offset);
                    }
                    case 1: {
                        this.tagName = InetHtmlDocument.getCachedString(buf.toString().toLowerCase());
                        break;
                    }
                    case 2: {
                        this.id = InetHtmlDocument.getCachedString(buf.toString());
                        break;
                    }
                    case 3: {
                        this.addPseudoClass(buf.toString());
                        break;
                    }
                    case 4: {
                        this.classNames.add(InetHtmlDocument.getCachedString(buf.toString()).toLowerCase());
                        break;
                    }
                    case 5: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (tagString.length() + offset) + ". Exprected ']'");
                    }
                    case 6: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (tagString.length() + offset) + ". Exprected '='");
                    }
                    case 7: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + tagString + "' at position " + (tagString.length() + offset) + ". Exprected '\"'");
                    }
                }
                if (this.tagName == null || this.tagName.equals("*")) {
                    this.isUniversal = true;
                } else {
                    HTML.Tag tag = HTML.getTag((String)this.tagName);
                    if (tag != null) {
                        this.tagName = tag;
                    }
                }
                if (this.namedPseudoClasses != null && this.namedPseudoClasses.contains((Object)PSEUDO_CLASS.link)) {
                    this.namedPseudoClasses.remove((Object)PSEUDO_CLASS.link);
                    if (this.namedPseudoClasses.size() == 0) {
                        this.namedPseudoClasses = null;
                    }
                    if (this.attrib == null) {
                        this.attrib = HTML.Attribute.HREF;
                    }
                }
                if ("class".equals(this.attrib)) {
                    this.attrib = null;
                    if (this.classNames == null) {
                        this.classNames = new ArrayList<Object>();
                    }
                    this.classNames.add(this.attribValue);
                    this.attribValue = null;
                }
                if (this.tagName != null && this.pseudoClasses == null && this.namedPseudoClasses == null && this.id == null && this.attrib == null && this.attribValue == null && this.classNames == null) {
                    this.isTagOnly = true;
                }
            }
        }

        private void addPseudoClass(String nameString) {
            PSEUDO_CLASS className = PSEUDO_CLASS.get(nameString);
            if (className != null) {
                if (this.namedPseudoClasses == null) {
                    this.namedPseudoClasses = new ArrayList<PSEUDO_CLASS>();
                }
                if (!this.namedPseudoClasses.contains((Object)className)) {
                    this.namedPseudoClasses.add(className);
                }
            } else {
                if (this.pseudoClasses == null) {
                    this.pseudoClasses = new ArrayList<String>();
                }
                this.pseudoClasses.add(InetHtmlDocument.getCachedString(nameString.toLowerCase()));
            }
        }

        private Object getAttribute(String newAttrib) {
            HTML.Attribute key = HTML.getAttributeKey(newAttrib);
            if (key != null) {
                return key;
            }
            return InetHtmlDocument.getCachedString(newAttrib.toLowerCase());
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.modifier == 1) {
                buf.append('>');
            }
            if (this.modifier == 2) {
                buf.append('+');
            }
            if (this.tagName != null) {
                buf.append(this.tagName);
            }
            if (this.id != null) {
                buf.append('#').append(this.id);
            }
            if (this.pseudoClasses != null) {
                buf.append(':').append(this.pseudoClasses.stream().collect(Collectors.joining(":")));
            }
            if (this.namedPseudoClasses != null) {
                buf.append(':').append(this.namedPseudoClasses.stream().map(Object::toString).collect(Collectors.joining(":")));
            }
            if (this.classNames != null) {
                for (Object name : this.classNames) {
                    buf.append('.').append(name);
                }
            }
            if (this.attrib != null) {
                buf.append('[').append(this.attrib);
                if (this.attribValue != null) {
                    if (this.eqType == 1) {
                        buf.append('=');
                    }
                    if (this.eqType == 2) {
                        buf.append("~=");
                    }
                    if (this.eqType == 3) {
                        buf.append("|=");
                    }
                    buf.append('\"');
                    buf.append(this.attribValue);
                    buf.append('\"');
                }
                buf.append(']');
            }
            return buf.toString();
        }

        public int getLevelCount(int level) {
            switch (level) {
                case 1: {
                    return this.tagName != null ? (this.isUniversal ? 0 : 1) : 0;
                }
                case 2: {
                    int classLevel = this.classNames != null ? this.classNames.size() : 0;
                    int pseudoClassLevel = this.pseudoClasses != null || this.namedPseudoClasses != null ? 1 : 0;
                    return classLevel + pseudoClassLevel;
                }
                case 3: {
                    return this.id != null ? 1 : 0;
                }
            }
            return 0;
        }

        public boolean matches(Element element) {
            boolean somethingMatched = false;
            AttributeSet node = element.getAttributes();
            if (!this.isUniversal) {
                Object tagObj = node.getAttribute(StyleConstants.NameAttribute);
                if (tagObj != this.tagName) {
                    return false;
                }
                somethingMatched = true;
            } else if (this.tagName != null) {
                somethingMatched = true;
            }
            if (this.id != null) {
                Iterator<PSEUDO_CLASS> id;
                Iterator<PSEUDO_CLASS> iterator = id = node.isDefined((Object)HTML.Attribute.ID) ? node.getAttribute((Object)HTML.Attribute.ID) : null;
                if (this.id != id) {
                    return false;
                }
                somethingMatched = true;
            }
            if (this.pseudoClasses != null) {
                return false;
            }
            if (this.namedPseudoClasses != null) {
                for (PSEUDO_CLASS c : this.namedPseudoClasses) {
                    switch (c) {
                        case active: 
                        case hover: 
                        case link: {
                            return false;
                        }
                        case firstChild: 
                        case lastChild: {
                            int index;
                            Element parent = element.getParentElement();
                            if (parent == null) {
                                return false;
                            }
                            int n = index = c == PSEUDO_CLASS.firstChild ? 0 : parent.getElementCount() - 1;
                            if (parent.getElement(index) == element) break;
                            return false;
                        }
                    }
                }
            }
            if (this.classNames != null && this.classNames.size() > 0) {
                ArrayList<Object> tagClasses;
                block35: {
                    boolean defined = node.isDefined((Object)HTML.Attribute.CLASS);
                    tagClasses = null;
                    try {
                        Object classObject = node.getAttribute((Object)HTML.Attribute.CLASS);
                        tagClasses = defined && classObject != null && classObject instanceof ClassValue ? ((ClassValue)classObject).getClassNames() : null;
                    }
                    catch (Exception e) {
                        if (!Logger.doesLog(1)) break block35;
                        Logger.error(e);
                    }
                }
                int matches = 0;
                if (tagClasses != null) {
                    for (Object cn : this.classNames) {
                        if (!tagClasses.contains(cn)) continue;
                        ++matches;
                    }
                }
                if (matches < this.classNames.size()) {
                    return false;
                }
                somethingMatched = true;
            }
            if (this.attrib != null) {
                Object attObj;
                String att = null;
                if (node.isDefined(this.attrib)) {
                    if ("".equals(node.getAttribute(this.attrib))) {
                        return false;
                    }
                    attObj = node.getAttribute(this.attrib);
                    if (attObj == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                att = attObj.toString();
                somethingMatched = true;
                if (this.attribValue != null) {
                    boolean matched = false;
                    switch (this.eqType) {
                        case 1: {
                            matched = this.attribValue == att;
                            break;
                        }
                        case 2: {
                            if (att == this.attribValue) {
                                matched = true;
                                break;
                            }
                            matched = this.find(att, this.attribValue);
                            break;
                        }
                        case 3: {
                            if (att == this.attribValue) {
                                matched = true;
                                break;
                            }
                            if (!att.startsWith(this.attribValue)) break;
                            if (att.length() == this.attribValue.length()) {
                                matched = true;
                                break;
                            }
                            if (att.charAt(this.attribValue.length()) != '-') break;
                            matched = true;
                        }
                    }
                    if (!matched) {
                        return false;
                    }
                }
            }
            return somethingMatched;
        }

        private boolean find(String line, String toFind) {
            if (line == null || toFind == null || line.length() < toFind.length()) {
                return false;
            }
            int start = line.indexOf(toFind);
            if (start < 0) {
                return false;
            }
            if (start > 0 && line.charAt(start - 1) != ' ') {
                return false;
            }
            return start + toFind.length() >= line.length() || line.charAt(start + toFind.length()) == ' ';
        }

        private HTML.Tag getMatchedTag() {
            if (this.isTagOnly && this.tagName instanceof HTML.Tag) {
                return (HTML.Tag)((Object)this.tagName);
            }
            return null;
        }

        private boolean isUnversalTagOnly() {
            return this.isTagOnly && this.isUniversal;
        }
    }

    private static class Comparator
    implements java.util.Comparator<Selector> {
        private Comparator() {
        }

        @Override
        public int compare(Selector o1, Selector o2) {
            int levelO2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int levelO1 = o1.getLevelTotal();
            if (levelO1 != (levelO2 = o2.getLevelTotal())) {
                return levelO2 - levelO1;
            }
            return o2.getIndex() - o1.getIndex();
        }
    }

    static enum PSEUDO_CLASS {
        active("active"),
        hover("hover"),
        link("link"),
        firstChild("first-child"),
        lastChild("last-child");

        private String matchString;

        private PSEUDO_CLASS(String matchString) {
            this.matchString = matchString;
            pseudoClasses.put(matchString, this);
        }

        public String toString() {
            return this.matchString;
        }

        public static PSEUDO_CLASS get(String className) {
            return (PSEUDO_CLASS)((Object)pseudoClasses.get(className.toLowerCase()));
        }
    }
}

