/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.parser.ParserDelegator;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.ImageInliner;
import com.inet.html.utils.Logger;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlConverter {
    private static Pattern linePattern = Pattern.compile("^(-{3,}|_{3,})$");

    public static String text2html(String plainText, Font font) {
        return HtmlConverter.text2html(plainText, font, false, null);
    }

    public static String text2html(String plainText, Font font, boolean startWithP) {
        return HtmlConverter.text2html(plainText, font, startWithP, null);
    }

    public static String text2html(String plainText, Font font, boolean startWithP, String defaultClass) {
        if (plainText == null) {
            return null;
        }
        StringBuffer text = new StringBuffer();
        if (font != null) {
            text.append("<head><style>body{font-family:").append(font.getName()).append("; font-size:").append(font.getSize()).append("pt;}</style></head><body>");
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(plainText));
            boolean isFirstline = true;
            boolean wasBlankLine = false;
            boolean wasParagraph = false;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.length() == 1 && line.charAt(0) == '\u00a0') {
                    if (isFirstline) {
                        if (startWithP) {
                            text.append(HtmlConverter.getElement("p", defaultClass) + "&nbsp;</p>");
                            wasParagraph = true;
                        } else {
                            text.append("<br>");
                            wasParagraph = false;
                        }
                    } else if (wasParagraph) {
                        if (!wasBlankLine) {
                            text.append("</p>" + HtmlConverter.getElement("p", defaultClass) + "&nbsp;</p>");
                        } else {
                            text.append(HtmlConverter.getElement("p", defaultClass) + "&nbsp;</p>");
                        }
                    } else {
                        text.append(HtmlConverter.getElement("p", defaultClass) + "&nbsp;</p>");
                    }
                    wasBlankLine = true;
                    isFirstline = false;
                    continue;
                }
                if (linePattern.matcher(line).matches()) {
                    if (wasParagraph) {
                        if (wasBlankLine) {
                            text.append(HtmlConverter.getElement("hr", defaultClass));
                        } else {
                            text.append("</p>" + HtmlConverter.getElement("hr", defaultClass));
                        }
                        wasBlankLine = true;
                        continue;
                    }
                    text.append(HtmlConverter.getElement("hr", defaultClass));
                    wasBlankLine = true;
                    continue;
                }
                if (isFirstline) {
                    if (startWithP) {
                        text.append(HtmlConverter.getElement("p", defaultClass));
                        wasParagraph = true;
                    } else {
                        wasParagraph = false;
                    }
                    isFirstline = false;
                } else {
                    if (wasBlankLine) {
                        if (wasParagraph) {
                            text.append(HtmlConverter.getElement("p", defaultClass));
                        }
                    } else {
                        text.append("<br>");
                    }
                    wasBlankLine = false;
                }
                block12: for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    int next = i + 1 < line.length() ? (int)line.charAt(i + 1) : 65535;
                    switch (c) {
                        case '\"': {
                            text.append("&quot;");
                            continue block12;
                        }
                        case '<': {
                            text.append("&lt;");
                            continue block12;
                        }
                        case '>': {
                            text.append("&gt;");
                            continue block12;
                        }
                        case '&': {
                            text.append("&amp;");
                            continue block12;
                        }
                        case '\u00a0': {
                            text.append("&nbsp;");
                            continue block12;
                        }
                        case '\t': {
                            text.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        }
                        case ' ': {
                            if (next == 32 || next == 9 || next == 160) {
                                text.append("&nbsp;");
                                continue block12;
                            }
                            text.append(' ');
                            continue block12;
                        }
                        default: {
                            text.append(c);
                        }
                    }
                }
            }
            if (wasParagraph && !wasBlankLine) {
                text.append("</p>");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        if (font != null) {
            text.append("</body>");
        }
        return text.toString();
    }

    private static String getElement(String name, String cssClass) {
        return "<" + name + (cssClass != null ? " class=\"" + cssClass + "\">" : ">");
    }

    public static String html2text(String htmlText) {
        return HtmlConverter.html2text(htmlText, -1).content;
    }

    public static ConvertResult html2text(String htmlText, int maxLength) {
        if (htmlText == null) {
            return new ConvertResult("", true);
        }
        StringReader htmlReader = new StringReader(htmlText);
        ParserCallback callback = new ParserCallback(maxLength);
        try {
            new ParserDelegator().parse(htmlReader, callback, true);
        }
        catch (IOException e) {
            Logger.error(e);
        }
        catch (ErrorInHeadException e) {
            callback = new ParserCallback(maxLength);
            Pattern bodyStart = Pattern.compile("<\\s*body(\\s+|>)", 10);
            Matcher m = bodyStart.matcher(htmlText);
            if (m.find()) {
                int bodyPos = m.start();
                htmlText = htmlText.substring(bodyPos);
            }
            callback.setIgnoreErrorsInHead();
            htmlReader = new StringReader(htmlText);
            try {
                new ParserDelegator().parse(htmlReader, callback, true);
            }
            catch (IOException e2) {
                Logger.error(e);
            }
        }
        return new ConvertResult(callback.text.toString(), !callback.wasInterrupted);
    }

    @Nonnull
    public static String html2inlinedHtml(String htmlText) {
        return HtmlConverter.html2inlinedHtml(htmlText, true);
    }

    @Nonnull
    public static String html2inlinedHtml(String htmlText, boolean inlineImages) {
        return HtmlConverter.html2inlinedHtml(htmlText, inlineImages, null);
    }

    @Nonnull
    public static String html2inlinedHtml(String htmlText, boolean inlineImages, URL baseURL) {
        return HtmlConverter.html2inlinedHtml(htmlText, inlineImages, false, baseURL);
    }

    @Nonnull
    public static String html2inlinedHtml(String htmlText, boolean inlineImages, boolean contentOnly, URL baseURL) {
        return HtmlConverter.html2inlinedHtml(htmlText, inlineImages, contentOnly, false, baseURL);
    }

    @Nonnull
    public static String html2inlinedHtml(String htmlText, boolean inlineImages, boolean contentOnly, boolean compact, URL baseURL) {
        InetHtmlWriter writer;
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            if (baseURL != null) {
                doc.putProperty("stream", baseURL);
            }
            doc.parse(new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        if (inlineImages) {
            ImageInliner inliner = new ImageInliner();
            inliner.inlineImages(doc);
        }
        StringWriter out = new StringWriter();
        if (compact) {
            doc.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, 0);
            doc.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        }
        if (contentOnly) {
            Element element = ElementUtils.getBodyElement(doc);
            writer = new InetHtmlWriter((Writer)out, element);
            writer.setWriteSelectedElementOnly(true);
        } else {
            writer = new InetHtmlWriter((Writer)out, doc, 0, doc.getLength());
        }
        writer.setInlineMode(true);
        writer.setStyleContainer(HTML.Tag.SPAN);
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return out.toString();
    }

    @Nonnull
    public static String getCompactHtmlText(String htmlText, Map<String, String> imageMap) {
        return HtmlConverter.getCompactHtmlText(htmlText, imageMap, null);
    }

    @Nonnull
    public static String getCompactHtmlText(String htmlText, Map<String, String> imageMap, Map<HTML.Tag, Boolean> tagWritingOptions) {
        return HtmlConverter.getCompactHtmlText(htmlText, imageMap, tagWritingOptions, false);
    }

    @Nonnull
    public static String getCompactHtmlText(String htmlText, Map<String, String> imageMap, Map<HTML.Tag, Boolean> tagWritingOptions, boolean trustedImagePath) {
        return HtmlConverter.getCompactHtmlText(htmlText, imageMap, null, tagWritingOptions, trustedImagePath);
    }

    @Nonnull
    public static String getCompactHtmlText(String htmlText, Map<String, String> imageMap, Map<String, String> hrefMap, Map<HTML.Tag, Boolean> tagWritingOptions, boolean trustedImagePath) {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            doc.parse(new StringReader(htmlText), 0);
            return HtmlConverter.getCompactHtmlText(doc, imageMap, hrefMap, tagWritingOptions, trustedImagePath);
        }
        catch (Exception e) {
            if (Logger.doesLog(1)) {
                Logger.error(e);
            }
            return htmlText;
        }
    }

    public static String getCompactHtmlText(InetHtmlDocument doc, Map<String, String> imageMap) throws BadLocationException {
        return HtmlConverter.getCompactHtmlText(doc, imageMap, null);
    }

    public static String getCompactHtmlText(InetHtmlDocument doc, Map<String, String> imageMap, Map<HTML.Tag, Boolean> tagWritingOptions) throws BadLocationException {
        return HtmlConverter.getCompactHtmlText(doc, imageMap, tagWritingOptions, false);
    }

    public static String getCompactHtmlText(InetHtmlDocument doc, Map<String, String> imageMap, Map<HTML.Tag, Boolean> tagWritingOptions, boolean trustedImagePath) throws BadLocationException {
        return HtmlConverter.getCompactHtmlText(doc, imageMap, null, tagWritingOptions, trustedImagePath);
    }

    @Nonnull
    public static String getCompactHtmlText(InetHtmlDocument doc, Map<String, String> imageMap, Map<String, String> hrefMap, Map<HTML.Tag, Boolean> tagWritingOptions, boolean trustedImagePath) throws BadLocationException {
        Object backupIndent = doc.getProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE);
        doc.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, 0);
        doc.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        StringWriter out = new StringWriter();
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, doc, 0, doc.getModelLength());
        writer.setTagWritingOptions(tagWritingOptions);
        writer.registerImageSRCreplace(imageMap);
        writer.registerLinkHREFreplace(hrefMap);
        writer.setTrustedImagePath(trustedImagePath);
        try {
            writer.write();
        }
        catch (IOException e) {
            Logger.error(e);
        }
        if (backupIndent != null) {
            doc.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, backupIndent);
        }
        return out.toString();
    }

    public static String getInlinedHtml(String htmlText) {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            doc.parse(new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        StringWriter out = new StringWriter();
        Element element = ElementUtils.getBodyElement(doc);
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, element);
        writer.setAllowStyleSpan(false);
        writer.setInlineMode(true);
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return out.toString();
    }

    public static class ConvertResult {
        private String content;
        private boolean isComplete;

        private ConvertResult(String content, boolean isComplete) {
            this.content = content;
            this.isComplete = isComplete;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public String getContent() {
            return this.content;
        }
    }

    private static class ParserCallback
    extends HTMLEditorKit.ParserCallback {
        private final StringBuffer text = new StringBuffer();
        private boolean dontWrite;
        private boolean nbspPending = false;
        private boolean recentBlockClose = false;
        private boolean recentBlockOpen = false;
        private boolean multiLineCell = false;
        private int cellCount = 0;
        private int bodyPos = -1;
        private boolean impliedBody = false;
        private int maxLength;
        private boolean wasInterrupted = false;
        private boolean ignoreErrorsInHead;

        public ParserCallback(int maxLength) {
            this.maxLength = maxLength;
        }

        public void setIgnoreErrorsInHead() {
            this.ignoreErrorsInHead = true;
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (!this.dontWrite) {
                if (this.nbspPending) {
                    this.text.append(' ');
                    this.nbspPending = false;
                }
                if (data != null && data.length == 1 && data[0] == '\u00a0' && this.recentBlockOpen) {
                    this.nbspPending = true;
                } else {
                    if (data != null && data.length > 0) {
                        for (int i = 0; i < data.length; ++i) {
                            if (data[i] != '\u00a0') continue;
                            data[i] = 32;
                        }
                    }
                    if (this.maxLength <= 0) {
                        this.text.append(data);
                    } else {
                        if (this.text.length() + data.length > this.maxLength) {
                            if (this.text.length() < this.maxLength) {
                                this.text.append(data, 0, this.maxLength - this.text.length());
                            }
                            this.wasInterrupted = true;
                            throw new InterruptParserException();
                        }
                        this.text.append(data);
                    }
                }
            }
            this.recentBlockOpen = false;
            this.recentBlockClose = false;
        }

        @Override
        public void handleError(String errorMsg, int pos) {
            if (errorMsg == null) {
                return;
            }
            String[] parts = errorMsg.split("\\s");
            if (parts.length < 2) {
                return;
            }
            if ("tag.ignore".equals(parts[0]) && !this.ignoreErrorsInHead && this.impliedBody) {
                throw new ErrorInHeadException();
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.BODY) {
                this.impliedBody = a != null && Boolean.TRUE.equals(a.getAttribute(HTMLEditorKit.ParserCallback.IMPLIED));
                this.bodyPos = pos;
                this.recentBlockOpen = true;
            }
            if (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI || t == HTML.Tag.PRE || t == HTML.Tag.UL || t == HTML.Tag.BLOCKQUOTE) {
                if (!this.recentBlockClose && !this.recentBlockOpen && pos > this.bodyPos) {
                    this.text.append('\n');
                }
                this.recentBlockOpen = true;
            }
            if (t == HTML.Tag.LI && !this.dontWrite) {
                this.text.append("* ");
            }
            if (t == HTML.Tag.TABLE && !this.recentBlockOpen && pos > this.bodyPos) {
                this.text.append('\n');
            } else if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                this.dontWrite = true;
            } else if (t == HTML.Tag.TD || t == HTML.Tag.TH) {
                ++this.cellCount;
            }
            this.recentBlockClose = false;
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            boolean rbc_buffer = this.recentBlockClose;
            if (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.TD || t == HTML.Tag.TH || t == HTML.Tag.LI || t == HTML.Tag.PRE || t == HTML.Tag.UL || t == HTML.Tag.BLOCKQUOTE) {
                this.nbspPending = false;
                rbc_buffer = true;
                this.recentBlockOpen = false;
            }
            if (t == HTML.Tag.BODY || t == HTML.Tag.HTML) {
                return;
            }
            if (!(t != HTML.Tag.TR && t != HTML.Tag.CAPTION || this.text.length() != 0 && this.text.charAt(this.text.length() - 1) == '\n')) {
                this.text.append('\n');
            }
            if (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI) {
                if (!this.recentBlockClose) {
                    this.text.append('\n');
                }
            } else if (t == HTML.Tag.TD || t == HTML.Tag.TH) {
                if (this.multiLineCell) {
                    this.text.append('\n');
                } else {
                    this.text.append(' ');
                }
                this.multiLineCell = false;
                --this.cellCount;
            } else if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                this.dontWrite = false;
            } else if (t == HTML.Tag.TABLE && this.cellCount > 0) {
                this.multiLineCell = true;
            }
            this.recentBlockClose = rbc_buffer;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.HR) {
                try {
                    char lastChar;
                    int len = this.text.length();
                    if (len > 0 && (lastChar = this.text.charAt(len - 1)) != '\n') {
                        this.text.append('\n');
                    }
                    this.text.append("________________________________\n");
                }
                catch (Exception e) {
                    if (Logger.doesLog(2)) {
                        Logger.warning(e.getMessage());
                    }
                }
            } else if (t == HTML.Tag.BR) {
                this.text.append('\n');
                if (this.cellCount > 0) {
                    this.multiLineCell = true;
                }
            }
            if (this.maxLength > 0 && this.text.length() > this.maxLength) {
                this.wasInterrupted = true;
                throw new InterruptParserException();
            }
            this.recentBlockOpen = false;
            this.recentBlockClose = false;
        }
    }

    private static class ErrorInHeadException
    extends Error {
        private ErrorInHeadException() {
        }
    }

    private static class InterruptParserException
    extends RuntimeException {
        private InterruptParserException() {
        }

        @Override
        public void printStackTrace() {
        }
    }
}

