/*
 * Decompiled with CFR 0.152.
 */
package com.inet.hosting;

import com.inet.authentication.MasterLoginData;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.hosting.users.a;
import com.inet.maintenance.api.MaintenanceExtension;
import com.inet.maintenance.api.backup.ConfigurationBackupVeto;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.WebAPIAccessProvider;
import com.inet.taskplanner.server.api.ui.TaskOwnerFilter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletRequestListener;
import javax.annotation.Nonnull;

@PluginInfo(id="hosting", version="25.10.259", group="system", dependencies="maintenance;remotegui", optionalDependencies="taskplanner;webapi.core", packages="", external="", internal="", initAfter="", icon="", flags="core")
public class HostingServerPlugin
implements ServerPlugin {
    public static final I18nMessages MSG = new I18nMessages("com.inet.hosting.structure.i18n.ConfigStructure", HostingServerPlugin.class);

    public void registerHelp(HelpProviderContainer container) {
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(ConfigStructureProvider.class, (Object)new com.inet.hosting.structure.a());
        spm.register(UserEventListener.class, (Object)new a());
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                spm.register(TaskOwnerFilter.class, (Object)new com.inet.hosting.taskplanner.a());
            }
        });
        spm.register(ConfigurationBackupVeto.class, (Object)new com.inet.hosting.maintenance.a());
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                com.inet.hosting.webapi.a a2 = new com.inet.hosting.webapi.a();
                spm.register(ServletRequestListener.class, (Object)a2);
                spm.register(WebAPIAccessProvider.class, (Object)a2);
            }
        });
    }

    public void init(ServerPluginManager spm) {
        MasterLoginData.getLoginData();
        com.inet.hosting.a.a();
        this.a(spm, "backup");
        this.a(spm, "programdata");
        this.a(spm, "dbmigration");
        com.inet.hosting.service.a.a("/store", "store.sideload");
    }

    private void a(@Nonnull ServerPluginManager serverPluginManager, @Nonnull String string) {
        MaintenanceExtension maintenanceExtension2 = serverPluginManager.get(MaintenanceExtension.class).stream().filter(maintenanceExtension -> string.equals(maintenanceExtension.getId())).findFirst().orElse(null);
        if (maintenanceExtension2 != null) {
            maintenanceExtension2.setIsActive(() -> {
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                if (userAccount == null) {
                    return Boolean.FALSE;
                }
                UserAccountType userAccountType = userAccount.getAccountType();
                if (UserAccountType.Administrator.equals((Object)userAccountType)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
        }
    }

    public void reset() {
    }

    public void restart() {
    }
}

