/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.migrators.workflow;

import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.plugins.setupwizard.HelpDeskSetupWizardPlugin;
import com.inet.helpdesk.plugins.setupwizard.steps.c;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoType;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class a
extends AutoSetupStep
implements ServerPluginManagerListener {
    public static final StepKey i = new StepKey("workflowmigration");
    private DatabaseConnectionFactory t;

    public a(DatabaseConnectionFactory databaseConnectionFactory) {
        this.t = databaseConnectionFactory;
    }

    public StepKey stepKey() {
        return i;
    }

    public String getStepDisplayName() {
        return HelpDeskSetupWizardPlugin.MSG.getMsg("migration.workflow.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("24.4.87");
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        String string = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        DatabaseConfigInfoList databaseConfigInfoList = (DatabaseConfigInfoList)new Json().fromJson(string, DatabaseConfigInfoList.class);
        DatabaseConfigInfo databaseConfigInfo = databaseConfigInfoList.get("HDS");
        try (Connection connection = this.t.getConnectionFromCurrentConfiguration();
             Statement statement = connection.createStatement();){
            StatusVO statusVO;
            Object object;
            LoaderUtils.classForName((String)databaseConfigInfo.getDriverClassName(), (Object)((Object)this));
            boolean bl = false;
            try (ResultSet resultSet = connection.getMetaData().getTables(databaseConfigInfo.getCatalogForConnection(), DatabaseConfigInfo.DatabaseType.inetora.equals((Object)databaseConfigInfo.getDriver()) ? databaseConfigInfo.getUser().toUpperCase() : null, "tblWFaktiv", new String[]{"TABLE"});){
                if (resultSet.next()) {
                    bl = true;
                }
            }
            if (bl) {
                resultSet = statement.executeQuery("Select * from tblWFaktiv ORDER BY HauptAuftrag");
                try {
                    String string2;
                    object = null;
                    boolean bl2 = false;
                    while (resultSet.next()) {
                        int n = resultSet.getInt("HauptAuftrag");
                        string2 = resultSet.getString("WFName");
                        if (object == null || object.intValue() != n) {
                            object = n;
                            this.a(n, string2);
                            bl2 = true;
                        }
                        int n2 = resultSet.getInt("TeilAuftrag");
                        this.a(n2, (Integer)object, resultSet.getInt("Ende1"), resultSet.getInt("Ende2"), string2);
                    }
                    if (bl2) {
                        StepExecutionWarnings.get().info(() -> HelpDeskSetupWizardPlugin.MSG.getMsg("migration.workflow.info", new Object[0]));
                        Persistence persistence = Persistence.getInstance();
                        string2 = persistence.resolve("setup_workflowmigration_createWFView");
                        string2.setString("create");
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            if ((object = (ActionVO)(resultSet = ActionManager.getInstance()).get(-8)) != null && !object.isDeleted()) {
                resultSet.update(new ActionVO(object.getId(), object.getDisplayValue(), object.getStatusID(), object.isInternal(), object.getBillingType(), object.getLumpSumType(), object.getFixedCharge(), true, object.getSpecial(), object.isHidden()));
            }
            if ((object = (ActionVO)resultSet.get(-20)) != null && !object.isDeleted()) {
                resultSet.update(new ActionVO(object.getId(), object.getDisplayValue(), object.getStatusID(), object.isInternal(), object.getBillingType(), object.getLumpSumType(), object.getFixedCharge(), true, object.getSpecial(), object.isHidden()));
            }
            if ((statusVO = (StatusVO)StatusManager.getInstance().get(-217)) != null && !statusVO.isDeleted()) {
                StatusManager.getInstance().update((FieldVO)new StatusVO(statusVO.getId(), statusVO.getDisplayValue(), statusVO.getImageName(), true, statusVO.isInternal()));
            }
        }
        catch (ClassNotFoundException | SQLException exception) {
            throw new StepExecutionException((Throwable)exception);
        }
    }

    private void H() {
        SetupLogger.LOGGER.info((Object)"[Workflow] Create View for old workflows");
        String string = "Zeigt Tickets von alten Workflows, die noch abgearbeitet werden m\u00fcssen. Workflows werden durch Prozesse ersetzt. Diese View kann gel\u00f6scht werden, sobald keine entsprechenden Tickets mehr vorhanden sind.";
        String string2 = Tickets.FIELD_SUBJECT.getKey();
        String string3 = "opentickets|" + string2 + ":\"WF\" " + string2 + ":\"Haupt\" OR " + string2 + ":\"Nr\"";
        CustomTicketViewDefinition customTicketViewDefinition = CustomTicketViewDefinition.createGlobalView((String)string3, null, List.of(HDUsersAndGroups.GROUPID_SUPPORTERS), (String)GUID.generateNew().toString(), (String)"Alte Workflows", (String)string);
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            TicketViewManager.getInstance().putView(customTicketViewDefinition);
        }
    }

    private void a(int n, Integer n2, int n3, int n4, String string) {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            TicketVO ticketVO = TicketManager.getReader().getTicket(n);
            MutableTicketData mutableTicketData = MutableTicketData.ofSingle((TicketField)Tickets.FIELD_SUBJECT, (Object)("WF-Nr.: " + n2 + " " + ticketVO.getSubject()));
            mutableTicketData.put((TicketField)Tickets.FIELD_OWNER_GUID, null);
            TicketManager.getManipulator().performManipulation(ticketOperationModel -> TicketManager.extending().getTicketInnerOperations().updateTicketData(ticketOperationModel.changeExistingTicket(n), mutableTicketData));
            if (!Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID()) && !ticketVO.isSlaveInBundle()) {
                if (ticketVO.getStatusID() == -217) {
                    String string2 = n4 == 0 ? String.format("nach dem Teilschritt %d", n3) : String.format("nach den Teilschritten %d und %d", n3, n4);
                    String string3 = String.format("Dies ist ein Teilschritt vom ehemaligen Workflow '%s'. Workflows werden ab Version 24.4. durch Prozesse ersetzt. Die bisherigen Workflow-Automatismen greifen nicht mehr. \n\nDas Hauptticket zu diesen Workflow war Nr. %d und wurde verlinkt. Dieses Ticket wurde aktiviert, muss nach dem urspr\u00fcnglichen Workflow aber erst %s bearbeitet werden. Dieses Ticket kann normal beendet werden.", string, n2, string2);
                    TicketManager.getManipulator().performManipulation(ticketOperationModel -> TicketManager.extending().getTicketInnerOperations().applyAction(ticketOperationModel.changeExistingTicket(n), new MutableReaStepData(), ReaStepTextVO.of((String)string3, (boolean)false), (ActionVO)ActionManager.getInstance().get(5), ExtensionArguments.create()));
                } else {
                    String string4 = String.format("Dies ist ein Teilschritt vom ehemaligen Workflow '%s'. Workflows werden ab Version 24.4. durch Prozesse ersetzt. Die bisherigen Workflow-Automatismen greifen nicht mehr. \n\nDas Hauptticket zu diesen Workflow war Nr. %d und wurde verlinkt. Dieses Ticket kann normal beendet werden.", string, n2);
                    TicketManager.getManipulator().applyAction(n, new MutableReaStepData(), ReaStepTextVO.of((String)string4, (boolean)false), ((ActionVO)ActionManager.getInstance().get(-12)).copyActionWithChangedStatusAndSpecialFlag(-100, 0), ExtensionArguments.create());
                }
            }
            TicketManager.getTicketLinking().addBidirectionalLinkBetween(n, n2.intValue());
        }
    }

    private void a(int n, String string) {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            TicketVO ticketVO = TicketManager.getReader().getTicket(n);
            if (Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID())) {
                return;
            }
            if (ticketVO.isSlaveInBundle()) {
                return;
            }
            TicketManager.getManipulator().updateTicketData(n, MutableTicketData.ofSingle((TicketField)Tickets.FIELD_SUBJECT, (Object)("WF-Haupt: " + ticketVO.getSubject())));
            String string2 = String.format("Dies ist das Hauptticket vom ehemaligen Workflow '%s'. Workflows werden ab Version 24.4. durch Prozesse ersetzt. Die bisherigen Workflow-Automatismen greifen nicht mehr. \n\nAlle zu diesem Workflow geh\u00f6renden Tickets wurden verlinkt. Alle zu diesen Workflow geh\u00f6renden Teilschritte wurden sichtbar gestellt und k\u00f6nnen normal beendet werden. Dieses Ticket muss manuell beendet werden, wenn die Teilschritte erledigt sind. Ebenso m\u00fcssen die Teilschritte manuell beendet werden, wenn das Hauptticket (dieses Ticket) beendet wird.", string);
            TicketManager.getManipulator().applyAction(n, new MutableReaStepData(), ReaStepTextVO.of((String)string2, (boolean)false), ((ActionVO)ActionManager.getInstance().get(-12)).copyActionWithChangedStatusAndSpecialFlag(-100, 0), ExtensionArguments.create());
        }
    }

    public SetupStepPriority getPriority() {
        return c.bs;
    }

    public InfoMessageGetter a(EmptyStepConfig emptyStepConfig) {
        return () -> HelpDeskSetupWizardPlugin.MSG.getMsg("migration.workflow.executionMessage", new Object[0]);
    }

    public void vetoFinished(@Nullable VetoType type) {
        Persistence persistence;
        PersistenceEntry persistenceEntry;
        if (type == TicketManagerVetoPower.TYPE && (persistenceEntry = (persistence = Persistence.getInstance()).resolve("setup_workflowmigration_createWFView")).exists()) {
            persistenceEntry.deleteValue();
            this.H();
        }
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.a((EmptyStepConfig)stepConfiguration);
    }
}

