/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.migrators.stopwatch;

import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.stopwatch.ConditionType;
import com.inet.helpdesk.config.stopwatch.StopWatchCondition;
import com.inet.helpdesk.config.stopwatch.StopWatchList;
import com.inet.helpdesk.config.stopwatch.StopWatchRule;
import com.inet.helpdesk.config.stopwatch.StopWatchSetting;
import com.inet.helpdesk.plugins.setupwizard.HelpDeskSetupWizardPlugin;
import com.inet.helpdesk.plugins.setupwizard.steps.c;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.json.Json;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.Map;
import javax.annotation.Nullable;

public class a
extends AutoSetupStep {
    public static final StepKey i = new StepKey("StopWatchSettings");

    public StepKey stepKey() {
        return i;
    }

    public String getStepDisplayName() {
        return HelpDeskSetupWizardPlugin.MSG.getMsg("stopWatchMigration.displayname", new Object[0]);
    }

    public InfoMessageGetter a(EmptyStepConfig emptyStepConfig) {
        return () -> this.getStepDisplayName();
    }

    public boolean hasPendingTasks() {
        return true;
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("24.4");
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        StopWatchList stopWatchList = (StopWatchList)new Json().fromJson(ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.STOP_WATCH_RULES), StopWatchList.class);
        boolean bl = true;
        for (UserGroupInfo userGroupInfo : userGroupManager.getGroups(HDUsersAndGroups.RESOURCE)) {
            Integer n = (Integer)userGroupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS);
            if (n != null) {
                if ((n & 8) > 0) {
                    stopWatchList.add((Object)new StopWatchRule(new StopWatchCondition(ConditionType.TicketIsInResource, userGroupInfo.getID()), StopWatchSetting.AUTOMATIC));
                    SetupLogger.LOGGER.info((Object)String.format("[StopWatch] Resource %s is AUTO", userGroupInfo.getDisplayName()));
                } else if ((n & 0x10) > 0) {
                    stopWatchList.add((Object)new StopWatchRule(new StopWatchCondition(ConditionType.TicketIsInResource, userGroupInfo.getID()), StopWatchSetting.MANUALLY));
                    SetupLogger.LOGGER.info((Object)String.format("[StopWatch] Resource %s is MANUALLY", userGroupInfo.getDisplayName()));
                } else {
                    SetupLogger.LOGGER.info((Object)String.format("[StopWatch] Resource %s is OFF", userGroupInfo.getDisplayName()));
                }
                if ((n & 0x20) > 0) {
                    bl = false;
                }
                MutableUserGroupData mutableUserGroupData = new MutableUserGroupData();
                mutableUserGroupData.put((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS, (Object)(n & 0xFFFFFFF7 & 0xFFFFFFEF & 0xFFFFFFDF));
                userGroupManager.updateGroupData(userGroupInfo.getID(), mutableUserGroupData);
                continue;
            }
            SetupLogger.LOGGER.info((Object)String.format("[StopWatch] Resource %s has no setting", userGroupInfo.getDisplayName()));
        }
        if (stopWatchList.size() == userGroupManager.getGroups(HDUsersAndGroups.RESOURCE).size()) {
            if (stopWatchList.stream().allMatch(stopWatchRule -> stopWatchRule.getSetting() == StopWatchSetting.AUTOMATIC)) {
                stopWatchList.clear();
                SetupLogger.LOGGER.info((Object)String.format("[StopWatch] All Resources are AUTO", new Object[0]));
                ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.STOP_WATCH_STANDARD, StopWatchSetting.AUTOMATIC.name());
            } else if (stopWatchList.stream().allMatch(stopWatchRule -> stopWatchRule.getSetting() == StopWatchSetting.MANUALLY)) {
                stopWatchList.clear();
                SetupLogger.LOGGER.info((Object)String.format("[StopWatch] All Resources are MANUALLY", new Object[0]));
                ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.STOP_WATCH_STANDARD, StopWatchSetting.MANUALLY.name());
            }
        }
        if (!stopWatchList.isEmpty()) {
            ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.STOP_WATCH_RULES, new Json().toJson((Object)stopWatchList));
        }
        if (bl) {
            ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.STOP_WATCH_START_THRESHOLD, "0");
        }
    }

    public SetupStepPriority getPriority() {
        return c.bu;
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.a((EmptyStepConfig)stepConfiguration);
    }
}

