/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.api;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.plugins.setupwizard.api.HelpDeskSetupMode;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.shared.utils.Version;
import java.util.Map;
import javax.annotation.Nullable;

@InternalApi
public class HelpDeskSetupModeChecker {
    public static final ConfigValue<Map<String, String>> LAST_MIGRATED_PLUGIN_VERSIONS = new ConfigValue<Map<String, String>>(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS){

        protected void setValue(String strValue) throws IllegalArgumentException {
            if (strValue == null) {
                strValue = "{}";
            }
            super.setValue(strValue);
        }
    };
    private static HelpDeskSetupMode h;

    public static HelpDeskSetupMode modeOfTheLastCheck() {
        return h;
    }

    public static boolean isModeOfTheLastCheck(HelpDeskSetupMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        return mode.equals((Object)h);
    }

    public void checkMode() {
        switch (this.c()) {
            case 1: {
                this.a(HelpDeskSetupMode.NOTHING);
                break;
            }
            case 2: {
                this.a(HelpDeskSetupMode.UPDATE_FROM_VERSION_8_OR_ABOVE);
                break;
            }
            case 3: {
                this.a(HelpDeskSetupMode.NEW_INSTALLATION);
            }
        }
    }

    private byte c() {
        try {
            String string = (String)((Map)LAST_MIGRATED_PLUGIN_VERSIONS.get()).get("helpdesk");
            if (string == null) {
                return 3;
            }
            Version version = ServerPluginManager.getInstance().getPluginDescription("helpdesk").getVersion();
            if (new Version(string).isHigherOrEquals(version)) {
                return 1;
            }
            SetupLogger.LOGGER.info((Object)String.format("[Mode] Currently migrated HD version is %s", string.toString()));
            return 2;
        }
        catch (NullPointerException nullPointerException) {
            Map map = (Map)LAST_MIGRATED_PLUGIN_VERSIONS.get();
            String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS);
            throw new IllegalStateException("Value of ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS:" + string + " == " + String.valueOf(map), nullPointerException);
        }
    }

    private void a(HelpDeskSetupMode helpDeskSetupMode) {
        SetupLogger.LOGGER.info((Object)("[Mode] Setting mode to " + helpDeskSetupMode.name()));
        h = helpDeskSetupMode;
    }

    @Nullable
    public static Version getLastMigratedHelpdeskVersion() {
        String string = (String)((Map)LAST_MIGRATED_PLUGIN_VERSIONS.get()).get("helpdesk");
        return string == null ? null : new Version(string);
    }

    public static Version getCurrentHelpdeskVersion() {
        return ServerPluginManager.getInstance().getPluginDescription("helpdesk").getVersion();
    }
}

