/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.helpdesk.plugins.setupwizard.api.HelpDeskSetupModeChecker;
import com.inet.helpdesk.plugins.setupwizard.api.ReIndexTicketsListener;
import com.inet.helpdesk.plugins.setupwizard.migrators.reports.e;
import com.inet.helpdesk.plugins.setupwizard.steps.d;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.c;
import com.inet.helpdesk.plugins.setupwizard.steps.initupdate.a;
import com.inet.helpdesk.plugins.setupwizard.steps.initupdate.b;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoPower;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigChecker;
import com.inet.setupwizard.basicsteps.pam.PamExecutionListener;
import com.inet.setupwizard.basicsteps.pam.ShadowFileChecker;
import com.inet.setupwizard.basicsteps.plugins.PluginActivationInformation;
import com.inet.setupwizard.basicsteps.webserver.ProxyConnectionRecognizer;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataInConfigurationIO;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigurationUpdater;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepInitialConfigurationCreator;
import com.inet.shared.servlet.PortChecker;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.util.Map;

@PluginInfo(id="helpdesksetupwizard", version="25.10.259", dependencies="setupwizard;helpdesk;reporting;webserver;mail;htmlengine", optionalDependencies="remotegui;taskplanner;taskplanner.reporting;drive;adhoc;notification;attachments;maintenance;quickticket;pluginstore.client;fieldsettings;inventory", group="system", flags="core", initAfter="setupwizard", packages="com.inet.helpdesk.plugins.setupwizard.steps.database;com.inet.helpdesk.plugins.setupwizard.api")
public class HelpDeskSetupWizardPlugin
implements ServerPlugin {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.setupwizard.i18n.Translations", HelpDeskSetupWizardPlugin.class);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.helpdesk.plugins.setupwizard.steps.i18n.LanguageResources", HelpDeskSetupWizardPlugin.class);
    private ServerPluginManager a;
    public static final String PRODUCT_NAME_USED_IN_APACHE_CONFIG_FILE = "i-net-HelpDesk";
    private com.inet.helpdesk.plugins.setupwizard.migrators.autotext.a b = new com.inet.helpdesk.plugins.setupwizard.migrators.autotext.a();

    public HelpDeskSetupWizardPlugin() {
        if (SetupLogger.LOGGER.getLogLevel() < 3) {
            SetupLogger.LOGGER.setLogLevel(3);
        }
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new DatabaseVersionChecker.DVCMigrator());
    }

    public void registerExtension(final ServerPluginManager spm) {
        this.a = spm;
        if (SetupLogger.LOGGER.getLogLevel() < 3) {
            SetupLogger.LOGGER.setLogLevel(3);
        }
        PortChecker portChecker = new PortChecker();
        final HelpDeskSetupModeChecker helpDeskSetupModeChecker = new HelpDeskSetupModeChecker();
        final DatabaseConnectionFactory databaseConnectionFactory = new DatabaseConnectionFactory();
        spm.register(DatabaseConnectionFactory.class, (Object)databaseConnectionFactory);
        spm.register(SetupStepsExecutionListener.class, (Object)databaseConnectionFactory);
        spm.register(ConnectionCreationListener.class, (Object)databaseConnectionFactory);
        helpDeskSetupModeChecker.checkMode();
        WebServerStepInitialConfigurationCreator webServerStepInitialConfigurationCreator = new WebServerStepInitialConfigurationCreator(new ProxyConnectionRecognizer(), "helpdesk");
        WebServerStepConfigurationUpdater webServerStepConfigurationUpdater = new WebServerStepConfigurationUpdater(webServerStepInitialConfigurationCreator, (ProxySetupMetaDataReader)new ProxySetupMetaDataInConfigurationIO(), portChecker);
        c c2 = new c(databaseConnectionFactory);
        this.a(c2);
        com.inet.helpdesk.plugins.setupwizard.steps.database.b b2 = new com.inet.helpdesk.plugins.setupwizard.steps.database.b(c2);
        spm.register(VetoPower.class, (Object)b2);
        c2.a(b2);
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.webserver.a(portChecker, webServerStepConfigurationUpdater, (ProxySetupMetaDataReader)new ProxySetupMetaDataInConfigurationIO()));
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.license.a(new LicenseStepConfigChecker(){

            protected String getTrialWarning(long days) {
                return MSG.getMsg("license.trialLicenseWarning", new Object[]{days});
            }

            protected boolean isMissingLicenseAnError() {
                return true;
            }
        }));
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.tickets.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.resource.a(databaseConnectionFactory));
        this.a(new e());
        this.a(new com.inet.helpdesk.plugins.setupwizard.steps.initnewinstallation.c(databaseConnectionFactory));
        this.a(new b());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.updateproxy.c());
        this.a(new com.inet.helpdesk.plugins.setupwizard.steps.cleanup.a());
        this.a(new com.inet.helpdesk.plugins.setupwizard.steps.precondition.b(new com.inet.helpdesk.plugins.setupwizard.steps.precondition.a()));
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.configmigration.a());
        this.a((SetupStep<?>)this.b);
        if (spm.isPluginLoaded("attachments")) {
            new Runnable(){

                @Override
                public void run() {
                    HelpDeskSetupWizardPlugin.this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.attachments.embeddedcorrection.b(databaseConnectionFactory));
                }
            }.run();
        }
        this.a(new com.inet.helpdesk.plugins.setupwizard.steps.permissions.a());
        if (spm.isPluginLoaded("maintenance")) {
            new Runnable(){

                @Override
                public void run() {
                    spm.register(SetupStepsExecutionListener.class, (Object)new a());
                }
            }.run();
        }
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.iconinstallation.b());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.itil.a());
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.addMessages(MSG_CLIENT);
        CombinedFileDescription combinedFileDescription = new CombinedFileDescription("remotegui", "setupWizardCore.js", combinedFile);
        spm.register(CombinedFileDescription.class, (Object)combinedFileDescription);
        spm.register(SetupStepsExecutionListener.class, (Object)new PamExecutionListener(new ShadowFileChecker(), "helpdesk", "helpdesk"));
        spm.register(SetupStepsExecutionListener.class, (Object)new SetupStepsExecutionListener(){

            public void setupCompleted(boolean serverWillRestart) {
                helpDeskSetupModeChecker.checkMode();
            }
        });
        spm.register(SetupStepsExecutionListener.class, (Object)new ReIndexTicketsListener());
        spm.register(PluginActivationInformation.class, (Object)new com.inet.helpdesk.plugins.setupwizard.steps.plugin.a());
        spm.register(PluginActivationInformation.class, (Object)new com.inet.helpdesk.plugins.setupwizard.steps.plugin.b());
        spm.register(PluginActivationInformation.class, (Object)new com.inet.helpdesk.plugins.setupwizard.steps.plugin.c());
        if (spm.isPluginLoaded("fieldsettings")) {
            new Runnable(){

                @Override
                public void run() {
                    spm.register(SetupStep.class, (Object)new com.inet.helpdesk.plugins.setupwizard.migrators.fieldsettings.a(databaseConnectionFactory));
                    HelpDeskSetupWizardPlugin.this.a(new com.inet.helpdesk.plugins.setupwizard.migrators.ticketfields.b());
                }
            }.run();
        }
        this.a(new com.inet.helpdesk.plugins.setupwizard.migrators.actions.c());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.mail.b());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.ticketfields.a(databaseConnectionFactory));
        com.inet.helpdesk.plugins.setupwizard.migrators.workflow.a a2 = new com.inet.helpdesk.plugins.setupwizard.migrators.workflow.a(databaseConnectionFactory);
        this.a((SetupStep<?>)a2);
        spm.register(ServerPluginManagerListener.class, (Object)a2);
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.usergroup.b());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.usergroup.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.pgp.a(databaseConnectionFactory));
        this.a((SetupStep<?>)new d());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.stopwatch.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.addons.b());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.actions.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.permissions.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.tickets.b(databaseConnectionFactory));
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.steps.initupdate.d());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.mail.a());
        this.a((SetupStep<?>)new com.inet.helpdesk.plugins.setupwizard.migrators.fieldsettings.sqlselect.d(databaseConnectionFactory));
    }

    private void a(SetupStep<?> setupStep) {
        this.a.register(SetupStep.class, setupStep);
    }

    public void init(ServerPluginManager spm) {
        if (SetupLogger.LOGGER.getLogLevel() < 3) {
            SetupLogger.LOGGER.setLogLevel(3);
        }
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        SetupLogger.LOGGER.status((Object)String.format("Current configuration is %s/%s", ConfigurationManager.getScopeName((int)configuration.getScope()), configuration.getName()));
        this.b.a((AutoTextManager)spm.getSingleInstance(AutoTextManager.class));
    }

    public void reset() {
    }

    public void restart() {
    }

    public void uninstall(boolean isFullUninstall) {
        if (!isFullUninstall) {
            this.a();
        }
        new com.inet.helpdesk.plugins.setupwizard.uninstaller.a().at();
    }

    private void a() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        Version version = ServerPluginManager.getInstance().getPluginDescription("helpdesk").getVersion();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(version.getMajor());
        stringBuilder.append(".").append(version.getMinor());
        stringBuilder.append(".").append(version.getBuild() - 1);
        LogManager.getConfigLogger().info((Object)("[HelpdeskSetupWizard] Reduce the Version in the configuration to " + String.valueOf(stringBuilder)));
        String string = configuration.get(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS);
        Map map = (Map)new Json().fromJson(string, Map.class);
        map.put("helpdesk", stringBuilder.toString());
        configuration.put(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS.getKey(), new Json().toJson((Object)map));
    }
}

