/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.steps.database;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.StepExecutionException;
import java.sql.SQLException;
import java.util.Map;

@InternalApi
public abstract class PluginDatabaseStep
extends AutoSetupStep {
    public final boolean hasPendingTasks() {
        String string = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (string == null || string.isEmpty()) {
            return true;
        }
        DatabaseConfigInfoList databaseConfigInfoList = (DatabaseConfigInfoList)new Json().fromJson(string, DatabaseConfigInfoList.class);
        DatabaseConfigInfo databaseConfigInfo = databaseConfigInfoList.get("HDS");
        if (databaseConfigInfo == null) {
            return true;
        }
        try {
            return this.hasPendingTasks(this.connectionfactory());
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    protected abstract boolean hasPendingTasks(DatabaseConnectionFactory var1) throws SQLException;

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            if (this.hasPendingTasks(this.connectionfactory())) {
                this.execute(metaData);
            }
        }
        catch (SQLException sQLException) {
            throw new StepExecutionException((Throwable)sQLException);
        }
    }

    protected abstract void execute(Map<String, String> var1) throws StepExecutionException;

    protected DatabaseConnectionFactory connectionfactory() {
        return (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
    }
}

