/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.setupwizard.steps.webserver;

import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.basicsteps.defaultwebserver.resources.DefaultResourceExtractor;
import com.inet.setupwizard.basicsteps.updatewebserver.AdditionalActionRequiredException;
import com.inet.setupwizard.basicsteps.webserver.ListenerPortSetter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.SuppressFBWarnings;

public class b {
    private final ListenerPortSetter cD;
    private Path cE;
    private com.inet.helpdesk.plugins.setupwizard.steps.updateproxy.b cF;

    public b(Path path, ListenerPortSetter listenerPortSetter, com.inet.helpdesk.plugins.setupwizard.steps.updateproxy.b b2) {
        if (path == null) {
            throw new IllegalArgumentException("installation directory path must not be null");
        }
        if (listenerPortSetter == null) {
            throw new IllegalArgumentException("listener port setter must not be null");
        }
        this.cF = b2;
        this.cE = path;
        this.cD = listenerPortSetter;
    }

    public void e(String string, String string2) throws StepExecutionException {
        this.as();
        this.g(string, string2);
        this.cD.setPortThatServerIsListeningOnIntoCurrentConfig();
    }

    public void f(String string, String string2) throws AdditionalActionRequiredException, StepExecutionException {
        this.as();
        try {
            this.g(string, string2);
        }
        catch (StepExecutionException stepExecutionException) {
            throw new AdditionalActionRequiredException((Throwable)stepExecutionException);
        }
        this.cF.aq();
    }

    private void as() throws StepExecutionException {
        Path path = this.cE.resolve("Client");
        this.i(path);
    }

    private void g(String string, String string2) throws StepExecutionException {
        Path path = Paths.get(System.getenv("WINDIR"), "system32", "inetsrv", "appcmd.exe");
        boolean bl = Files.isExecutable(path);
        if (!bl) {
            throw new StepExecutionException("The AppCmd.exe command line could not be found");
        }
        String string3 = this.cE.toAbsolutePath().toString();
        this.a(path, "add", "app", "/site.name:Default Web Site", "/path:/" + string, "/physicalPath:" + string3 + "\\Client\\scripts", "/applicationPool:DefaultAppPool");
        this.a(path, "set", "app", "/app.name:Default Web Site/" + string, "/[path='/'].physicalPath:" + string3 + "\\Client\\scripts");
        this.a(path, "unlock", "config", "/section:basicAuthentication");
        this.a(path, "unlock", "config", "/section:windowsAuthentication");
        this.a(path, "set", "config", "/section:staticContent", "/+[fileExtension='.jnlp',mimeType='application/x-java-jnlp-file']");
        this.a(path, "set", "config", "Default Web Site/" + string, "-section:system.webServer/security/authentication/windowsAuthentication", "/enabled:False");
        this.a(path, "set", "config", "Default Web Site/" + string, "-section:system.webServer/security/authentication/basicAuthentication", "/enabled:False");
        this.a(path, "set", "app", "/app.name:Default Web Site/" + string, "/enabledProtocols:" + string2);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="Private API, injection possible, but requires setup-execution (server-access)")
    private void a(Path path, String ... stringArray) throws StepExecutionException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"").append(path.toAbsolutePath().toString()).append("\"");
            for (String string : stringArray) {
                stringBuilder.append(" ").append("\"").append(string).append("\"");
            }
            Process process = Runtime.getRuntime().exec(stringBuilder.toString());
            process.waitFor();
        }
        catch (Exception exception) {
            throw new StepExecutionException((Throwable)exception);
        }
    }

    private void i(Path path) throws StepExecutionException {
        Path path2 = path.resolve("scripts");
        try {
            if (!Files.exists(path2, new LinkOption[0])) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            new DefaultResourceExtractor().copyResourceToDir("web.config", path2);
            new DefaultResourceExtractor().copyResourceToDir("ClientProxy.vb", path2);
            new DefaultResourceExtractor().copyResourceToDir("default.aspx", path2);
            new DefaultResourceExtractor().copyResourceToDir("index.htm", path2);
        }
        catch (IOException iOException) {
            throw new StepExecutionException((Throwable)iOException);
        }
    }
}

