clearreportsApp.run(function(configFactory) {
    configFactory.registerRenderer("TicketFieldSettingsRenderer", {showLabel: false, renderFunction: function () {
        return '<ticketfieldsettings-renderer/>';
    }});
});

clearreportsApp.directive('ticketfieldsettingsRenderer', function ($compile) {


    var linkFunction = function (scope, element, attrs) {
		scope.searchPlaceholder = function () {
            return getMsg("field.tickets.search.placeholder");
        };
        
        scope.searchMatcher = function (item, term, parentCheck) {
            if (term == undefined) {
                return false;
            }
            if (term.length == 0) {
                return true;
            }
            term = term.toLowerCase();
            var terms = term.split(/\s+/);
            for (var i = 0; i < terms.length; i++) {
                var t = terms[i];
                var result = false;
                if (item.fieldsettingsKey != undefined) {
                    if (item.fieldsettingsKey.toLowerCase().indexOf(t) >= 0) {
                        result = true;
                    }
                }
                if (item.fieldLabel != undefined) {
                    if (item.fieldLabel.toLowerCase().indexOf(t) >= 0) {
                        result = true;
                    }
                }
               
                // False if one term is not found
                if (result === false) {
                    return false;
                }
            }
            return true;
        };
        scope.getItemRenderer = function () {
            return '<ticketfieldsettings-item-renderer/>';
        }

        element.html('<list-item-renderer/>');
        $compile($(element).contents())(scope);
    }

    return {
        restrict: 'E',
        link: linkFunction,
        replace: true
    }
});

clearreportsApp.directive('ticketfieldsettingsItemRenderer', function ($rootScope, configFactory, keyservice) {
    var template = '<div class="config-fieldsettings">' +
                    '   <i class="entryicon" ng-class="\'icon-fieldsettings-\'+property.value[$index].fieldIcon"></i>'+
                    '   <div class="entrydetails">'+
                    '       <div class="headline highlightable word-break">{{property.value[$index].fieldLabel + \' (\'+property.value[$index].fieldsettingsKey+\')\'}}</div>'+
                    '       <div class="description">{{property.value[$index].previewDescription}}</div>' +
                    '   </div>' +
                    '   <div class="renderer-hints">' +
                    '       <div class="renderer-hint-danger" ng-if="property.value[$index].ticketFieldVisibility==\'HIDDEN\'" ng-i18n="fieldSettings.hidden"></div>' +
                    '       <div class="renderer-hint-warning" ng-if="property.value[$index].ticketFieldVisibility==\'SUPPORTER\'" ng-i18n="fields.visibility.SUPPORTER"></div>' +
                    '       <div class="renderer-hint-success" ng-if="property.value[$index].fieldsettingsIsCustom==\'true\'" ng-i18n="fieldSettings.isCustom"></div>' +
                    '   </div>' +
                    '</div>';
    var linkFunction = function (scope, element, attrs) {
    };
    return {
        restrict: 'E',
        link: linkFunction,
        template: template,
        replace: true
    }
});
