/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CachedResultSetMetaData
implements ResultSetMetaData {
    private List<ColumnMetaData> columnMeta = new ArrayList<ColumnMetaData>();

    public CachedResultSetMetaData(ResultSetMetaData original) throws SQLException {
        for (int i = 1; i <= original.getColumnCount(); ++i) {
            ColumnMetaData meta = new ColumnMetaData();
            meta.autoIncrement = original.isAutoIncrement(i);
            meta.caseSensisitve = original.isCaseSensitive(i);
            meta.catalogName = original.getCatalogName(i);
            meta.className = original.getColumnClassName(i);
            meta.currency = original.isCurrency(i);
            meta.definitlyWritable = original.isDefinitelyWritable(i);
            meta.displaySize = original.getColumnDisplaySize(i);
            meta.label = original.getColumnLabel(i);
            meta.name = original.getColumnName(i);
            meta.nullable = original.isNullable(i);
            meta.precision = original.getPrecision(i);
            meta.readonly = original.isReadOnly(i);
            meta.scale = original.getScale(i);
            meta.schemaName = original.getSchemaName(i);
            meta.searchable = original.isSearchable(i);
            meta.signed = original.isSigned(i);
            meta.tableName = original.getTableName(i);
            meta.type = original.getColumnType(i);
            meta.typeName = original.getColumnTypeName(i);
            meta.writable = original.isWritable(i);
            this.columnMeta.add(meta);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnMeta.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).caseSensisitve;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).searchable;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).currency;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).signed;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).displaySize;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).label;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).scale;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).catalogName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).readonly;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).writable;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).definitlyWritable;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnMeta.get((int)(column - 1)).className;
    }

    private static class ColumnMetaData {
        private String catalogName;
        private String className;
        private String label;
        private String name;
        private String typeName;
        private String schemaName;
        private String tableName;
        private int displaySize;
        private int nullable;
        private int type;
        private int precision;
        private int scale;
        private boolean autoIncrement;
        private boolean caseSensisitve;
        private boolean currency;
        private boolean definitlyWritable;
        private boolean readonly;
        private boolean searchable;
        private boolean signed;
        private boolean writable;

        private ColumnMetaData() {
        }
    }
}

